package com.elitesland.scp.infr.repo.survey;

import com.elitesland.scp.domain.entity.survey.SurveyPublishDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface SurveyPublishRepo extends JpaRepository<SurveyPublishDO, Long>, QuerydslPredicateExecutor<SurveyPublishDO> {

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    void deleteBySuvId(Long id);

    List<SurveyPublishDO> findBySuvId(Long id);

    List<SurveyPublishDO> findBySuvIdIn(List<Long> suvIdList);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update scp_survey_publish set fill_status = '10' where suv_id = ?1 and ou_code = ?2", nativeQuery = true)
    void updateFillStatusByCode(Long suvId, String regionCode);
}
