package com.elitesland.scp.job.task;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.dto.invwh.InvWhDeliveryRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.job.config.JobConstant;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Component
@Slf4j
public class ScpWhNetRelationHandler {
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    @Autowired
    private ScpWhNetRelationDomainService scpWhNetRelationDomainService;

    @Autowired
    private ScpWhNetRelationService scpWhNetRelationService;

    @Autowired
    private InvWhProvider invWhProvider;

    @Autowired
    private TransactionTemplate transactionTemplate;


    @XxlJob(JobConstant.SCP_STORE_WH_NET_RELATION)
    public ReturnT<String> scpStoreWhNetRelation(String param) {
        log.info("门店供应关系补充定时任务开始");
        try {
            ApiResult<List<OrgStoreRpcDTO>> storeApiResult = orgStoreRpcService.queryAllStoreAddr();

            if (storeApiResult.isFailed()) {
                log.info("全部门店地址信息查询失败或");
                return ReturnT.FAIL;
            }

            List<OrgStoreRpcDTO> storeList = storeApiResult.getData();
            if (CollectionUtils.isEmpty(storeList)) {
                log.info("门店数据为空");
                return ReturnT.SUCCESS;
            }

            List<ScpWhNetRelationRespVO> whNetList = scpWhNetRelationDomainService.findAllNotItem();
            Map<String, List<ScpWhNetRelationRespVO>> whNetMap = whNetList.stream().collect(Collectors.groupingBy(ScpWhNetRelationRespVO::getDemandWhStCode));

            for (OrgStoreRpcDTO store : storeList) {
                InvWhRpcDtoParam invWhRpcDtoParam = new InvWhRpcDtoParam();
                invWhRpcDtoParam.setWhCode(store.getStoreCode());
                invWhRpcDtoParam.setDeliveryPCode(store.getProvince());
                invWhRpcDtoParam.setDeliveryCCode(store.getCity());
                invWhRpcDtoParam.setDeliveryACode(store.getCounty());
                log.info("仓库配送范围查询参数：{}", JSONObject.toJSONString(invWhRpcDtoParam));
                ApiResult<List<InvWhDeliveryRpcDTO>> deliveryWhResult = invWhProvider.findByAllDelivery(invWhRpcDtoParam);
                log.info("仓库配送范围查询结果：{}", JSONObject.toJSONString(deliveryWhResult));
                if (deliveryWhResult.isSuccess() && !CollectionUtils.isEmpty(deliveryWhResult.getData())) {
                    // 仓库配送范围
                    List<InvWhDeliveryRpcDTO> deliveryWhList = deliveryWhResult.getData();

                    // 已经存在的仓网关系
                    List<ScpWhNetRelationRespVO> existWhNetList = whNetMap.get(store.getStoreCode());
                    log.info("已经存在的仓网关系：{}", JSONObject.toJSONString(deliveryWhResult));

                    // 需要重新创建的仓网关系
                    List<ScpWhNetRelationSaveVO.ScpWhNetRelation> saveVoList = new ArrayList<>();
                    deliveryWhList.forEach(wh -> {
                        // 判断仓网关系是否已经存在，不存在，则创建
                        boolean existFlag = existWhNetList.stream().anyMatch(net -> net.getDeliveryType().equals(wh.getDeliveryType()) && net.getSupplyWhCode().equals(wh.getWhCode()));
                        if (!existFlag) {
                            ScpWhNetRelationSaveVO.ScpWhNetRelation saveVO = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
                            saveVO.setType("0");
                            saveVO.setSupplyWhCode(wh.getWhCode());
                            saveVO.setSupplyWhId(wh.getWhId());
                            saveVO.setSupplyWhName(wh.getWhName());
                            saveVO.setSupplyWhOuId(wh.getOuId());
                            saveVO.setSupplyWhOuCode(wh.getOuCode());
                            saveVO.setDemandWhStCode(store.getStoreCode());
                            saveVO.setDemandWhStId(store.getId());
                            saveVO.setDemandWhStName(store.getStoreName());
                            saveVO.setDemandWhStOuId(store.getOuId());
                            saveVO.setDemandWhStOuCode(store.getOuCode());
                            saveVO.setOuCode(wh.getOuCode());
                            saveVO.setDeliveryType(wh.getDeliveryType());
                            saveVO.setSupplyPercentage(BigDecimal.valueOf(100L));
                            saveVO.setStatus(Boolean.TRUE);
                            saveVO.setStartTime(store.getCreateTime());
                            saveVO.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));

                            // 如果配送类型是 直送、甲指乙采、水果，则采购公司赋值，销售公司为空
                            if (ScpConstant.PUR_DELIVERY_TYPES.contains(saveVO.getDeliveryType())) {
                                // 采购公司赋值
                                saveVO.setPurCompanyCode(saveVO.getOuCode());
                                // 销售公司为空
                                saveVO.setOuCode(null);
                                saveVO.setOuName(null);
                            }
                            saveVoList.add(saveVO);
                        }

                        ScpWhNetRelationSaveVO scpWhNetRelationSaveVO = new ScpWhNetRelationSaveVO();
                        scpWhNetRelationSaveVO.setScpWhNetRelations(saveVoList);
                        // 结算路径不存在，跳过不创建
                        scpWhNetRelationSaveVO.setSkipPathFlag(Boolean.TRUE);
                        saveWhNetRelation(scpWhNetRelationSaveVO);
                    });
                }
            }
            log.info("门店供应关系补充定时任务结束");
        } catch (Exception e) {
            log.error("门店供应关系创建定时任务执行失败：", e);
            throw new BusinessException("门店供应关系创建定时任务执行失败:" + e.getMessage());
        }
        return ReturnT.SUCCESS;
    }

    public void saveWhNetRelation(ScpWhNetRelationSaveVO scpWhNetRelationSaveVO) {
        TransactionTemplate requiresNewTemplate = new TransactionTemplate(Objects.requireNonNull(transactionTemplate.getTransactionManager()));
        requiresNewTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        try {
            log.info("保存门店仓网关系开始：{}", JSONObject.toJSON(scpWhNetRelationSaveVO));
            scpWhNetRelationService.saveWhNetRelation(scpWhNetRelationSaveVO);
            log.info("保存门店仓网关系结束：{}", JSONObject.toJSON(scpWhNetRelationSaveVO));
        } catch (Exception e) {
            log.info("保存门店仓网关系失败：{}", JSONObject.toJSON(scpWhNetRelationSaveVO));
        }

    }
}
