package com.elitesland.scp.application.service.mrp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpDPageParam;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDExportRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpThousandUseExportServiceImpl implements DataExport<ScpThousandUseRefVO,ScpThousandUseRefParam> {


    private final ScpThousandUseRefService scpThousandUseRefService;

    @Override
    public String getTmplCode() {
        return "yst_scp_mrp_thousand_use_export";
    }

    @Override
    public PagingVO<ScpThousandUseRefVO> executeExport(ScpThousandUseRefParam param) {
        return scpThousandUseRefService.queryPaging(param);
    }
}
