package com.elitesland.scp.domain.entity.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Data
@ApiModel("采购车")
public class ScpStoreCartDO implements Serializable {

    private static final long serialVersionUID = -329460122107182855L;

    @ApiModelProperty("登录用户ID")
    private Long userId;

    @ApiModelProperty("门店编码")
    private String demandWhStCode;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty("spu-id")
    private Long spuId;

    @ApiModelProperty("spu编码")
    private String spuCode;

    @ApiModelProperty("spu名称")
    private String spuName;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("含税单价")
    private BigDecimal itemPrice;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("是否选中")
    private Integer selectedStatus;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty("基本单位")
    private String uom2;

    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "商品分类")
    private String itemType;

    @ApiModelProperty(value = "配送类型")
    private String itemType2;

    @ApiModelProperty(value = "配送类型")
    private String deliveryType;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "最小起订量")
    private BigDecimal moq;

    private Long activityId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("仓配结算价")
    private BigDecimal costPrice;

    @ApiModelProperty("采购价")
    private BigDecimal purPrice;

    @ApiModelProperty("总价格")
    private BigDecimal price;

    @ApiModelProperty("销售单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("结算单价")
    private BigDecimal settlementPrice;

    @ApiModelProperty("结算货款单价")
    private BigDecimal settlementSalePrice;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty("打折方式")
    private String discountType;
    private String discountTypeName;

    @ApiModelProperty("折扣比例")
    private BigDecimal discount;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("预售状态")
    private Boolean preSaleStatus;

    /**
     * 甲指乙采 业务需要页面手动输入收货地址，购物车保存地址信息，便于取价
     */
    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailAddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;

    public BigDecimal getTotalAmt() {
        if (this.itemPrice != null) {
            return this.itemPrice.multiply(this.qty).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getTotalSettlementAmt() {
        if (this.settlementPrice != null) {
            return this.settlementPrice.multiply(this.qty).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}
