package com.elitesland.scp.domain.entity.msg;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 运营消息接收者.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Entity
@Table(name = "scp_message_receiver", indexes = {
        @Index(name = "idx_scp_msg_rec_msgid", columnList = "messageId"),
        @Index(name = "idx_scp_msg_rec_receiver", columnList = "receiverId"),
})
@Comment("运营消息")
@DynamicInsert
@Getter
@Setter
public class ScpMessageReceiverDO extends BaseModel {
    private static final long serialVersionUID = -7627451721162411028L;

    @Comment(value = "消息ID")
    @Column(nullable = false)
    private Long messageId;

    /**
     * {@link com.elitesland.scp.common.ScpMessageReceiverType}
     */
    @Comment(value = "接收者类型")
    @Column()
    private String receiverType;

    @Comment(value = "接收者ID")
    @Column()
    private String receiverId;

    @Comment(value = "是否已读", defaultValue = "false")
    @Column()
    private Boolean viewed;

    @Comment(value = "阅读时间")
    @Column()
    private LocalDateTime viewTime;
}
