package com.elitesland.scp.application.service.app;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemSpecParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemActivityRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemSpecRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSpuRespVO;

import java.util.List;
import java.util.concurrent.ExecutionException;

public interface AppItemActivityService {


    PagingVO<AppItemActivityRespVO> query(AppItemActivityParamVO paramVO) throws ExecutionException, InterruptedException;

    /**
     * 小程序浏览商品列表
     *
     * @param paramVO
     * @return
     */
    PagingVO<AppItmItemPageVO> itemPage(AppItemPageParamVO paramVO);


    PagingVO<AppItmItemPageVO> skuItemPage(AppItemPageParamVO paramVO);

    /**
     * 小程序商品详情
     *
     * @param paramVO
     * @return
     */
    AppItmSpuRespVO findIdOne(AppItemSpecParamVO paramVO);

    /**
     * 小程序多规格查询
     *
     * @param paramVO
     * @return
     */
    AppItemSpecRespVO specQuery(AppItemSpecParamVO paramVO);

    /**
     * 获取报货商城可见可用商品
     *
     * @param storeCode
     * @param itemCodeList
     * @param scpManType
     * @return
     */
    List<String> getUsefulItemCodeList(String storeCode, List<String> itemCodeList, String scpManType);

    /**
     * 公共浏览商品列表
     *
     * @param paramVO
     * @return
     */
    PagingVO<AppItmItemPageVO> commonItemPage(CommonItemPageParamVO paramVO);

    void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode);

    void getPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type);
}
