package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScmsmanLoginStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityBusinessTypeVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityManager;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.support.provider.item.service.ItemRecvAddressRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
//@Service
@RequiredArgsConstructor
public class ScpsmanAuthprityComponentImportImpl implements ScpsmanAuthorityComponentService {

    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiSysUDCService rmiSysUDCService;

    private final OrgStoreRpcService orgStoreRpcService;
    private final ItemRecvAddressRpcService itemRecvAddressRpcService;
    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityManager scpDemandAuthorityManager;

    @Override
    @SysCodeProc
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("当前登录人查询异常");
        }

        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return PagingVO.<ScpsmanAuthorityComponentVO>builder()
                    .total(0)
                    .records(null)
                    .build();
        }

        List<ScpsmanAuthorityComponentVO> collect = getScpsmanAuthorityComponentVOS(paramVO, scpManAuthorityPageRespVOPagingVO.getRecords());
        return PagingVO.<ScpsmanAuthorityComponentVO>builder()
                .total(scpManAuthorityPageRespVOPagingVO.getTotal())
                .records(collect)
                .build();
    }

    @NotNull
    private List<ScpsmanAuthorityComponentVO> getScpsmanAuthorityComponentVOS(ScpManAuthorityParam paramVO, List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        // 获取业务类型配置
        ScpManAuthorityPageRespVO scpManAuthorityPageRespVO1 = scpManAuthorityPageRespVOPagingVO.get(0);
        String businessTypes = scpManAuthorityPageRespVO1.getBusinessType();
        List<ScpManAuthorityBusinessTypeVO> scpManAuthorityBusinessTypeVOS = new ArrayList<>();
        if (!StringUtils.isBlank(businessTypes)) {
            Map<String, String> businessTypeUDCMap = rmiSysUDCService.getCodeMap("yst-suplan", "BUSINESS_TYPE");

            List<String> businessTypeList = Arrays.stream(businessTypes.split(",")).toList();
            for (String businessType : businessTypeList) {
                ScpOrderSettingRespVO cacheByBusinessType = scpOrderSettingDomainService.findCacheByBusinessType(businessType, String.valueOf(paramVO.getType()));
                ScpManAuthorityBusinessTypeVO scpManAuthorityBusinessTypeVO = new ScpManAuthorityBusinessTypeVO();
                scpManAuthorityBusinessTypeVO.setBusinessType(businessType);
                scpManAuthorityBusinessTypeVO.setBusinessTypeName(businessTypeUDCMap.get(businessType));
                scpManAuthorityBusinessTypeVO.setAllowDiscount(cacheByBusinessType.getAllowDiscount());
                scpManAuthorityBusinessTypeVOS.add(scpManAuthorityBusinessTypeVO);
            }
        }

        List<ScpsmanAuthorityComponentVO> collect = scpManAuthorityPageRespVOPagingVO.stream()
                .map(ScpDemandAuthorityConvert.INSTANCE::pageVoToComponentVo).collect(Collectors.toList());

        // 获取门店信息
        List<String> storeCodeList = collect.stream().map(ScpsmanAuthorityComponentVO::getStWhCode).filter(ObjectUtil::isNotNull).distinct().collect(Collectors.toList());
        // 过滤用户门店
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = getCandidateStoreCodeByUser(userDetails);
        if (!userNames.isEmpty()) {
            // 查询门店
            log.info("查询门店：{}", com.elitescloud.boot.util.JSONUtil.toJsonString(userNames));
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeList(userNames);
            var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            if (CollUtil.isNotEmpty(storeList)) {
                String defStoreCode = storeList.get(0).getStoreCode();
                storeCodeList = List.of(defStoreCode);
                collect = collect.stream().filter(t -> defStoreCode.equals(t.getStWhCode())).collect(Collectors.toList());
            }
        }
        Map<String, OrgStoreBaseRpcDTO> storeMap = rmiOrgStoreRpcService.getOrgStoreBaseMap(storeCodeList);

        collect.stream().filter(t -> storeMap.containsKey(t.getStWhCode())).forEach(t -> {
            OrgStoreBaseRpcDTO orgStoreRpcDTO = storeMap.get(t.getStWhCode());
            t.setStoreType2(orgStoreRpcDTO.getStoreType2());
            //门店客户(子客户)
            t.setStCustCode(orgStoreRpcDTO.getCustCode());
            t.setStCustName(orgStoreRpcDTO.getCustName());
            t.setStWhName(orgStoreRpcDTO.getStoreName());
            t.setBrandCode(orgStoreRpcDTO.getBrandCode());
            t.setStoreOuCode(orgStoreRpcDTO.getOuCode());
            t.setDailyFlag(orgStoreRpcDTO.getDailyFlag());
            t.setPreDailyFlag(orgStoreRpcDTO.getPreDailyFlag());
            t.setHasAddress(itemRecvAddressRpcService.hasAddress(orgStoreRpcDTO.getStoreCode()));
            if (CollectionUtil.isNotEmpty(scpManAuthorityBusinessTypeVOS)) {
                t.setBusinessTypeAuths(scpManAuthorityBusinessTypeVOS);
            }
            if (UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(t.getScpsmanType())) {
                //校验是否已设置密码
                if (orgStoreRpcService.existStorePayPassword(t.getStWhCode()).computeData()) {
                    t.setPasswordSetFlag(Boolean.FALSE);
                } else {
                    t.setPasswordSetFlag(Boolean.TRUE);
                }
            } else {
                t.setPasswordSetFlag(Boolean.FALSE);
            }
        });
        return collect;
    }

    @Override
    public List<ScpsmanAuthorityComponentVO> storeList(ScpManAuthorityParam paramVO) {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("当前登录人查询异常");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = scpDemandAuthorityRepoProc.queryPageDemandAuthorityDistinct(paramVO);
        // 设置区域
        scpDemandAuthorityManager.convertRegionName(scpManAuthorityPageRespVOS, t -> ScpUdcEnum.SCPSMAN_AUTHORITY_TYPE_1.getValueCode().equals(t.getType() + ""),
                ScpManAuthorityPageRespVO::getRegion, ScpManAuthorityPageRespVO::setRegionName);
        return getScpsmanAuthorityComponentVOS(paramVO, scpManAuthorityPageRespVOS);
    }

    @Override
    public List<ScpManAuthorityBusinessTypeVO> businessTypeQuery(ScpManAuthorityParam paramVO) {
        return List.of();
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        //默认查询门店
        paramVO.setType(0L);
        PagingVO<ScpsmanAuthorityComponentVO> scpManAuthorityPageRespVOPagingVO = this.salemansAuthorityComponentPage(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isNotEmpty()) {
            ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO = scpManAuthorityPageRespVOPagingVO.getRecords().get(0);
            log.info("【appQuery】获取当前登录账号对应的计划员权限所属门店结果：{}", JSONUtil.toJsonStr(scpsmanAuthorityComponentVO));
            if(UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode().equals(scpsmanAuthorityComponentVO.getScpsmanType())){
                //校验是否已设置密码
                if(orgStoreRpcService.existStorePayPassword(scpsmanAuthorityComponentVO.getStWhCode()).computeData()){
                    scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.FALSE);
                }else{
                    scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.TRUE);
                }
            }else{
                scpsmanAuthorityComponentVO.setPasswordSetFlag(Boolean.FALSE);
            }
            this.storeTypeQuery(scpsmanAuthorityComponentVO);
            return scpsmanAuthorityComponentVO;
        }
        return null;
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
        OrgStoreDetailRpcDTO byCode = rmiOrgStoreRpcService.getByCode(scpsmanAuthorityComponentVO.getStWhCode());
        if (Objects.nonNull(byCode)) {
            scpsmanAuthorityComponentVO.setStoreType2(byCode.getStoreType2());
            scpsmanAuthorityComponentVO.setStoreType2Name(byCode.getStoreType2Name());
            scpsmanAuthorityComponentVO.setStoreOuCode(byCode.getOuCode());
            if (StringUtils.isBlank(scpsmanAuthorityComponentVO.getStCustCode())){
                //门店客户(子客户)
                scpsmanAuthorityComponentVO.setStCustCode(byCode.getCustCode());
                scpsmanAuthorityComponentVO.setStCustName(byCode.getCustName());

            }
        }
        //查看门店客户的主客户和是否是外部
        if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStCustCode())){
            List<CustBaseDTO> custBaseInfoDTOList = rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode()));
            if (CollectionUtil.isNotEmpty(custBaseInfoDTOList)){
                CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
                //主客户
                scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());

                //主客户的信息
                if (StringUtils.isNotBlank(scpsmanAuthorityComponentVO.getStoreCustCode())){
                    List<CustBaseInfoDTO> custBaseInfoDTOS = rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode()));
                    if (CollectionUtil.isNotEmpty(custBaseInfoDTOS)) {
                        CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                        scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                        if (Objects.equals(custBaseInfoDTO1.getCustType2(),"A")){
                            scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                        }
                    }
                }
            }
        }
    }

    /**
     * 根据当前登陆人,类型查询计划员权限
     *
     * @param paramVO
     * @return
     */
    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        //默认查询启用状态计划员权限
        paramVO.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.listQuery(paramVO);
        if (CollUtil.isEmpty(scpManAuthorityPageRespVOPagingVO)) {
            return new ArrayList();
        }
        return scpManAuthorityPageRespVOPagingVO.stream().map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
    }


    @Override
    public ApiResult<ScmsmanLoginStoreRespVO> getLoginStoreByCurrentUser() {
        var currentUser = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUser)) {
            throw new BusinessException("当前登录人查询异常");
        }

        ScmsmanLoginStoreRespVO respVO = new ScmsmanLoginStoreRespVO();
        respVO.setOnlyOne(false);

        // 先尝试根据登录号和员工编号查询
        GeneralUserDetails userDetails = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        List<String> userNames = getCandidateStoreCodeByUser(userDetails);
        if (userNames.isEmpty()) {
            return ApiResult.ok(respVO);
        }

        // 查询门店
        log.info("查询门店：{}", com.elitescloud.boot.util.JSONUtil.toJsonString(userNames));
        OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
        storeParam.setStoreCodeList(userNames);
        var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
        if (CollUtil.isEmpty(storeList)) {
            return ApiResult.ok(respVO);
        }

        respVO.setStoreCodeDef(storeList.get(0).getStoreCode());
        respVO.setOnlyOne(true);

        return ApiResult.ok(respVO);
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        List<String> userNames = new ArrayList<>(4);

        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank(loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                // 手机号则直接返回
                return Collections.emptyList();
            }

            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank(userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }
}
