package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationExportRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageParamVO;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 26日 19:03
 * @version: 1.0
 */
@Component
@RequiredArgsConstructor
public class ScpSupplyAllocationServiceExportImpl implements DataExport<ScpSupplyAllocationExportRespVO,ScpSupplyAllocationPageParamVO> {

    private final ScpSupplyAllocationService supplyAllocationService;

    @Override
    public String getTmplCode() {
        return "scp_supply_allocation_export";
    }

    @Override
    public PagingVO<ScpSupplyAllocationExportRespVO> executeExport(ScpSupplyAllocationPageParamVO queryParam) {
        return supplyAllocationService.exportSearch(queryParam);
    }



}
