package com.elitesland.scp.domain.entity.item;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
* @description: 供应商送货日历
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_cate_item")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_cate_item", comment = "供应商送货日历")
public class ScpCateItemDO extends BaseModel implements Serializable {

    @Column(name = "cate_id", columnDefinition = "bigint")
    @Comment("分类id")
    private Long cateId;

    @Column(name = "cate_code", columnDefinition = "varchar(64)")
    @Comment("分类CODE")
    private String cateCode;

    @Column(name = "item_id", columnDefinition = "bigint(64)")
    @Comment("商品id")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(30)")
    @Comment("商品code")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar")
    @Comment("商品anme")
    private String itemName;

    @Column(name = "spu_id", columnDefinition = "bigint(30)")
    @Comment("spuId")
    private Long spuId;

    @Column(name = "spu_code", columnDefinition = "varchar(128)")
    @Comment("spuCode")
    private String spuCode;

    @Column(name = "spu_name", columnDefinition = "varchar(128)")
    @Comment("spuName")
    private String spuName;

    @Column(name = "item_type", columnDefinition = "varchar(30)")
    @Comment("商品类型")
    private String itemType;

    @Column(name = "hot_flag", columnDefinition = "tinyint(1)")
    @Comment("热销标识")
    private Boolean hotFlag;

    @Column(name = "brand", columnDefinition = "varchar(64)")
    @Comment("品类树品牌")
    private String brand;

    @Column(name = "root_cate_id", columnDefinition = "bigint")
    @Comment("根分类ID")
    private Long rootCateId;

    @Column(name = "another_name", columnDefinition = "varchar(500)")
    @Comment("别名")
    private String anotherName;

    @Column(name = "sort_no", columnDefinition = "int(6)")
    @Comment("商品排序号")
    private Integer sortNo;

    @Column(name = "item_type2", columnDefinition = "varchar(30)")
    @Comment("商品分类")
    private String itemType2;

    @Column(name = "up_down_status", columnDefinition = "tinyint(1)")
    @Comment("上下架")
    private Boolean upDownStatus;

    @Column(name = "pre_sale_status", columnDefinition = "tinyint(1)")
    @Comment("预售状态")
    private Boolean preSaleStatus;

    @Column(name = "sale_status", columnDefinition = "tinyint(1)")
    @Comment("可售状态")
    private Boolean saleStatus;

    @ApiModelProperty(value = "可售范围生效日期")
    @Comment("可售范围生效时间")
    @Column()
    private LocalDateTime saleDateStart;

    @ApiModelProperty(value = "可售范围失效日期")
    @Comment("可售范围失效时间")
    @Column()
    private LocalDateTime saleDateEnd;

    @Column(name = "visible_status", columnDefinition = "tinyint(1)")
    @Comment("可见状态")
    private Boolean visibleStatus;

    @Column(name = "combine_item_flag", columnDefinition = "tinyint(1)")
    @Comment("组合商品标识")
    private Boolean combineItemFlag;

    @Column(name = "first_letter", columnDefinition = "varchar(40)")
    @Comment("中文首字母")
    private String firstLetter;
}