package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpsmanAuthQueryParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanRegionDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.param.ScpDemandOrderRpcParam;
import com.elitesland.scp.utils.SysUtils;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class ScpDemandOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private final QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
    private final QScpsmanRegionDO scpsmanRegionDO = QScpsmanRegionDO.scpsmanRegionDO;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;
    private static final QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;

    private final QBean<ScpDemandOrderPageRespVO> pageList = Projections.bean(
            ScpDemandOrderPageRespVO.class,
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus,
            scpDemandOrderDO.remark,
            scpDemandOrderDO.businessType,
            scpDemandOrderDDO.id.as("detailId"),
            scpDemandOrderDDO.sourceId,
            scpDemandOrderDDO.supplyType,
            scpDemandOrderDDO.itemCode,
            scpDemandOrderDDO.itemId,
            scpDemandOrderDDO.itemName,
            scpDemandOrderDDO.demandQuantity,
            scpDemandOrderDDO.allocationDeQuantity,
            scpDemandOrderDDO.unit,
            scpDemandOrderDDO.unitName,
            scpDemandOrderDDO.price,
            scpDemandOrderDDO.currency,
            scpDemandOrderDDO.allocationQuantity,
            scpDemandOrderDDO.planQuantity,
            scpDemandOrderDDO.suppWhId,
            scpDemandOrderDDO.suppWhCode,
            scpDemandOrderDDO.suppWhName,
            scpDemandOrderDDO.ouId,
            scpDemandOrderDDO.ouCode,
            scpDemandOrderDDO.ouName,
            scpDemandOrderDDO.srcDocId,
            scpDemandOrderDDO.srcDocNo,
            scpDemandOrderDDO.srcDocCls,
            scpDemandOrderDDO.srcDocLineNo,
            scpDemandOrderDDO.quantity,
            scpDemandOrderDDO.isPushed,
            scpDemandOrderDDO.isCalculated,
            scpDemandOrderDDO.creator,
            scpDemandOrderDDO.createTime,
            scpDemandOrderDDO.createUserId,
            scpDemandOrderDDO.modifyTime,
            scpDemandOrderDDO.modifyUserId,
            scpDemandOrderDDO.updater,
            scpDemandOrderDDO.syncMsg,
            scpDemandOrderDDO.remark.as("ddRemark"),
            scpDemandOrderDDO.uom2,
            scpDemandOrderDDO.uom2Name,
            scpDemandOrderDDO.qty2,
            scpDemandOrderDDO.saleOuCode,
            scpDemandOrderDDO.saleOuName,
            scpDemandOrderDDO.payStatus,
            scpDemandOrderDDO.lineNo,
            scpDemandOrderDDO.settlementPrice,
            scpDemandOrderDDO.settlementAmt,
            scpDemandOrderDDO.recvQty,
            scpDemandOrderDDO.returnQty,
            scpDemandOrderDDO.compensateQty,
            scpDemandOrderDDO.deliveryType,
            scpDemandOrderDDO.costType,
            scpDemandOrderDDO.imgUrl
    );

    private final QBean<ScpDemandOrderTitlePageRespVO> titlePageList = Projections.bean(
            ScpDemandOrderTitlePageRespVO.class,
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus,
            scpDemandOrderDO.apprStatus,
            scpDemandOrderDO.remark,
            scpDemandOrderDO.payStatus,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.createTime,
            scpDemandOrderDO.creator,
            scpDemandOrderDO.updater,
            scpDemandOrderDO.modifyTime,
            scpDemandOrderDO.isCalculated,
            scpDemandOrderDO.isPushed,
            scpDemandOrderDO.businessType,
            scpDemandOrderDO.etaDate,
            scpDemandOrderDO.payDateTime
    );

    private final QBean<ScpDemandOrderDTO> demandOrderList = Projections.bean(
            ScpDemandOrderDTO.class,
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus,
            scpDemandOrderDO.businessType
    );

    public long countDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));

        // 门店权限
        var predicateScpsmanAuth = appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }

        //分区查询字段
//        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDDO.class, paramVO);
//        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public long countDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.selectDistinct(scpDemandOrderDDO.count())
                .from(scpDemandOrderDO)
                .leftJoin(scpDemandOrderDDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));

        // 门店权限
        var predicateScpsmanAuth = appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }

        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        //分区查询字段
        if (paramVO.getIsHeader()) {
            jpaQuery.groupBy(scpDemandOrderDO.id);
        }

        return jpaQuery.fetchCount();
    }

    private Predicate appendScpsmanAuth(ScpsmanAuthQueryParam queryParam) {
        if (Boolean.TRUE.equals(queryParam.getAllRegion())) {
            return null;
        }

        BooleanExpression predicateScpsmanRegion = scpDemandOrderDO.demandWhStCode.in(
                JPAExpressions.select(scpsmanRegionDO.regionCode)
                .from(scpsmanRegionDO)
                .where(
                        scpsmanRegionDO.masId.eq(queryParam.getScpsmanInfoId()).and(scpsmanRegionDO.regionType.eq(com.elitesland.scp.application.enums.ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode()))
                ));
        BooleanExpression predicateRegionStore = CollUtil.isEmpty(queryParam.getRegionStoreCodes()) ? null : scpDemandOrderDO.demandWhStCode.in(queryParam.getRegionStoreCodes());
        if (predicateScpsmanRegion == null) {
            return predicateRegionStore;
        }
        return predicateRegionStore == null ? predicateScpsmanRegion : predicateScpsmanRegion.or(predicateRegionStore);
    }

    public long countDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDO);
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            jpaQuery.where(subQuery.exists());
        }
        return jpaQuery.fetchCount();
    }


    public List<AppDemandOrderCountRespVO> countAppDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.count().as("count")).from(scpDemandOrderDO);
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            jpaQuery.where(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            jpaQuery.where(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            Predicate predicate = scpDemandOrderDDO.isNotNull();
            jpaQuery.where(ExpressionUtils.and(predicate, scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        jpaQuery.groupBy(scpDemandOrderDO.docStatus);
        List<Tuple> tuples = jpaQuery.fetch();
        return tuples.stream().map(tuple -> {
            val orderCountRespVO = new AppDemandOrderCountRespVO();
            orderCountRespVO.setDocStatus(tuple.get(0, String.class));
            orderCountRespVO.setCount(tuple.get(1, Long.class));
            return orderCountRespVO;
        }).collect(Collectors.toList());
    }


    public List<ScpDemandOrderPageRespVO> queryDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));

        // 门店权限
        var predicateScpsmanAuth = appendScpsmanAuth(paramVO);
        if (predicateScpsmanAuth != null) {
            jpaQuery.where(predicateScpsmanAuth);
        }

        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDDO);
        //分区查询字段
//        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDDO.class, paramVO);
//        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<Long> queryIdsByAccount(String account) {
        var subQuery = jpaQueryFactory.select(scpsmanAuthorityDO.id).distinct()
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanInfoDO).on(scpsmanInfoDO.scpsmanNo.eq(scpsmanAuthorityDO.scpsmanNo))
                .where(scpsmanAuthorityDO.enableStatus.eq(Boolean.TRUE).and(scpsmanInfoDO.loginAccount.eq(account)));
        return subQuery.fetch();
    }

    public List<ScpDemandOrderTitlePageRespVO> queryDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.selectDistinct(titlePageList)
                .from(scpDemandOrderDO)
                .leftJoin(scpDemandOrderDDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                ;
        // 门店权限
        var predicateScpsmanStore = appendScpsmanAuth(paramVO);
        if (predicateScpsmanStore != null) {
            jpaQuery.where(predicateScpsmanStore);
        }

        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        //分区查询字段
//        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpDemandOrderPageRespVO.class,
                        scpDemandOrderDO.id,
                        scpDemandOrderDO.type,
                        scpDemandOrderDO.demandId,
                        scpDemandOrderDO.demandCode,
                        scpDemandOrderDO.demandName,
                        scpDemandOrderDO.demandDate,
                        scpDemandOrderDO.demandWhStId,
                        scpDemandOrderDO.demandWhStCode,
                        scpDemandOrderDO.demandWhStName,
                        scpDemandOrderDO.demandDate,
                        scpDemandOrderDO.storeType2,
                        scpDemandOrderDO.docCode,
                        scpDemandOrderDO.docCls,
                        scpDemandOrderDO.docType,
                        scpDemandOrderDO.docStatus,
                        scpDemandOrderDO.payStatus,
                        scpDemandOrderDO.apprStatus,
                        scpDemandOrderDO.remark,
                        scpDemandOrderDO.creator,
                        scpDemandOrderDO.createTime,
                        scpDemandOrderDO.replyFlag,
                        scpDemandOrderDO.businessType,
                        scpDemandOrderDO.etaDate,
                        scpDemandOrderDO.payDateTime
                ))
                .from(scpDemandOrderDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            jpaQuery.where(subQuery.exists());
        }
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));

        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> sumDemandAmt(List<Long> masId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpDemandOrderPageRespVO.class,
                        scpDemandOrderDDO.masId.as("id"),
                        // 只累加 scpDemandOrderDDO.projectFeeFlag是true的行的scpDemandOrderDDO.allocationDeQuantity
                        Expressions.cases()
                                .when(scpDemandOrderDDO.projectFeeFlag.eq(Boolean.FALSE).or(scpDemandOrderDDO.projectFeeFlag.isNull()))
                                .then(scpDemandOrderDDO.allocationDeQuantity)
                                .otherwise(BigDecimal.ZERO).sum().as("demandSumQuantity"),
//                        scpDemandOrderDDO.allocationDeQuantity.coalesce(BigDecimal.ZERO).sum().as("demandSumQuantity"),
                        scpDemandOrderDDO.settlementSaleAmt.coalesce(BigDecimal.ZERO).sum().as("demandSumAmt")
                ))
                .from(scpDemandOrderDDO);
        jpaQuery.where(scpDemandOrderDDO.masId.in(masId));
        jpaQuery.groupBy(scpDemandOrderDDO.masId);
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderDTO> findDemandOrderByParam(ScpDemandOrderParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(demandOrderList)
                .from(scpDemandOrderDO);
        jpaQuery.where(this.whereDemandOrder(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> getItemAndWarehouseByIds(List<Long> ids) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.ouId,
                scpDemandOrderDDO.ouCode,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDDO.planQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.demandWhStId,
                scpDemandOrderDO.demandWhStCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.businessType,
                scpDemandOrderDDO.unit
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.in(ids));
        jpaQuery.where(scpDemandOrderDDO.supplyType.eq(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderInfo(Long demandId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.businessType,
                scpDemandOrderDDO.unit,
                scpDemandOrderDDO.isPushed,
                scpDemandOrderDDO.isCalculated
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.demandId.eq(demandId));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderById(Long id) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.businessType,
                scpDemandOrderDO.allowPayTimeout,
                scpDemandOrderDDO.unit,
                scpDemandOrderDDO.isPushed,
                scpDemandOrderDDO.isCalculated
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.eq(id));
        return jpaQuery.fetch();
    }

    private Predicate whereAppDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like("%" + paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like("%" + paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like("%" + paramVO.getDemandWhStCode() + "%"));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty(paramVO.getCreateTimeTo())) {
            predicates.add(scpDemandOrderDO.createTime.between(paramVO.getCreateTimeFrom(), paramVO.getCreateTimeTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            predicates.add(scpDemandOrderDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            predicates.add(scpDemandOrderDO.businessType.eq(paramVO.getBusinessType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getBusinessTypes())) {
            predicates.add(scpDemandOrderDO.businessType.in(paramVO.getBusinessTypes()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (paramVO.getApprStatus() != null) {
            predicates.add(scpDemandOrderDO.apprStatus.eq(paramVO.getApprStatus()));
        }

        // 如果不是自己创建的单据，则只能看到审批完成和全部推送状态的
        if (paramVO.getCreateUserId() != null) {
            predicates.add(scpDemandOrderDO.createUserId.eq(paramVO.getCreateUserId())
                    .or(scpDemandOrderDO.createUserId.ne(paramVO.getCreateUserId())
                            .and(scpDemandOrderDO.apprStatus.eq(ScpUdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()))
                            .and(scpDemandOrderDO.docStatus.notIn(ScpUdcEnum.DEO_STATUS_WT.getValueCode(),
                                    ScpUdcEnum.DEO_STATUS_DOING.getValueCode(),
                                    ScpUdcEnum.DEO_STATUS_DONE.getValueCode(),
                                    ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode()
                            ))));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            predicates.add(scpDemandOrderDO.businessType.eq(paramVO.getBusinessType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            Predicate predicate = scpDemandOrderDDO.isNotNull();
            predicates.add(ExpressionUtils.and(predicate, scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (CollUtil.isNotEmpty(paramVO.getIdSet())) {
            predicates.add(scpDemandOrderDDO.masId.add(scpDemandOrderDDO.id.coalesce(0L)).in(paramVO.getIdSet()));
        }
        if (StrUtil.isNotBlank(paramVO.getSuppWhCode())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.eq(paramVO.getSuppWhCode()));
        }
        if (CollUtil.isNotEmpty(paramVO.getSuppWhCodes())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.in(paramVO.getSuppWhCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getSupplyType())) {
            predicates.add(scpDemandOrderDDO.supplyType.eq(paramVO.getSupplyType()));
        }
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            predicates.add(scpDemandOrderDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getApprStatus())) {
            predicates.add(scpDemandOrderDO.apprStatus.eq(paramVO.getApprStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty(paramVO.getCreateTimeTo())) {
            predicates.add(scpDemandOrderDO.createTime.between(paramVO.getCreateTimeFrom(), paramVO.getCreateTimeTo()));
        }
        if (paramVO.getCreatorId() != null) {
            predicates.add(scpDemandOrderDO.createUserId.eq(paramVO.getCreatorId()));
        }
        if (paramVO.getIsReceived() != null) {
            if (paramVO.getIsReceived()) {
                predicates.add(scpDemandOrderDDO.recvQty.goe(scpDemandOrderDDO.demandQuantity));
            } else {
                predicates.add(scpDemandOrderDDO.recvQty.isNull().or(scpDemandOrderDDO.recvQty.lt(scpDemandOrderDDO.demandQuantity)));
            }
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrder(ScpDemandOrderParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.eq(paramVO.getDemandCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.eq(paramVO.getDocCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            predicates.add(scpDemandOrderDO.businessType.eq(paramVO.getBusinessType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void updateOrderStatusByCode(String docCode, String status, Boolean isCalculated) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .where(scpDemandOrderDO.docCode.eq(docCode));
        if (isCalculated != null) {
            update.set(scpDemandOrderDO.isCalculated, isCalculated);
        }
        update.execute();
    }

    public void updateOrderStatusById(Long id, String status, Boolean isPushed) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .where(scpDemandOrderDO.id.eq(id));
        if (isPushed != null) {
            update.set(scpDemandOrderDO.isPushed, isPushed);
        }
        update.execute();
    }

    public void updateOrderStatusAndPushedTimeById(Long id, String status, Boolean isPushed, LocalDateTime pushedTime) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .where(scpDemandOrderDO.id.eq(id));
        if (isPushed != null) {
            update.set(scpDemandOrderDO.isPushed, isPushed);
            update.set(scpDemandOrderDO.pushedTime, pushedTime);
        }
        update.execute();
    }

    public void updatePayStatusById(Long id, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.payStatus, status)
                .where(scpDemandOrderDO.id.eq(id));
        update.execute();
    }

    public void updateOrderStatusAndPayStatusById(Long id, String status, String payStatus) {
        String orderSetting = SysUtils.getOrderSetting();

        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .set(scpDemandOrderDO.payStatus, payStatus)
                .where(scpDemandOrderDO.id.eq(id));
        if ("1".equals(orderSetting)) {
            update.set(scpDemandOrderDO.isCalculated, Boolean.TRUE);
        }
        update.execute();
    }

    public long countUnPushedItemByDemandId(Long demandId) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.demandId.eq(demandId));
        jpaQuery.where(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE).and(scpDemandOrderDDO.isCalculated.eq(Boolean.TRUE)));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderDO> findByDemandWhStCodeInAndByCreateTime(List<String> collect, LocalDateTime fromTime, LocalDateTime toTime) {
        JPAQuery<ScpDemandOrderDO> jpaQuery = jpaQueryFactory.select(scpDemandOrderDO)
                .from(scpDemandOrderDO);

        if (CollectionUtil.isNotEmpty(collect)) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.in(collect));
        }
        if (fromTime != null) {
            jpaQuery.where(scpDemandOrderDO.createTime.goe(fromTime));
        }
        if (toTime != null) {
            jpaQuery.where(scpDemandOrderDO.createTime.loe(toTime));
        }
        return jpaQuery.fetch();
    }

    public long countDemandOrderByDemandIds(List<Long> demandIds) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.demandId.in(demandIds));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderComputeVO> findComputeDemandOrderDByParam(List<Long> orderIds) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.ouId,
                scpDemandOrderDDO.ouCode,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDDO.planQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.demandWhStId,
                scpDemandOrderDO.demandWhStCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.businessType,
                scpDemandOrderDDO.unit
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.in(orderIds));
        jpaQuery.where(scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<Long> pageDemandOrderIds(ScpComputeDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.id)
                .from(scpDemandOrderDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.demandId.eq(paramVO.getDemandId()));
        return jpaQuery.fetch();
    }

    public long countAppPayPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            jpaQuery.where(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            jpaQuery.where(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo);
        return jpaQuery.fetchCount();
    }

    public List<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPayOrderPageRespVO.class,
                        scpDemandOrderDDO.srcDocCls,
                        scpDemandOrderDDO.srcDocId,
                        scpDemandOrderDDO.srcDocNo,
                        scpDemandOrderDDO.saleOuName,
                        scpDemandOrderDDO.saleOuCode,
                        scpDemandOrderDDO.masId.as("docId"),
                        scpDemandOrderDDO.payStatus,
                        scpDemandOrderDDO.planAmt.sum().as("amt")
                ))
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        paramVO.setPaging(jpaQuery);
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            jpaQuery.where(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            jpaQuery.where(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo, scpDemandOrderDDO.masId, scpDemandOrderDDO.srcDocCls,
                scpDemandOrderDDO.srcDocId, scpDemandOrderDDO.payStatus, scpDemandOrderDDO.saleOuCode, scpDemandOrderDDO.saleOuName);
        jpaQuery.orderBy(scpDemandOrderDDO.masId.desc());
        return jpaQuery.fetch();
    }

    public List<ScpPayOrderPageRespVO> findDemandOrderByIds(List<Long> ids) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPayOrderPageRespVO.class,
                scpDemandOrderDO.id.as("docId"),
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.docCls,
                scpDemandOrderDO.docType,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.createTime,
                scpDemandOrderDO.businessType
        )).from(scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.id.in(ids));
        return jpaQuery.fetch();
    }

    public AppPayOrderRespVO findPayOrderBySrcDocId(Long srcDocId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(AppPayOrderRespVO.class,
                        scpDemandOrderDDO.srcDocCls,
                        scpDemandOrderDDO.srcDocId,
                        scpDemandOrderDDO.srcDocNo,
                        scpDemandOrderDDO.saleOuCode,
                        scpDemandOrderDDO.saleOuName,
                        scpDemandOrderDDO.masId.as("docId"),
                        scpDemandOrderDDO.payStatus,
                        scpDemandOrderDDO.onlinePayFlag,
                        scpDemandOrderDDO.payerName
                ))
                .from(scpDemandOrderDDO);
        jpaQuery.where(scpDemandOrderDDO.srcDocId.eq(srcDocId));
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo, scpDemandOrderDDO.masId, scpDemandOrderDDO.srcDocCls,
                scpDemandOrderDDO.srcDocId, scpDemandOrderDDO.payStatus, scpDemandOrderDDO.saleOuCode, scpDemandOrderDDO.saleOuName,
                scpDemandOrderDDO.onlinePayFlag, scpDemandOrderDDO.payerName);
        return jpaQuery.fetchOne();
    }
    public List<AppPayOrderRespVO> findPayOrderById(Long id) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(AppPayOrderRespVO.class,
                        scpDemandOrderDDO.srcDocCls,
                        scpDemandOrderDDO.srcDocId,
                        scpDemandOrderDDO.srcDocNo,
                        scpDemandOrderDDO.saleOuCode,
                        scpDemandOrderDDO.saleOuName,
                        scpDemandOrderDDO.masId.as("docId"),
                        scpDemandOrderDDO.payStatus,
                        scpDemandOrderDDO.onlinePayFlag,
                        scpDemandOrderDDO.payerName
                ))
                .from(scpDemandOrderDDO);
        jpaQuery.where(scpDemandOrderDDO.masId.eq(id));
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo, scpDemandOrderDDO.masId, scpDemandOrderDDO.srcDocCls,
                scpDemandOrderDDO.srcDocId, scpDemandOrderDDO.payStatus, scpDemandOrderDDO.saleOuCode, scpDemandOrderDDO.saleOuName,
                scpDemandOrderDDO.onlinePayFlag, scpDemandOrderDDO.payerName);
        return jpaQuery.fetch();
    }


    public Long countAppOrderByParam(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO)
                .where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
                subQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
            }
            jpaQuery.where(subQuery.exists());
        }
        return jpaQuery.fetchOne();
    }

    public String getOrderTypeById(Long id) {
        return jpaQueryFactory.select(scpDemandOrderDO.type)
                .from(scpDemandOrderDO)
                .where(scpDemandOrderDO.id.eq(id))
                .fetchOne();
    }

    public Long countUnReply(Long storeId, LocalDateTime dateTime) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO)
                .where(scpDemandOrderDO.demandWhStId.eq(storeId));
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_RECV.getValueCode()));
        jpaQuery.where(scpDemandOrderDO.replyFlag.eq(Boolean.FALSE));
        jpaQuery.where(scpDemandOrderDO.createTime.goe(dateTime));
        return jpaQuery.fetchCount();
    }

    public void updateAccAmt(ScpDemandOrderRpcParam param) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(scpDemandOrderDO).where(scpDemandOrderDO.id.eq(param.getId()));
        if (param.getCreditAccAmt() != null) {
            updateClause.set(scpDemandOrderDO.creditAccAmt, param.getCreditAccAmt());
        }
        if (param.getFlzhAccAmt() != null) {
            updateClause.set(scpDemandOrderDO.flzhAccAmt, param.getFlzhAccAmt());
        }
        if (param.getStoreAccAmt() != null) {
            updateClause.set(scpDemandOrderDO.storeAccAmt, param.getStoreAccAmt());
        }
        updateClause.execute();
    }

    // 通过商品列表，门店，日期，查询所有状态是已分配的订货单的商品数量
    public Map<Long, BigDecimal> countAllocatedOrderItemByItemCodes(List<Long> itemIds, String storeCode, LocalDateTime dateTime) {
        LocalDateTime startTime = dateTime.with(LocalTime.MIN);
        LocalDateTime endTime = dateTime.with(LocalTime.MAX);
        JPAQuery<Tuple> jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.itemId, scpDemandOrderDDO.demandQuantity.sum())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                .where(scpDemandOrderDDO.itemId.in(itemIds))
                .where(scpDemandOrderDO.demandWhStCode.eq(storeCode))
                .where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()))
                .where(scpDemandOrderDDO.createTime.goe(startTime).and(scpDemandOrderDDO.createTime.loe(endTime)))
                .groupBy(scpDemandOrderDDO.itemId);
        return jpaQuery.fetch().stream().collect(Collectors.toMap(tuple -> tuple.get(0, Long.class), tuple -> tuple.get(1, BigDecimal.class)));
    }

    // 通过商品列表，门店，开始日期，结束日期 ，查询所有状态是已分配的并且商品明细包含这些商品的订货单数量
    public Long countAllocatedOrderByItemCodes(String storeCode, String activeCode, LocalDateTime startTime, LocalDateTime endTime) {
        // 按照activityCode分组，通知scpDemandOrderDO的数量
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.id.countDistinct())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                .where(scpDemandOrderDDO.activityCode.eq(activeCode))
                .where(scpDemandOrderDO.demandWhStCode.eq(storeCode))
//                .where(scpDemandOrderDO.payStatus.eq(ScpUdcEnum.PAY_STATUS_PAYED.getValueCode()))
                .where(scpDemandOrderDO.docStatus.notIn(ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode()
                        , ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode()
                        , ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode()))
                .where(scpDemandOrderDDO.createTime.goe(startTime).and(scpDemandOrderDDO.createTime.loe(endTime)))
                .groupBy(scpDemandOrderDDO.activityCode);
        return jpaQuery.fetchOne();
    }

    // 查询是否有强配商品，并且未支付的订单，有则不能下单
    public List<String> countAllocatedOrderByStoreCode(String storeCode) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.selectDistinct(scpDemandOrderDO.docCode)
                .from(scpDemandOrderDO)
                .innerJoin(scpDemandOrderDDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId).and(scpDemandOrderDDO.activityCode.isNotNull()))
                .where(scpDemandOrderDO.demandWhStCode.eq(storeCode))
                .where(scpDemandOrderDO.docStatus.notIn(ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode()
                        , ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode()
                        , ScpUdcEnum.DEO_STATUS_TIMEOUT.getValueCode()))
                .where(scpDemandOrderDO.payStatus.eq(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode()))
                .where(scpDemandOrderDO.businessType.eq(ScpUdcEnum.BUSINESS_TYPE_40.getValueCode()));
        return jpaQuery.fetch();
    }

    // 通过商品列表，门店，开始日期，结束日期 ，查询所有状态是已分配的并且商品明细包含这些商品的订货单数量
    public Map<String,Long> countAllocatedOrderByStoreCodeList(List<String> storeCodeList, String activeCode, LocalDateTime startTime, LocalDateTime endTime) {
        // 按照activityCode分组，通知scpDemandOrderDO的数量
        JPAQuery<Tuple> jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.demandWhStCode, scpDemandOrderDO.id.countDistinct())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                .where(scpDemandOrderDDO.activityCode.eq(activeCode))
                .where(scpDemandOrderDO.demandWhStCode.in(storeCodeList))
                .where(scpDemandOrderDO.docStatus.notIn(ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(), ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode()))
                .where(scpDemandOrderDDO.createTime.goe(startTime).and(scpDemandOrderDDO.createTime.loe(endTime)))
                .groupBy(scpDemandOrderDO.demandWhStCode);
        return jpaQuery.fetch().stream().collect(Collectors.toMap(tuple -> tuple.get(0, String.class), tuple -> tuple.get(1, Long.class)));
    }

    public void updatePayStatus(ScpDemandOrderRpcParam param) {
        JPAUpdateClause updateClause = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.payStatus, param.getPayStatus());

        if (StrUtil.isNotBlank(param.getDocCode())) {
            updateClause.where(scpDemandOrderDO.docCode.eq(param.getDocCode()));
        }
        if (param.getId() != null) {
            updateClause.where(scpDemandOrderDO.id.eq(param.getId()));
        }
        if (param.getPayDateTime() != null) {
            updateClause.set(scpDemandOrderDO.payDateTime, param.getPayDateTime());
        }

        updateClause.execute();
    }

    public void updateOrderStatusById(Long id, String docStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, docStatus)
                .where(scpDemandOrderDO.id.eq(id));
        update.execute();
    }

    public Long findIdByCode(String docCode) {
        return jpaQueryFactory.select(scpDemandOrderDO.id).from(scpDemandOrderDO)
                .where(scpDemandOrderDO.docCode.eq(docCode)).fetchOne();
    }

    public List<String> findCodeByPayStatus(String payStatus) {
        return jpaQueryFactory.select(scpDemandOrderDO.docCode).from(scpDemandOrderDO)
                .where(scpDemandOrderDO.payStatus.eq(payStatus)).fetch();
    }

    public Boolean existRecvOrderByTroId(Long troId){
        return !jpaQueryFactory
                .select(scpDemandOrderDDO.id)
                .from(scpDemandOrderDDO)
                .where(scpDemandOrderDDO.srcDocId.eq(troId)
                        .and(scpDemandOrderDDO.recvQty.gt(BigDecimal.ZERO))).fetch().isEmpty();
    }
}
