/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.boh;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.scp.application.facade.vo.boh.RtnApplyResult;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveCategoryInfoVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveCategoryVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveConfirmParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnApplyParam;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u95e8\u5e97\u6536\u9000\u8d27\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/applet/rt"}, produces={"application/json"})
public class StoreReceiveController {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveController.class);
    private final StoreReceiveService storeReceiveService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<StoreReceivePageVO>> page(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] page  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.storeReceiveService.page(paramVO));
    }

    @ApiOperation(value="\u5206\u9875\u548c\u8be6\u60c5\u67e5\u8be2")
    @PostMapping(value={"/pageAndDetail"})
    public ApiResult<PagingVO<StoreReceivePageVO>> pageAndDetail(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] pageAndDetail  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.storeReceiveService.pageAndDetail(paramVO));
    }

    @ApiOperation(value="\u5217\u8868\u6309\u7167\u4ed3\u53d1\u548c\u76f4\u53d1\u5206\u7c7b")
    @PostMapping(value={"/classifyByWhOrDirect"})
    public ApiResult<StoreReceiveCategoryVO> classifyByWhOrDirect(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] classifyByWhOrDirect  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok((Object)this.storeReceiveService.classifyByWhOrDirect(paramVO));
    }

    @ApiOperation(value="\u5217\u8868\u6309\u7167\u4ed3\u53d1\u548c\u76f4\u53d1\u5206\u7c7b\u5c55\u793a\u5546\u54c1")
    @PostMapping(value={"/classifyItemByWhOrDirect"})
    public ApiResult<StoreReceiveCategoryInfoVO> classifyItemByWhOrDirect(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] classifyItemByWhOrDirect  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok((Object)this.storeReceiveService.classifyItemByWhOrDirect(paramVO));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public ApiResult<StoreReceiveDetailVO> detail(@RequestParam(value="docId") Long docId) {
        log.info("[SCP-RT] detail  paramVO ={}", (Object)docId);
        return ApiResult.ok((Object)this.storeReceiveService.find(docId));
    }

    @ApiOperation(value="\u6536\u8d27\u786e\u8ba4")
    @PostMapping(value={"/receiveConfirm"})
    public ApiResult<?> receiveConfirm(@RequestBody StoreReceiveConfirmParam paramVO) {
        log.info("[SCP-RT] receiveConfirm  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.storeReceiveService.receiveConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u9000\u8d27\u786e\u8ba4")
    @PostMapping(value={"/rtnConfirm"})
    public ApiResult<?> rtnConfirm(@RequestBody StoreRtnConfirmParam paramVO) {
        log.info("[SCP-RT] rtnConfirm  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.storeReceiveService.rtnConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u9000\u8d27\u7533\u8bf7")
    @PostMapping(value={"/rtnApply"})
    public ApiResult<?> rtnApply(@RequestBody StoreRtnApplyParam paramVO) {
        log.info("[SCP-RT] rtnApply  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.storeReceiveService.rtnApply(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8d54\u4ed8\u7533\u8bf7")
    @PostMapping(value={"/reFundApply"})
    public ApiResult<?> reFundApply(@RequestBody List<StoreRtnApplyParam> paramVOList) {
        log.info("[SCP-RT] reFundApply  paramVOList ={}", (Object)JSONUtil.toJsonStr(paramVOList));
        RtnApplyResult rtnApplyResult = this.storeReceiveService.reFundApply(paramVOList);
        List<RtnApplyResult.FailedRtnApply> failedList = rtnApplyResult.getFailedList();
        if (failedList != null && !failedList.isEmpty()) {
            log.info("[SCP-RT] reFundApply  failedList ={}", (Object)JSONUtil.toJsonStr(failedList));
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u662f\u5426\u53ef\u4ee5\u9000\u5355")
    @GetMapping(value={"/rtnPermission"})
    public ApiResult<Boolean> rtnPermission(@RequestParam(value="orderId") Long orderId) {
        log.info("[SCP-RT] rtnPermission paramVOList ={}", (Object)orderId);
        Boolean b = this.storeReceiveService.rtnPermission(orderId);
        return ApiResult.ok((Object)b);
    }

    @ApiOperation(value="\u901a\u8fc7\u8ba2\u8d27\u5355\u7533\u8bf7\u9000\u8d27")
    @PostMapping(value={"/rtnApplyByOrder"})
    public ApiResult<?> rtnApplyByOrder(@RequestBody List<StoreRtnApplyParam> paramVOList) {
        log.info("[SCP-RT] rtnApplyByOrder  paramVO ={}", (Object)JSONUtil.toJsonStr(paramVOList));
        RtnApplyResult rtnApplyResult = this.storeReceiveService.rtnApplyByOrder(paramVOList);
        List<RtnApplyResult.FailedRtnApply> failedList = rtnApplyResult.getFailedList();
        if (failedList != null && !failedList.isEmpty()) {
            log.info("[SCP-RT] rtnApplyByOrder  failedList ={}", (Object)JSONUtil.toJsonStr(failedList));
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u53ef\u9000\u8d27\u6570\u91cf")
    @GetMapping(value={"/canRtn"})
    public ApiResult<List<StoreCanRtnQtyRpcDTO>> canRtn(@RequestParam(value="docId") Long docId) {
        log.info("[SCP-RT] canRtn  paramVO ={}", (Object)docId);
        List<StoreCanRtnQtyRpcDTO> rpcDTOS = this.storeReceiveService.canRtn(docId);
        return ApiResult.ok(rpcDTOS);
    }

    @ApiOperation(value="\u4f5c\u5e9f")
    @PostMapping(value={"/abort"})
    public ApiResult abort(@RequestParam(value="docId") Long docId) {
        log.info("[SCP-RT] abort  paramVO ={}", (Object)docId);
        this.storeReceiveService.abort(docId);
        return ApiResult.ok();
    }

    public StoreReceiveController(StoreReceiveService storeReceiveService) {
        this.storeReceiveService = storeReceiveService;
    }
}

