/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingDO;
import com.elitesland.scp.domain.entity.purLimit.QScpPurLimitSettingStoreDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpPurLimitSettingStoreRepoProc {
    private static final QScpPurLimitSettingStoreDO scpPurLimitSettingStoreDO = QScpPurLimitSettingStoreDO.scpPurLimitSettingStoreDO;
    private static final QScpPurLimitSettingDO scpPurLimitSettingDO = QScpPurLimitSettingDO.scpPurLimitSettingDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<ScpPurLimitSettingStoreRespVO> pageList;

    public long countPurLimitSettingStore(ScpPurLimitSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scpPurLimitSettingStoreDO.count()).from((EntityPath)scpPurLimitSettingStoreDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpPurLimitSettingStoreRespVO> queryPurLimitSettingStore(ScpPurLimitSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpPurLimitSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpPurLimitSettingStoreDO);
        jpaQuery.where(this.wherePurLimitSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate wherePurLimitSettingPage(ScpPurLimitSettingStorePageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getMasId() != null) {
            predicates.add(ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId.eq((Object)paramVO.getMasId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCode(String storeCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId).distinct()).from((EntityPath)scpPurLimitSettingStoreDO)).where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode.eq((Object)storeCode))).fetch();
    }

    public List<ScpPurLimitSettingStoreRespVO> findByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpPurLimitSettingStoreRespVO.class, (Expression[])new Expression[]{ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.id, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeName, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeType2, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.maxNum, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.activeNum})).from((EntityPath)scpPurLimitSettingStoreDO);
        jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreCode())) {
            jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed().booleanValue()) {
            jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.activeNum.gt((Number)BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpPurLimitSettingStoreRespVO> findEnabledByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpPurLimitSettingStoreRespVO.class, (Expression[])new Expression[]{ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.id, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeName})).from((EntityPath)scpPurLimitSettingStoreDO)).leftJoin((EntityPath)scpPurLimitSettingDO)).on((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId.eq(ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingDO.validTo.goe((Comparable)startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId).distinct()).from((EntityPath)scpPurLimitSettingStoreDO);
        jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId.in(masIds));
        jpaQuery.where((Predicate)ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.activeNum.gt((Number)0));
        return jpaQuery.fetch();
    }

    public ScpPurLimitSettingStoreRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpPurLimitSettingStoreRespVO.class, (Expression[])new Expression[]{ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.id, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.masId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeId, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeCode, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeName, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.storeType2, ScpPurLimitSettingStoreRepoProc.scpPurLimitSettingStoreDO.maxNum});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

