package com.elitesland.scp.mq;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.inv.provider.StoreOrderTrnProvider;
import com.elitesland.scp.application.facade.vo.param.order.StoreReceiveSubmitMqParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveSubmitListener implements MessageQueueListener<StoreReceiveSubmitMqParam> {

    private final RedisTemplate redisTemplate;
    private final StoreOrderTrnProvider storeOrderTrnProvider;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveSubmitMqParam.RECEIVE_SUBMIT_CHANNEL};
    }

    @Override
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSubmitMqParam receiveSubmitMqParam) {
        log.info("门店收货提交操作，参数:{}", JSONUtil.toJsonStr(receiveSubmitMqParam));
//        try {
            storeOrderTrnProvider.receive(receiveSubmitMqParam.getReceiveRpcDTO());
//        } finally {
//            String recvKey = "RECEIVE" + receiveSubmitMqParam.getDocId().toString();
//            log.info("门店收货提交操作完成，开始清楚redis:{}", recvKey);
//            redisTemplate.delete(recvKey);
//        }
    }
}
