/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScpsmanAuthorityManager {
    private static final Logger logger = LoggerFactory.getLogger(ScpsmanAuthorityManager.class);
    @Autowired
    private ScpsmanRegionRepoProc scpsmanRegionRepoProc;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    public Map<String, OrgStoreBaseRpcDTO> queryStoreList(GeneralUserDetails currentUser, @NotNull ScpsmanInfoDO scpsmanInfoDO, int size) {
        return this.queryStoreList(currentUser, scpsmanInfoDO, size, null);
    }

    public Map<String, OrgStoreBaseRpcDTO> queryStoreList(GeneralUserDetails currentUser, @NotNull ScpsmanInfoDO scpsmanInfoDO, int size, String keyword) {
        List storeList;
        OrgStoreBaseRpcParam param;
        List storeList2;
        OrgStoreBaseRpcParam storeParam;
        List userNames;
        if (scpsmanInfoDO == null) {
            return Collections.emptyMap();
        }
        logger.info("\u83b7\u53d6\u6388\u6743\u95e8\u5e97\uff1a{}", (Object)scpsmanInfoDO.getScpsmanNo());
        List<Object> list = userNames = currentUser == null ? Collections.emptyList() : this.getCandidateStoreCodeByUser(currentUser);
        if (!userNames.isEmpty()) {
            logger.info("\u67e5\u8be2\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(userNames));
            storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeList(userNames);
            if (size > 0) {
                storeParam.setLimitSize(Integer.valueOf(size));
            }
            storeList2 = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)storeList2));
            if (CollUtil.isNotEmpty((Collection)storeList2)) {
                HashMap<String, OrgStoreBaseRpcDTO> result = new HashMap<String, OrgStoreBaseRpcDTO>(4);
                result.put(((OrgStoreBaseRpcDTO)storeList2.get(0)).getStoreCode(), (OrgStoreBaseRpcDTO)storeList2.get(0));
                return result;
            }
        }
        if (Boolean.TRUE.equals(scpsmanInfoDO.getJurisdictionAll())) {
            logger.info("\u67e5\u8be2\u6240\u6709\u95e8\u5e97");
            storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeOrName(keyword);
            if (size > 0) {
                storeParam.setLimitSize(Integer.valueOf(size));
            }
            storeList2 = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)storeList2));
            if (CollUtil.isEmpty((Collection)storeList2)) {
                return Collections.emptyMap();
            }
            return storeList2.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1));
        }
        List<ScpsmanRegionBO> scpsmanRegionBoList = this.scpsmanRegionRepoProc.listBoByMasId(scpsmanInfoDO.getId());
        if (scpsmanRegionBoList.isEmpty()) {
            return Collections.emptyMap();
        }
        Set filterStoreCodes = null;
        if (StrUtil.isNotBlank((CharSequence)keyword)) {
            OrgStoreBaseRpcParam storeParam2 = new OrgStoreBaseRpcParam();
            storeParam2.setStoreCodeOrName(keyword);
            List storeList3 = (List)this.orgStoreRpcService.findSimpleStoreByParam(storeParam2).computeData();
            logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)storeList3));
            if (CollUtil.isEmpty((Collection)storeList3)) {
                return Collections.emptyMap();
            }
            filterStoreCodes = storeList3.stream().map(OrgStoreBaseRpcDTO::getStoreCode).collect(Collectors.toSet());
        }
        if (filterStoreCodes == null) {
            filterStoreCodes = Collections.emptySet();
        }
        HashSet<String> storeCodes = new HashSet<String>(16);
        HashSet<String> regionCodes = new HashSet<String>(16);
        for (ScpsmanRegionBO scpsmanRegionBO : scpsmanRegionBoList) {
            if (size > 0 && storeCodes.size() > size) break;
            if (StrUtil.isBlank((CharSequence)scpsmanRegionBO.getRegionCode())) continue;
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode().equals(scpsmanRegionBO.getRegionType())) {
                if (!filterStoreCodes.isEmpty() && !filterStoreCodes.contains(scpsmanRegionBO.getRegionCode())) continue;
                storeCodes.add(scpsmanRegionBO.getRegionCode());
                continue;
            }
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode().equals(scpsmanRegionBO.getRegionType())) {
                regionCodes.add(scpsmanRegionBO.getRegionCode());
                continue;
            }
            logger.error("\u8ba1\u5212\u5458\u6743\u9650\u7c7b\u578b\u9519\u8bef\uff1a{}", (Object)scpsmanRegionBO.getRegionType());
        }
        HashMap<String, OrgStoreBaseRpcDTO> result = new HashMap<String, OrgStoreBaseRpcDTO>(4000);
        if (!storeCodes.isEmpty()) {
            logger.info("\u67e5\u8be2\u7ba1\u7406\u7684\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(storeCodes));
            if (!storeCodes.isEmpty()) {
                param = new OrgStoreBaseRpcParam();
                param.setStoreCodeList(new ArrayList(storeCodes));
                param.setStoreCodeOrName(keyword);
                if (size > 0) {
                    param.setLimitSize(Integer.valueOf(size));
                }
                storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(param).computeData();
                logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)storeList));
                if (CollUtil.isNotEmpty((Collection)storeList)) {
                    result.putAll(storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1)));
                }
                if (size > 0 && result.size() >= size) {
                    return result;
                }
            }
        }
        if (!regionCodes.isEmpty()) {
            logger.info("\u67e5\u8be2\u7ba1\u7406\u533a\u57df\u7684\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(regionCodes));
            param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList(regionCodes));
            param.setStoreCodeOrName(keyword);
            if (size > 0) {
                param.setLimitSize(Integer.valueOf(size));
            }
            storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)storeList));
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                result.putAll(storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1)));
            }
            if (size > 0 && result.size() >= size) {
                return result;
            }
        }
        logger.info("\u67e5\u8be2\u95e8\u5e97\u7ed3\u679c3\uff1a{}", (Object)JSONUtil.toJsonString(result));
        return result;
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        ArrayList<String> userNames = new ArrayList<String>(4);
        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank((CharSequence)loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                return Collections.emptyList();
            }
            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank((CharSequence)userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }
}

