/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderImportEntity;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderImportSaveVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemBatchParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.ValidatedList;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpDemandOrderImportService
implements DataImport<ScpDemandOrderImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderImportService.class);
    private static final String LINE = "\n";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";
    private final TransactionTemplate transactionTemplate;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiItemService rmiItemService;
    private final UdcProvider sysUdcService;
    private final ScpDemandOrderSetService scpDemandOrderSetService;
    private final ScpServiceConfigService scpServiceConfigService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_demand_order_import";
    }

    public List<String> executeImport(List<ScpDemandOrderImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            if (errorMsg != null) {
                log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpDemandOrderImportEntity entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpDemandOrderImportEntity> dataList, int startRowIndex) {
        LinkedHashMap<Integer, String> errMsgMap = new LinkedHashMap<Integer, String>();
        Integer index = 0;
        for (ScpDemandOrderImportEntity entity : dataList) {
            entity.setRowNo(index);
            errMsgMap.put(index, null);
            Integer n = index;
            index = index + 1;
        }
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        HashSet<String> errorDocNumSet = new HashSet<String>();
        List<ScpDemandOrderImportSaveVO> dataToSave = this.prepareData(dataList, errMsgMap, errorDocNumSet);
        log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\uff0c\u51c6\u5907\u597d\u7684\u6570\u636e:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(dataToSave), (Object)JSONUtil.toJsonStr(errMsgMap));
        if (CollUtil.isNotEmpty(dataToSave)) {
            this.transactionTemplate.setPropagationBehavior(3);
            for (ScpDemandOrderImportSaveVO vo : dataToSave) {
                this.transactionTemplate.execute(transactionStatus -> {
                    try {
                        ScpDemandOrderDO scpDemandOrderDO = this.scpDemandOrderService.saveDemandOrder(vo.getHeaderSaveVO());
                        this.scpDemandOrderDService.batchSaveDemandOrderDMgmt(scpDemandOrderDO.getId(), scpDemandOrderDO.getDemandWhStCode(), vo.getDetailSaveVOs(), null);
                    }
                    catch (Exception e) {
                        log.error("\u8ba2\u8d27\u5355\u5bfc\u5165\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
                        transactionStatus.setRollbackOnly();
                    }
                    return null;
                });
            }
            long docNumber = dataList.stream().map(ScpDemandOrderImportEntity::getSeqNo).distinct().count();
            String orderMsg = String.format("\u6587\u4ef6\u5171\u5305\u542b%d\u6761\u6570\u636e\uff0c\u8bc6\u522b\u51fa\u8ba2\u8d27\u5355%d\u5355\uff0c\u5176\u4e2d\u5bfc\u5165\u6210\u529f%d\u5355\uff0c\u5931\u8d25%d\u5355", dataList.size(), docNumber, docNumber - (long)errorDocNumSet.size(), errorDocNumSet.size());
            log.info("\u5199\u5165\u81ea\u5b9a\u4e49\u63d0\u793a\u8bed:{}", (Object)orderMsg);
            HttpServletUtil.currentRequest().setAttribute("orderMsg", (Object)orderMsg);
        }
        return new ArrayList<String>(errMsgMap.values());
    }

    private List<ScpDemandOrderImportSaveVO> prepareData(List<ScpDemandOrderImportEntity> dataList, Map<Integer, String> errMsgMap, Set<String> errorDocNumSet) {
        ArrayList<ScpDemandOrderImportSaveVO> resultList = new ArrayList<ScpDemandOrderImportSaveVO>();
        for (ScpDemandOrderImportEntity data : dataList) {
            if (!Strings.isBlank((String)data.getSeqNo())) continue;
            ScpDemandOrderImportService.addErrMsg(errMsgMap, data.getRowNo(), "\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        Map<String, List<ScpDemandOrderImportEntity>> seqNoMap = dataList.stream().collect(Collectors.groupingBy(ScpDemandOrderImportEntity::getSeqNo));
        Map uomMap = this.sysUdcService.getValueMapByUdcCode("yst-supp", "UOM");
        HashSet docTypeCodeList = new HashSet();
        dataList.forEach(entity -> Optional.ofNullable(entity.getDocTypeCode()).ifPresent(docTypeCodeList::add));
        List<ScpOrderSettingRespVO> enabledSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(new ArrayList<String>(docTypeCodeList), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        Map settingMap = enabledSetting.stream().collect(Collectors.toMap(ScpOrderSettingRespVO::getBusinessType, Function.identity()));
        for (Map.Entry<String, List<ScpDemandOrderImportEntity>> dataEntry : seqNoMap.entrySet()) {
            ScpDemandOrderImportSaveVO scpDemandOrderImportSaveVO = new ScpDemandOrderImportSaveVO();
            ScpDemandOrderSaveVO result = new ScpDemandOrderSaveVO();
            List<ScpDemandOrderImportEntity> importEntityList = dataEntry.getValue();
            ScpDemandOrderImportEntity header = importEntityList.get(0);
            List<Integer> rowNoList = importEntityList.stream().map(ScpDemandOrderImportEntity::getRowNo).collect(Collectors.toList());
            ScpDemandSetSelectRespVO scpDemandSetDTO = this.scpDemandOrderService.getScpDemandSetSelectRespVO(ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), header.getDemandWhStCode());
            result.setDemandId(scpDemandSetDTO.getId());
            result.setDemandCode(scpDemandSetDTO.getDemandCode());
            result.setDemandName(scpDemandSetDTO.getDemandName());
            result.setDemandDate(scpDemandSetDTO.getDemandDate());
            result.setType(scpDemandSetDTO.getType());
            result.setDemandWhStCode(header.getDemandWhStCode());
            result.setDemandWhStName(header.getDemandWhStName());
            String docCls = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(scpDemandSetDTO.getType()) ? ScpUdcEnum.OB_DOC_CLS_ST.getValueCode() : ScpUdcEnum.OB_DOC_CLS_WH.getValueCode();
            result.setDocCls(docCls);
            ScpOrderSettingRespVO scpOrderSettingRespVO = (ScpOrderSettingRespVO)settingMap.get(header.getDocTypeCode());
            if (scpOrderSettingRespVO == null) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u5355\u636e\u7c7b\u578b:" + header.getDocTypeCode() + "\u4e0d\u5b58\u5728");
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            String businessType = scpOrderSettingRespVO.getBusinessType();
            if (Objects.equals(UdcEnum.SALE_SCPSMAN_TYPE_PREPARATION.getValueCode(), scpManType)) {
                if (!Objects.equals(businessType, ScpUdcEnum.BUSINESS_TYPE_20.getValueCode())) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u7b79\u5efa\u53ea\u80fd\u4e0b\u3010\u9996\u6279\u8bbe\u5907\u3011\u7684\u5355\u636e\u7c7b\u578b");
                    errorDocNumSet.add(dataEntry.getKey());
                    continue;
                }
            } else if (Objects.equals(UdcEnum.SALE_SCPSMAN_TYPE_STOREGROUP.getValueCode(), scpManType)) {
                if (!Objects.equals(businessType, ScpUdcEnum.BUSINESS_TYPE_10.getValueCode())) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u95e8\u5e97\u7ec4\u53ea\u80fd\u4e0b\u3010\u65b0\u5e97\u9996\u6279\u7269\u6599\u3011\u7684\u5355\u636e\u7c7b\u578b");
                    errorDocNumSet.add(dataEntry.getKey());
                    continue;
                }
            } else if (Objects.equals(UdcEnum.SALE_SCPSMAN_TYPE_SCPSMAN.getValueCode(), scpManType) && !Objects.equals(businessType, ScpUdcEnum.BUSINESS_TYPE_30.getValueCode())) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u7763\u5bfc\u53ea\u80fd\u4e0b\u3010\u8001\u5e97\u589e\u8865\u3011\u7684\u5355\u636e\u7c7b\u578b");
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            result.setDocType(businessType);
            result.setBusinessType(businessType);
            List<OrgStoreBaseRpcDTO> orgStores = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(List.of(result.getDemandWhStCode()));
            if (CollUtil.isEmpty(orgStores)) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u95e8\u5e97\u7f16\u7801:" + result.getDemandWhStCode() + "\u4e0d\u5b58\u5728");
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStores.get(0);
            Map<String, ScpServiceConfigRespVO> configRespVOMap = this.scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
            log.info("\u8ba2\u8d27\u5355\u5bfc\u5165\u7684configRespVOMap:{}", (Object)JSONUtil.toJsonStr(configRespVOMap));
            if (configRespVOMap == null) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u95e8\u5e97:" + result.getDemandWhStCode() + "\u4fe1\u606f\u672a\u5b8c\u5584");
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            result.setDemandWhStId(orgStoreBaseRpcDTO.getId());
            result.setDemandWhStName(orgStoreBaseRpcDTO.getStoreName());
            result.setStoreLevel(orgStoreBaseRpcDTO.getStoreLevel());
            result.setStoreType2(orgStoreBaseRpcDTO.getStoreType2());
            result.setOuCode(orgStoreBaseRpcDTO.getOuCode());
            result.setBrandCode(orgStoreBaseRpcDTO.getBrandCode());
            scpDemandOrderImportSaveVO.setHeaderSaveVO(result);
            List<String> itemCodes = importEntityList.stream().map(ScpDemandOrderImportEntity::getItemCode).distinct().collect(Collectors.toList());
            List<ItmItemBusinessRpcDTO> itmItemBusinessList = this.rmiItemService.findItmItemBusinessByBUCodeAndBrandAndItemList(result.getOuCode(), result.getBrandCode(), itemCodes);
            Map<String, List<ItmItemBusinessRpcDTO>> itemMap = itmItemBusinessList.stream().collect(Collectors.groupingBy(ItmItemBusinessRpcDTO::getItemCode));
            AtomicBoolean isValid = new AtomicBoolean(true);
            ArrayList<ScpDemandOrderItemParamVO> paramVOList = new ArrayList<ScpDemandOrderItemParamVO>();
            for (ScpDemandOrderImportEntity scpDemandOrderImportEntity : importEntityList) {
                if (scpDemandOrderImportEntity.getDemandQuantity() == null) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, scpDemandOrderImportEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u9700\u6c42\u6570\u91cf", "\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
                    isValid.getAndSet(false);
                    continue;
                }
                if (scpDemandOrderImportEntity.getDemandQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, scpDemandOrderImportEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u9700\u6c42\u6570\u91cf", "\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0"));
                    isValid.getAndSet(false);
                    continue;
                }
                List<ItmItemBusinessRpcDTO> businessItems = itemMap.get(scpDemandOrderImportEntity.getItemCode());
                if (CollUtil.isEmpty(businessItems)) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, scpDemandOrderImportEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u5546\u54c1", "\u5546\u54c1\u7f16\u7801:" + scpDemandOrderImportEntity.getItemCode() + "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728"));
                    isValid.getAndSet(false);
                    continue;
                }
                ItmItemBusinessRpcDTO businessItem = businessItems.get(0);
                ScpDemandOrderItemBatchParamVO.Item item = new ScpDemandOrderItemBatchParamVO.Item();
                item.setItemId(businessItem.getId());
                item.setItemCode(businessItem.getItemCode());
                item.setItemName(businessItem.getItemName());
                item.setItemCateCode(businessItem.getItemCateCode());
                item.setSpuId(businessItem.getSpuId());
                item.setSpuItemCode(businessItem.getSpuCode());
                item.setSpuItemName(businessItem.getSpuName());
                item.setUom(businessItem.getUom2());
                item.setUomName((String)uomMap.get(businessItem.getUom2()));
                item.setDemandQuantity(scpDemandOrderImportEntity.getDemandQuantity());
                item.setQty2(SysUtils.processQtyScale(scpDemandOrderImportEntity.getDemandQuantity().multiply(businessItem.getUomRatio2())));
                item.setUom2(businessItem.getUom());
                item.setUom2Name((String)uomMap.get(businessItem.getUom()));
                item.setDecimalPlaces(businessItem.getDecimalPlaces());
                item.setUomRatio(businessItem.getUomRatio2());
                item.setItemType(businessItem.getItemType2());
                ScpDemandOrderItemParamVO paramVO = new ScpDemandOrderItemParamVO();
                paramVO.setItemCode(item.getItemCode());
                paramVO.setItemName(item.getItemName());
                paramVO.setItemId(item.getItemId());
                paramVO.setSpuId(item.getSpuId());
                paramVO.setSpuItemCode(item.getSpuItemCode());
                paramVO.setSpuItemName(item.getSpuItemName());
                paramVO.setUnit(item.getUom2());
                paramVO.setUnitName(item.getUom2Name());
                paramVO.setDemandQuantity(item.getDemandQuantity());
                paramVO.setUom2(item.getUom());
                paramVO.setUom2Name(item.getUomName());
                paramVO.setUomRatio(item.getUomRatio());
                paramVO.setDecimalPlaces(item.getDecimalPlaces());
                paramVO.setItemType(item.getItemType());
                paramVO.setDeliveryType(item.getItemType());
                paramVO.setDemandWhStCode(result.getDemandWhStCode());
                paramVO.setDemandDate(result.getDemandDate());
                paramVO.setType(result.getType());
                paramVO.setBusinessType(result.getBusinessType());
                paramVOList.add(paramVO);
            }
            if (!isValid.get()) {
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            ArrayList<ScpDemandOrderDRespVO> demandOrderDRespVOS = new ArrayList<ScpDemandOrderDRespVO>(this.scpDemandOrderService.whnetStrategy(paramVOList, orgStoreBaseRpcDTO, scpOrderSettingRespVO));
            if (demandOrderDRespVOS.isEmpty()) {
                ScpDemandOrderImportService.addErrMsg(errMsgMap, rowNoList, "\u5546\u54c1\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u6216\u8005\u4f9b\u5e94\u5546\u4efd\u989d\u83b7\u53d6\u5931\u8d25");
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            log.info("\u83b7\u53d6\u5546\u54c1\u4ed3\u7f51\u5173\u7cfb\u6210\u529f:{}", (Object)JSONUtil.toJsonStr(demandOrderDRespVOS));
            Map<String, List<ScpDemandOrderDRespVO>> itemListBatchMap = demandOrderDRespVOS.stream().collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getItemCode));
            Integer pricePlace = SysUtils.getAppPricePlace();
            for (ScpDemandOrderImportEntity importEntity : importEntityList) {
                List<ScpDemandOrderDRespVO> orderDRespVOS;
                if (Strings.isBlank((String)importEntity.getDiscountType())) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u6298\u6263\u65b9\u5f0f", "\u6298\u6263\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
                    isValid.getAndSet(false);
                    continue;
                }
                if ("1".equals(importEntity.getDiscountType())) {
                    if (importEntity.getDiscount() == null) {
                        ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u6298\u6263\u6bd4\u4f8b", "\u5546\u54c1\u7f16\u7801\u3010" + importEntity.getItemCode() + "\u3011,\u6298\u6263\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"));
                        isValid.getAndSet(false);
                        continue;
                    }
                    if (importEntity.getDiscount().compareTo(new BigDecimal("100")) > 0) {
                        ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u6298\u6263\u6bd4\u4f8b", "\u5546\u54c1\u7f16\u7801\u3010" + importEntity.getItemCode() + "\u3011,\u6298\u6263\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e1"));
                        isValid.getAndSet(false);
                        continue;
                    }
                    if (importEntity.getDiscount().compareTo(BigDecimal.ZERO) <= 0) {
                        ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u6298\u6263\u6bd4\u4f8b", "\u5546\u54c1\u7f16\u7801\u3010" + importEntity.getItemCode() + "\u3011,\u6298\u6263\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0"));
                        isValid.getAndSet(false);
                        continue;
                    }
                } else if ("2".equals(importEntity.getDiscountType()) && importEntity.getSettlementPrice() == null) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u6298\u540e\u8d27\u6b3e\u603b\u5355\u4ef7", "\u5546\u54c1\u7f16\u7801\u3010" + importEntity.getItemCode() + "\u3011,\u6298\u540e\u8d27\u6b3e\u603b\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                    isValid.getAndSet(false);
                    continue;
                }
                if (CollUtil.isEmpty(orderDRespVOS = itemListBatchMap.get(importEntity.getItemCode()))) {
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u5546\u54c1\u4f9b\u8d27\u5173\u7cfb", "\u5546\u54c1\u4f9b\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4"));
                    isValid.getAndSet(false);
                    continue;
                }
                for (ScpDemandOrderDRespVO row2 : orderDRespVOS) {
                    if (row2.getPrice() == null) {
                        ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u4ef7\u683c", "\u5546\u54c1\u7f16\u7801\u3010" + row2.getItemCode() + "\u3011,\u672a\u914d\u7f6e\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f"));
                        isValid.getAndSet(false);
                        continue;
                    }
                    BigDecimal price = row2.getPrice();
                    if (importEntity.getDiscountType() != null) {
                        if ("1".equals(importEntity.getDiscountType())) {
                            if (importEntity.getDiscount() != null) {
                                BigDecimal newSettlePrice = price.multiply(importEntity.getDiscount().divide(new BigDecimal("100"), (int)pricePlace, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                                row2.setSettlementPrice(newSettlePrice);
                                row2.setSettlementSalePrice(null);
                                row2.setDiscount(importEntity.getDiscount());
                                log.info("\u5546\u54c1\u7f16\u7801\u3010{}\u3011,\u6298\u6263\u524d\u4ef7\u683c\u3010{}\u3011,\u6298\u6263\u65b9\u5f0f\u3010{}\u3011,\u6298\u6263\u6bd4\u4f8b\u3010{}\u3011,\u6298\u6263\u540e\u7684\u7ed3\u7b97\u4ef7\u3010{}\u3011", new Object[]{row2.getItemCode(), price, importEntity.getDiscountType(), importEntity.getDiscount(), newSettlePrice});
                            }
                        } else if ("2".equals(importEntity.getDiscountType())) {
                            log.info("\u6253\u6298\u65b9\u5f0f\uff1a{},\u7ed3\u7b97\u5355\u4ef7{}", (Object)importEntity.getDiscountType(), (Object)importEntity.getSettlementPrice());
                            if (importEntity.getSettlementPrice() != null) {
                                BigDecimal settlePrice = importEntity.getSettlementPrice();
                                log.info("\u5546\u54c1\u7f16\u7801\u3010{}\u3011,\u5df2\u914d\u7f6e\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f\uff0c\u5df2\u4fee\u6539\u4e3a\uff1a{}", (Object)row2.getItemCode(), (Object)settlePrice);
                                row2.setSettlementPrice(settlePrice);
                                row2.setSettlementSalePrice(null);
                            }
                        }
                        if (("1".equals(importEntity.getDiscountType()) || "2".equals(importEntity.getDiscountType())) && price.subtract(row2.getSettlementPrice()).compareTo(BigDecimal.ONE) < 0) {
                            ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u4ef7\u683c", "\u5546\u54c1\u7f16\u7801\u3010" + row2.getItemCode() + "\u3011,\u6298\u540e\u5355\u4ef7\u5e94\u4f4e\u4e8e\u539f\u5355\u4ef7\uff0c\u4e14\u6298\u6263\u5dee\u989d\u9700\u5927\u4e8e1\u5143"));
                            isValid.getAndSet(false);
                            continue;
                        }
                    }
                    if (!ScpConstant.PUR_DELIVERY_TYPES.contains(row2.getDeliveryType()) || row2.getSuppId() != null && row2.getSuppCode() != null) continue;
                    ScpDemandOrderImportService.addErrMsg(errMsgMap, importEntity.getRowNo(), MessageFormat.format(ERROR_TEMPLATE, header.getRowNo(), "\u4f9b\u5e94\u5546", "\u76f4\u9001\u5546\u54c1\u7f16\u7801\u3010" + row2.getItemCode() + "\u3011\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546"));
                    isValid.getAndSet(false);
                }
            }
            if (!isValid.get()) {
                errorDocNumSet.add(dataEntry.getKey());
                continue;
            }
            ArrayList<ScpDemandOrderDMgmtSaveVO> mgmtSaveVOS = new ArrayList<ScpDemandOrderDMgmtSaveVO>();
            for (Map.Entry<String, List<ScpDemandOrderDRespVO>> entry : itemListBatchMap.entrySet()) {
                List<ScpDemandOrderDRespVO> value = entry.getValue();
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = value.get(0);
                ScpDemandOrderDMgmtSaveVO saveVO = new ScpDemandOrderDMgmtSaveVO();
                saveVO.setSpuItemName(scpDemandOrderDRespVO.getSpuItemName());
                saveVO.setSpuItemCode(scpDemandOrderDRespVO.getSpuItemCode());
                saveVO.setItemId(scpDemandOrderDRespVO.getItemId());
                saveVO.setItemCode(scpDemandOrderDRespVO.getItemCode());
                saveVO.setItemName(scpDemandOrderDRespVO.getItemName());
                saveVO.setItemType(scpDemandOrderDRespVO.getItemType());
                saveVO.setDeliveryType(scpDemandOrderDRespVO.getDeliveryType());
                saveVO.setDemandQuantity(scpDemandOrderDRespVO.getDemandQuantity());
                saveVO.setCurrency("CNY");
                ValidatedList supplyItemList = value.stream().map(row -> {
                    ScpDemandOrderDMgmtSaveVO.SupplyItem supplyItem = new ScpDemandOrderDMgmtSaveVO.SupplyItem();
                    supplyItem.setRatio(row.getRatio());
                    supplyItem.setAllocationDeQuantity(row.getAllocationDeQuantity());
                    supplyItem.setAllocationQuantity(row.getAllocationQuantity());
                    supplyItem.setSupplyType(row.getSupplyType());
                    supplyItem.setSuppWhId(row.getSuppWhId());
                    supplyItem.setSuppWhCode(row.getSuppWhCode());
                    supplyItem.setSuppWhName(row.getSuppWhName());
                    supplyItem.setSuppId(row.getSuppId());
                    supplyItem.setSuppCode(row.getSuppCode());
                    supplyItem.setSuppName(row.getSuppName());
                    supplyItem.setOuId(row.getOuId());
                    supplyItem.setOuCode(row.getOuCode());
                    supplyItem.setOuName(row.getOuName());
                    supplyItem.setIsCalculated(Boolean.FALSE);
                    supplyItem.setIsPushed(Boolean.FALSE);
                    supplyItem.setUnit(row.getUnit());
                    supplyItem.setUnitName(row.getUnitName());
                    supplyItem.setUom2(row.getUom2());
                    supplyItem.setUom2Name(row.getUom2Name());
                    supplyItem.setUomRatio(row.getUomRatio());
                    supplyItem.setDecimalPlaces(row.getDecimalPlaces());
                    supplyItem.setQty2(row.getQty2());
                    supplyItem.setIsProjFeeCharged(row.getIsProjFeeCharged());
                    supplyItem.setImgUrl(row.getImgUrl());
                    supplyItem.setPrice(row.getPrice());
                    supplyItem.setSettlementPrice(row.getSettlementPrice());
                    supplyItem.setSalePrice(row.getSalePrice());
                    supplyItem.setOefPrice(row.getOefPrice());
                    supplyItem.setMefPrice(row.getMefPrice());
                    supplyItem.setTefPrice(row.getTefPrice());
                    supplyItem.setTefFeeOuCode(row.getTefFeeOuCode());
                    supplyItem.setTefFeeOuName(row.getTefFeeOuName());
                    supplyItem.setOefFeeOuCode(row.getOefFeeOuCode());
                    supplyItem.setOefFeeOuName(row.getOefFeeOuName());
                    supplyItem.setMefFeeOuCode(row.getMefFeeOuCode());
                    supplyItem.setMefFeeOuName(row.getMefFeeOuName());
                    supplyItem.setDiscount(row.getDiscount());
                    supplyItem.setFreightFlag(row.getFreightFlag());
                    supplyItem.setFreightRatio(row.getFreightRatio());
                    supplyItem.setSaleCustCode(row.getSaleCustCode());
                    supplyItem.setSaleOuName(row.getSaleOuName());
                    supplyItem.setSaleOuCode(row.getSaleOuCode());
                    supplyItem.setAllocationQuantity(row.getAllocationQuantity());
                    return supplyItem;
                }).collect(Collectors.toCollection(ValidatedList::new));
                saveVO.setItemList(supplyItemList);
                mgmtSaveVOS.add(saveVO);
            }
            scpDemandOrderImportSaveVO.setDetailSaveVOs(mgmtSaveVOS);
            resultList.add(scpDemandOrderImportSaveVO);
        }
        return resultList;
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, Integer rowNo, String msg) {
        ScpDemandOrderImportService.addErrMsg(errMsgMap, Collections.singletonList(rowNo), msg);
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, List<Integer> rowNos, String msg) {
        for (Integer rowNo : rowNos) {
            if (errMsgMap.containsKey(rowNo) && errMsgMap.get(rowNo) != null) {
                String newMsg = errMsgMap.get(rowNo) + LINE + msg;
                errMsgMap.put(rowNo, newMsg);
                continue;
            }
            errMsgMap.put(rowNo, msg);
        }
    }

    public ScpDemandOrderImportService(TransactionTemplate transactionTemplate, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpDemandSetDomainService scpDemandSetDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiInvStkRpcService rmiInvStkRpcService, RmiItemService rmiItemService, UdcProvider sysUdcService, ScpDemandOrderSetService scpDemandOrderSetService, ScpServiceConfigService scpServiceConfigService, ScpsmanInfoRepo scpsmanInfoRepo) {
        this.transactionTemplate = transactionTemplate;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiItemService = rmiItemService;
        this.sysUdcService = sysUdcService;
        this.scpDemandOrderSetService = scpDemandOrderSetService;
        this.scpServiceConfigService = scpServiceConfigService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
    }
}

