/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAddItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDelParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDPriceSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmUomRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderDServiceImpl
implements ScpDemandOrderDService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDServiceImpl.class);
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RedisTemplate redisClient;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final ItmItemRpcService itmItemRpcService;
    private final ScpServiceConfigService scpServiceConfigService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDMgmtRespVO> findDemandOrderDByMasId(Long masId) {
        List<ScpDemandOrderDDTO> itemList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(masId);
        if (CollUtil.isEmpty(itemList)) {
            return Collections.emptyList();
        }
        Map<String, String> docClsMap = this.rmiSysUDCService.getCodeMap("yst-supp", "DOC_CLS");
        Map<String, String> deoStatus = this.rmiSysUDCService.getCodeMap("yst-suplan", "DEO_STATUS");
        Map<String, String> payStatusMap = this.rmiSysUDCService.getCodeMap(ScpUdcEnum.PAY_STATUS_NO_PAY.getModel(), ScpUdcEnum.PAY_STATUS_WAIT_PAY.getCode());
        Map<String, String> suppTypeMap = this.rmiSysUDCService.getCodeMap(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getModel(), ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getCode());
        ArrayList<ScpDemandOrderDMgmtRespVO> mgmtRespVOS = new ArrayList<ScpDemandOrderDMgmtRespVO>();
        Map<Long, List<ScpDemandOrderDDTO>> soureIdMap = itemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSourceId));
        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : soureIdMap.entrySet()) {
            List<ScpDemandOrderDMgmtRespVO.SupplyItem> supplyItems = entry.getValue().stream().map(row -> {
                ScpDemandOrderDMgmtRespVO.SupplyItem supplyItem = ScpDemandOrderDConvert.INSTANCE.dtoToSupplyItem((ScpDemandOrderDDTO)row);
                supplyItem.setSupplyTypeName((String)suppTypeMap.get(supplyItem.getSupplyType()));
                if (payStatusMap.containsKey(row.getPayStatus())) {
                    supplyItem.setPayStatusName((String)payStatusMap.get(row.getPayStatus()));
                }
                if (docClsMap.containsKey(row.getSrcDocCls())) {
                    supplyItem.setSrcDocClsName((String)docClsMap.get(row.getSrcDocCls()));
                }
                if (ScpConstant.PUR_DELIVERY_TYPES.contains(row.getDeliveryType())) {
                    supplyItem.setSuppId(row.getSuppWhId());
                    supplyItem.setSuppCode(row.getSuppWhCode());
                    supplyItem.setSuppName(row.getSuppWhName());
                }
                if (row.getProjectFeeFlag() != null && row.getProjectFeeFlag().booleanValue()) {
                    supplyItem.setSettlementAmt(BigDecimal.ZERO);
                    supplyItem.setPlanAmt(BigDecimal.ZERO);
                }
                Optional.ofNullable((String)deoStatus.get(row.getStatus())).ifPresent(supplyItem::setStatusName);
                return supplyItem;
            }).collect(Collectors.toList());
            ScpDemandOrderDMgmtRespVO mgmtRespVO = ScpDemandOrderDConvert.INSTANCE.dtoToMgmtRespVO(entry.getValue().get(0));
            mgmtRespVO.setItemList(supplyItems);
            mgmtRespVOS.add(mgmtRespVO);
        }
        return mgmtRespVOS.stream().sorted(Comparator.comparing(ScpDemandOrderDMgmtRespVO::getSrcDocNo, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(BaseViewModel::getCreateTime)).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDemandOrderDMgmt(Long masId, String storeCode, List<ScpDemandOrderDMgmtSaveVO> saveVOS, String source) {
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(storeCode));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = this.scpServiceConfigService.checkServiceConfig(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
        Integer amtPlace = SysUtils.getAmtPlace();
        Integer pricePlace = SysUtils.getAppPricePlace();
        List<ScpDemandOrderDSaveVO> batchSaveVOS = saveVOS.stream().filter(row -> row.getFreightLineFlag() == false).flatMap(entity -> {
            String uuid = UUIDUtil.getUUID();
            return entity.getItemList().stream().map(listItem -> {
                ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = ScpDemandOrderDConvert.INSTANCE.mgmtSaveVoToSaveVo((ScpDemandOrderDMgmtSaveVO.SupplyItem)listItem);
                scpDemandOrderDSaveVO.setMasId(entity.getMasId());
                scpDemandOrderDSaveVO.setSourceId(entity.getSourceId());
                scpDemandOrderDSaveVO.setSpuItemCode(entity.getSpuItemCode());
                scpDemandOrderDSaveVO.setSpuItemName(entity.getSpuItemName());
                scpDemandOrderDSaveVO.setItemId(entity.getItemId());
                scpDemandOrderDSaveVO.setItemCode(entity.getItemCode());
                scpDemandOrderDSaveVO.setItemName(entity.getItemName());
                scpDemandOrderDSaveVO.setCombineItemCode(entity.getCombineItemCode());
                scpDemandOrderDSaveVO.setCombineItemName(entity.getCombineItemName());
                scpDemandOrderDSaveVO.setDemandQuantity(entity.getDemandQuantity());
                scpDemandOrderDSaveVO.setCurrency(entity.getCurrency());
                scpDemandOrderDSaveVO.setRemark(entity.getRemark());
                scpDemandOrderDSaveVO.setPreRootUuid(uuid);
                scpDemandOrderDSaveVO.setItemType(entity.getItemType());
                scpDemandOrderDSaveVO.setDeliveryType(entity.getDeliveryType());
                scpDemandOrderDSaveVO.setActivityId(entity.getActivityId());
                scpDemandOrderDSaveVO.setActivityCode(entity.getActivityCode());
                scpDemandOrderDSaveVO.setMinNum(entity.getMinNum());
                if (ScpConstant.WH_DELIVERY_TYPES.contains(entity.getDeliveryType())) {
                    scpDemandOrderDSaveVO.setSuppWhId(listItem.getSuppWhId());
                    scpDemandOrderDSaveVO.setSuppWhCode(listItem.getSuppWhCode());
                    scpDemandOrderDSaveVO.setSuppWhName(listItem.getSuppWhName());
                } else {
                    if (listItem.getSuppId() == null || listItem.getSuppCode() == null) {
                        throw new BusinessException("\u76f4\u9001\u5546\u54c1\u3010" + entity.getItemName() + "\u3011\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546");
                    }
                    scpDemandOrderDSaveVO.setSuppWhId(listItem.getSuppId());
                    scpDemandOrderDSaveVO.setSuppWhCode(listItem.getSuppCode());
                    scpDemandOrderDSaveVO.setSuppWhName(listItem.getSuppName());
                }
                Long id = listItem.getId() == null || listItem.getId() < 0L ? null : listItem.getId();
                scpDemandOrderDSaveVO.setId(id);
                if (listItem.getSettlementPrice() != null && listItem.getSettlementPrice().compareTo(listItem.getPrice()) != 0) {
                    if (listItem.getPrice().subtract(listItem.getSettlementPrice()).compareTo(BigDecimal.ONE) < 0) {
                        throw new BusinessException("\u6298\u540e\u5355\u4ef7\u5e94\u4f4e\u4e8e\u539f\u5355\u4ef7\uff0c\u4e14\u6298\u6263\u5dee\u989d\u9700\u5927\u4e8e1\u5143");
                    }
                    if (configRespVOMap.get("TECH") != null) {
                        scpDemandOrderDSaveVO.setTefFeeOuCode(((ScpServiceConfigRespVO)configRespVOMap.get("TECH")).getOuCode());
                    }
                    if (configRespVOMap.get("MARKET") != null) {
                        scpDemandOrderDSaveVO.setMefFeeOuCode(((ScpServiceConfigRespVO)configRespVOMap.get("MARKET")).getOuCode());
                    }
                    if (configRespVOMap.get("OPERATE") != null) {
                        scpDemandOrderDSaveVO.setOefFeeOuCode(((ScpServiceConfigRespVO)configRespVOMap.get("OPERATE")).getOuCode());
                    }
                    BigDecimal tefRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : ((ScpServiceConfigRespVO)configRespVOMap.get("TECH")).getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : ((ScpServiceConfigRespVO)configRespVOMap.get("MARKET")).getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : ((ScpServiceConfigRespVO)configRespVOMap.get("OPERATE")).getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal settlementSalePrice = listItem.getSettlementPrice().divide(BigDecimal.ONE.add(tefRatio).add(mefRatio).add(oefRatio), (int)pricePlace, RoundingMode.HALF_UP);
                    listItem.setSettlementSalePrice(settlementSalePrice);
                    scpDemandOrderDSaveVO.setTefPrice(settlementSalePrice.multiply(tefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    scpDemandOrderDSaveVO.setMefPrice(settlementSalePrice.multiply(mefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    scpDemandOrderDSaveVO.setOefPrice(listItem.getSettlementPrice().subtract(settlementSalePrice).subtract(scpDemandOrderDSaveVO.getTefPrice()).subtract(scpDemandOrderDSaveVO.getMefPrice()));
                    scpDemandOrderDSaveVO.setSettlementPrice(listItem.getSettlementPrice());
                } else {
                    scpDemandOrderDSaveVO.setSettlementPrice(listItem.getPrice());
                }
                if (listItem.getSettlementSalePrice() == null) {
                    scpDemandOrderDSaveVO.setSettlementSalePrice(listItem.getSalePrice());
                } else {
                    scpDemandOrderDSaveVO.setSettlementSalePrice(listItem.getSettlementSalePrice());
                }
                if (scpDemandOrderDSaveVO.getSettlementPrice() != null) {
                    scpDemandOrderDSaveVO.setSettlementAmt(SysUtils.processAmtScale(scpDemandOrderDSaveVO.getDemandQuantity().multiply(scpDemandOrderDSaveVO.getSettlementPrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                }
                if (scpDemandOrderDSaveVO.getSettlementSalePrice() != null) {
                    scpDemandOrderDSaveVO.setSettlementSaleAmt(SysUtils.processAmtScale(scpDemandOrderDSaveVO.getDemandQuantity().multiply(scpDemandOrderDSaveVO.getSettlementSalePrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                }
                if (listItem.getPrice() != null) {
                    scpDemandOrderDSaveVO.setDemandAmt(SysUtils.processAmtScale(scpDemandOrderDSaveVO.getDemandQuantity().multiply(listItem.getPrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                    scpDemandOrderDSaveVO.setSaleAmt(SysUtils.processAmtScale(scpDemandOrderDSaveVO.getDemandQuantity().multiply(listItem.getSalePrice()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                }
                scpDemandOrderDSaveVO.setPlanQuantity(entity.getDemandQuantity());
                scpDemandOrderDSaveVO.setDemandQuantity(entity.getDemandQuantity());
                scpDemandOrderDSaveVO.setProjectFeeFlag(Boolean.FALSE);
                Optional.ofNullable(scpDemandOrderDSaveVO.getTefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setTechFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                Optional.ofNullable(scpDemandOrderDSaveVO.getMefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setMarketingFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                Optional.ofNullable(scpDemandOrderDSaveVO.getOefPrice()).ifPresent(price -> scpDemandOrderDSaveVO.setOperationFee(price.multiply(scpDemandOrderDSaveVO.getDemandQuantity()).setScale((int)amtPlace, RoundingMode.HALF_UP)));
                return scpDemandOrderDSaveVO;
            });
        }).collect(Collectors.toList());
        log.info("\u4fdd\u5b58\u9700\u6c42\u8ba2\u5355\u660e\u7ec6\u5f00\u59cb:{}", (Object)JSONUtil.toJsonStr(batchSaveVOS));
        this.batchSaveDemandOrderD(masId, batchSaveVOS, source);
    }

    @Override
    public ScpDemandOrderDPriceRespVO updatePrice(ScpDemandOrderDPriceSaveVO scpDemandOrderDPriceSaveVO) {
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(scpDemandOrderDPriceSaveVO.getStoreCode()));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = this.scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
        ScpDemandOrderDPriceRespVO result = new ScpDemandOrderDPriceRespVO();
        if (configRespVOMap != null) {
            BigDecimal tefRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : configRespVOMap.get("TECH").getFeePercentage().multiply(new BigDecimal("0.01"));
            BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : configRespVOMap.get("MARKET").getFeePercentage().multiply(new BigDecimal("0.01"));
            BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : configRespVOMap.get("OPERATE").getFeePercentage().multiply(new BigDecimal("0.01"));
            BigDecimal settlementSalePrice = scpDemandOrderDPriceSaveVO.getSettlementPrice().divide(BigDecimal.ONE.add(tefRatio).add(mefRatio).add(oefRatio), 2, RoundingMode.HALF_UP);
            result.setSettlementSalePrice(settlementSalePrice);
        } else {
            result.setSettlementSalePrice(scpDemandOrderDPriceSaveVO.getSettlementPrice());
        }
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderDRespVO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO) {
        Page<ScpDemandOrderDDO> page = this.scpDemandOrderDDomainService.pageDemandOrderDByMasId(paramVO);
        List records = page.getContent();
        List<ScpDemandOrderDRespVO> scpDemandOrderDRespVOS = ScpDemandOrderDConvert.INSTANCE.doToRespVO(records);
        ItmItemScpBaseRpcParam itmItemRpcDtoParam = new ItmItemScpBaseRpcParam();
        itmItemRpcDtoParam.setItemIds(scpDemandOrderDRespVOS.stream().map(ScpDemandOrderDRespVO::getItemId).collect(Collectors.toList()));
        Map itemMap = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemRpcDtoParam).stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        Map<String, String> deoStatus = this.rmiSysUDCService.getCodeMap("yst-suplan", "DEO_STATUS");
        AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> saleAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        scpDemandOrderDRespVOS.forEach(row -> {
            if (row.getProjectFeeFlag() != null && row.getProjectFeeFlag().booleanValue()) {
                saleAmt.updateAndGet(v -> v.add(row.getSettlementSaleAmt()));
            } else {
                ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO;
                if (!itemMap.containsKey(row.getItemId())) {
                    return;
                }
                if (row.getSettlementAmt() != null) {
                    amt.updateAndGet(v -> v.add(row.getSettlementAmt()));
                }
                if (row.getSettlementSaleAmt() != null) {
                    saleAmt.updateAndGet(v -> v.add(row.getSettlementSaleAmt()));
                }
                if (deoStatus.containsKey(row.getStatus())) {
                    row.setStatusName((String)deoStatus.get(row.getStatus()));
                }
                try {
                    ApiResult itmUomRpcByItemId = this.itmItemRpcService.findItmUomRpcByItemId(row.getItemId());
                    if (itmUomRpcByItemId != null && itmUomRpcByItemId.isSuccess()) {
                        ItmUomRpcDTO data = (ItmUomRpcDTO)itmUomRpcByItemId.getData();
                        Optional.ofNullable(data).ifPresent(itmUomRpcDTO -> row.setItemUomList(itmUomRpcDTO.getItemUomList()));
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u6570\u636e\u5931\u8d25", (Throwable)e);
                }
                if (row.getDemandQuantity() != null && row.getQuantity() != null) {
                    row.setToDeliveryQty(row.getDemandQuantity().subtract(row.getQuantity()));
                }
                row.setItemAttrName(StrUtil.isBlank((CharSequence)(itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)itemMap.get(row.getItemId())).getItemAttrName()) ? itmItemScpBaseRpcDTO.getSpec() : itmItemScpBaseRpcDTO.getItemAttrName());
                row.setAnotherName(itmItemScpBaseRpcDTO.getAnotherName());
                row.setItemName(itmItemScpBaseRpcDTO.getItemName());
                List skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
                List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
                if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    row.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    row.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
            }
        });
        scpDemandOrderDRespVOS = scpDemandOrderDRespVOS.stream().filter(row -> row.getProjectFeeFlag() == null || row.getProjectFeeFlag() == false).toList();
        if (amt.get().compareTo(saleAmt.get()) != 0) {
            BigDecimal diff = amt.get().subtract(saleAmt.get());
            scpDemandOrderDRespVOS.stream().max(Comparator.comparing(ScpDemandOrderDRespVO::getSettlementAmt)).ifPresent(max -> max.setSettlementAmt(max.getSettlementAmt().subtract(diff)));
        }
        List result = scpDemandOrderDRespVOS.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<ScpDemandOrderDRespVO>> subItemMap = scpDemandOrderDRespVOS.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                ScpDemandOrderDRespVO combineOrderDRespVO = new ScpDemandOrderDRespVO();
                combineOrderDRespVO.setCombineItemCode((String)k);
                combineOrderDRespVO.setCombineItemName(((ScpDemandOrderDRespVO)v.get(0)).getCombineItemName());
                combineOrderDRespVO.setSubItemList((List<ScpDemandOrderDRespVO>)v);
                result.add(combineOrderDRespVO);
            });
        }
        return PagingVO.builder().records(result).total(page.getTotalElements()).build();
    }

    @Override
    public void remove(Long id) {
        List<ScpDemandOrderDDTO> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(id));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u8ba1\u7b97\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (row.getIsPushed().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u63a8\u9001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        this.scpDemandOrderDDomainService.deleteByIds(Arrays.asList(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDemandOrderD(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS) {
        this.batchSaveDemandOrderDInternal(masId, source, saveVOS, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDboDemandOrderD(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS) {
        this.batchSaveDemandOrderDInternal(masId, source, saveVOS, true);
    }

    private void batchSaveDemandOrderDInternal(Long masId, String source, List<ScpDemandOrderDSaveVO> saveVOS, boolean isDbo) {
        List<ScpDemandOrderDSaveVO> modifyDetails = saveVOS.stream().filter(row -> row.getIsPushed() == false).collect(Collectors.toList());
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        this.scpDemandOrderDDomainService.deleteUnPushedItem(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        TimeInterval timer = new TimeInterval();
        modifyDetails.stream().collect(Collectors.groupingBy(ScpDemandOrderDSaveVO::groupByUuid)).forEach((id, list) -> ScpDemandOrderDServiceImpl.distributeDemandQty(list, masId, lineNo));
        log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6\uff0c\u5206\u914d\u8017\u65f6\uff1a{}", (Object)timer.intervalMs());
        if (source != null) {
            this.checkStock(modifyDetails);
        }
        if (isDbo) {
            this.scpDemandOrderDDomainService.batchSaveDboDemanOrderD(modifyDetails, lineNo, source);
        } else {
            this.scpDemandOrderDDomainService.batchSave(modifyDetails, lineNo, source);
        }
        this.scpDemandOrderDomainService.updateAllocStatusAndPayStatusById(masId);
    }

    @Override
    public void saveDemandOrderD(ScpDemandOrderDSaveVO scpDemandOrderDSaveVO) {
        if (Boolean.TRUE.equals(scpDemandOrderDSaveVO.getIsCalculated())) {
            throw new BusinessException(ApiCode.FAIL, "\u6b64\u5546\u54c1\u5df2\u5206\u914d");
        }
        this.scpDemandOrderDDomainService.saveDemandOrderD(scpDemandOrderDSaveVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByParam(ScpDemandOrderDelParamVO paramVO) {
        List<Long> activityIds;
        ScpDemandOrderDTO demandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(paramVO.getMasId()).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        if (paramVO.getDId() == null) {
            List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_DRAFT.getValueCode(), ScpUdcEnum.DEO_STATUS_WT.getValueCode(), ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
            if (!docStatusList.contains(demandOrderDTO.getDocStatus())) {
                throw new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
            return;
        }
        List<ScpDemandOrderDDTO> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByIds(List.of(paramVO.getDId()));
        demandOrderDDTOList.forEach(row -> {
            if (row.getIsCalculated().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u8ba1\u7b97\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (row.getIsPushed().booleanValue()) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0:" + row.getItemName() + "\u5df2\u63a8\u9001\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
        List<Long> sourceIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getSourceId).distinct().collect(Collectors.toList());
        this.scpDemandOrderDDomainService.deleteBySourceIds(sourceIds);
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(paramVO.getMasId());
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            this.scpDemandOrderService.deleteByIds(List.of(paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(activityIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            this.scpAllocSettingStoreDomainService.updateAllocNumByParam(activityIds, demandOrderDTO.getDemandWhStCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addItem(Long masId, List<ScpDemandOrderAddItemParamVO> saveVOS) {
        Optional<ScpDemandOrderRespVO> demandOrderRespVO = this.scpDemandOrderService.findDemandOrderById(masId);
        if (demandOrderRespVO.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderRespVO scpDemandOrderRespVO = demandOrderRespVO.get();
        ArrayList<ScpDemandOrderDSaveVO> scpDemandOrderDSaveVOS = new ArrayList<ScpDemandOrderDSaveVO>();
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(masId);
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        saveVOS.forEach(row -> {
            ScpDemandOrderItemParamVO scpDemandOrderItemParamVO = new ScpDemandOrderItemParamVO();
            scpDemandOrderItemParamVO.setItemId(row.getItemId());
            scpDemandOrderItemParamVO.setItemCode(row.getItemCode());
            scpDemandOrderItemParamVO.setItemName(row.getItemName());
            scpDemandOrderItemParamVO.setSpuItemCode(row.getSpuItemCode());
            scpDemandOrderItemParamVO.setBusinessType(scpDemandOrderRespVO.getBusinessType());
            scpDemandOrderItemParamVO.setType(scpDemandOrderRespVO.getType());
            scpDemandOrderItemParamVO.setDemandWhStCode(scpDemandOrderRespVO.getDemandWhStCode());
            scpDemandOrderItemParamVO.setDemandDate(scpDemandOrderRespVO.getDemandDate());
            scpDemandOrderItemParamVO.setDemandQuantity(row.getDemandQuantity());
            scpDemandOrderItemParamVO.setUnit(row.getUom());
            scpDemandOrderItemParamVO.setUnitName(row.getUomName());
            scpDemandOrderItemParamVO.setSpuItemName(row.getSpuItemName());
            List<ScpDemandOrderDRespVO> itemList = this.scpDemandOrderService.getItemList(scpDemandOrderItemParamVO);
            List<ScpDemandOrderDSaveVO> intentionList = ScpDemandOrderDConvert.INSTANCE.respsVosToSaveVos(itemList);
            ScpDemandOrderDServiceImpl.distributeDemandQty(intentionList, masId, lineNo);
            scpDemandOrderDSaveVOS.addAll(intentionList);
        });
        this.scpDemandOrderDDomainService.batchSave(scpDemandOrderDSaveVOS, lineNo);
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDRespVO> findDemandOrderDBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId).stream().map(ScpDemandOrderDConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
    }

    private static void distributeDemandQty(List<ScpDemandOrderDSaveVO> list, Long masId, AtomicInteger index) {
        String orderSetting = SysUtils.getOrderSetting();
        for (ScpDemandOrderDSaveVO saveVO : list) {
            saveVO.setLineNo(new BigDecimal(index.getAndIncrement()));
            saveVO.setMasId(masId);
            saveVO.setCurrency(StrUtil.isNotBlank((CharSequence)saveVO.getCurrency()) ? saveVO.getCurrency() : "CNY");
            if (!"1".equals(orderSetting)) continue;
            saveVO.setIsCalculated(Boolean.TRUE);
            saveVO.setPlanQuantity(saveVO.getAllocationDeQuantity());
            if (saveVO.getPrice() == null) continue;
            saveVO.setPrice(SysUtils.processPriceScale(saveVO.getPrice()));
            BigDecimal amt = saveVO.getPrice().multiply(saveVO.getPlanQuantity());
            saveVO.setPlanAmt(SysUtils.processAmtScale(amt));
        }
    }

    private void checkStock(List<ScpDemandOrderDSaveVO> scpDemandOrderDSaveVOS) {
        List saveVOList = scpDemandOrderDSaveVOS.stream().filter(row -> row != null && ScpConstant.WH_DELIVERY_TYPES.contains(row.getDeliveryType()) && (row.getPreSaleStatus() == null || row.getPreSaleStatus() == false)).collect(Collectors.toList());
        if (CollUtil.isEmpty(saveVOList)) {
            return;
        }
        List itemIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || row.getFreightLineFlag() == false) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDSaveVO::getItemId).distinct().collect(Collectors.toList());
        List whIds = saveVOList.stream().filter(row -> (row.getFreightLineFlag() == null || row.getFreightLineFlag() == false) && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDSaveVO::getSuppWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
            log.info("\u6821\u9a8c\u5e93\u5b58\u5546\u54c1\u6216\u8005\u4ed3\u5e93\u4e3a\u7a7a,\u65e0\u9700\u67e5\u8be2\u5e93\u5b58");
            return;
        }
        InvWhItemTotalStkRpcParam param = new InvWhItemTotalStkRpcParam();
        param.setWhIds(whIds);
        param.setItemIds(itemIds);
        param.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
        List<InvWhItemTotalStkRpcDTO> stkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(param);
        if (CollUtil.isEmpty(stkRpcDTOS)) {
            throw new BusinessException("\u5546\u54c1\u3010" + ((ScpDemandOrderDSaveVO)saveVOList.get(0)).getItemName() + "\u3011\u5e93\u5b58\u88ab\u62a2\u8d2d\u5b8c\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u8d2d\u7269\u8f66\u5546\u54c1\u518d\u4e0b\u5355");
        }
        Map<String, InvWhItemTotalStkRpcDTO> stkMap = stkRpcDTOS.stream().collect(Collectors.toMap(row -> row.getWhId() + "@" + row.getItemId(), Function.identity()));
        for (ScpDemandOrderDSaveVO saveVO : saveVOList) {
            if (saveVO.getFreightLineFlag() != null && saveVO.getFreightLineFlag().booleanValue() || !ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(saveVO.getSupplyType())) continue;
            this.checkStockAvailability(saveVO, stkMap);
        }
    }

    private void checkStockAvailability(ScpDemandOrderDSaveVO saveVO, Map<String, InvWhItemTotalStkRpcDTO> stkMap) {
        String key = saveVO.getSuppWhId() + "@" + saveVO.getItemId();
        InvWhItemTotalStkRpcDTO invWhItemTotalStkRpcDTO = stkMap.get(key);
        if (invWhItemTotalStkRpcDTO == null) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
        }
        BigDecimal avalQty = invWhItemTotalStkRpcDTO.getAvalQty();
        if (invWhItemTotalStkRpcDTO.getUomRatio() == null) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u8f85\u52a9\u5355\u4f4d\u8f6c\u6362\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saveVO.getPlanQuantity().multiply(invWhItemTotalStkRpcDTO.getUomRatio()).compareTo(avalQty) > 0) {
            throw new BusinessException("\u5546\u54c1\u3010" + saveVO.getItemName() + "\u3011\u5e93\u5b58\u53ef\u7528\u91cf\u4e3a:" + invWhItemTotalStkRpcDTO.getAvalQty2() + ",\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ScpDemandOrderDO submitDemandOrder(Long masId, List<ScpDemandOrderDMgmtSaveVO> saveVOS) {
        ScpDemandOrderDO scpDemandOrderDO = (ScpDemandOrderDO)this.scpDemandOrderRepo.findById(masId).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        if (CollUtil.isNotEmpty(saveVOS)) {
            this.batchSaveDemandOrderDMgmt(masId, scpDemandOrderDO.getDemandWhStCode(), saveVOS, "PC");
        }
        String apprStatus = this.scpDemandOrderService.generateDemandOrderApprStatus(scpDemandOrderDO.getType(), scpDemandOrderDO.getBusinessType());
        scpDemandOrderDO.setApprStatus(apprStatus);
        this.scpDemandOrderRepo.updateApprStatusById(scpDemandOrderDO.getId(), apprStatus);
        if (scpDemandOrderDO.getEtaDate() == null) {
            OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(this.orgStoreRpcService.getByCode(scpDemandOrderDO.getDemandWhStCode())).orElseThrow(() -> new BusinessException("\u95e8\u5e97\u4e0d\u5b58\u5728"));
            Integer expectArrivePriod = orgStore.getExpectArrivePriod();
            scpDemandOrderDO.setEtaDate(LocalDateTime.now().plusDays(expectArrivePriod.intValue()));
            this.scpDemandOrderRepo.updateEtaDateById(scpDemandOrderDO.getId(), scpDemandOrderDO.getEtaDate());
        }
        return scpDemandOrderDO;
    }

    public ScpDemandOrderDServiceImpl(ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDomainService scpDemandOrderDomainService, RmiSysUDCService rmiSysUDCService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, RmiItemService rmiItemService, RmiInvStkRpcService rmiInvStkRpcService, RedisTemplate redisClient, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService, ItmItemRpcService itmItemRpcService, ScpServiceConfigService scpServiceConfigService, OrgStoreRpcService orgStoreRpcService, ScpDemandOrderRepo scpDemandOrderRepo, ScpDemandOrderDRepo scpDemandOrderDRepo) {
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.rmiItemService = rmiItemService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.redisClient = redisClient;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
        this.itmItemRpcService = itmItemRpcService;
        this.scpServiceConfigService = scpServiceConfigService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandOrderRepo = scpDemandOrderRepo;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
    }
}

