/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.utils.ExcelExportUtil;
import com.elitesland.scp.utils.ExcelImportUtil;
import com.elitesland.scp.utils.excel.ExportColumnParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ResourceUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Validated
public abstract class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    private UserService userService;

    protected CurrentUserDTO currentUser() {
        return UserService.currentUser();
    }

    protected ResponseEntity<Resource> downloadExcelTmpl(String tmpl) throws UnsupportedEncodingException {
        if (StrUtil.isBlank((CharSequence)tmpl)) {
            return ResponseEntity.badRequest().build();
        }
        File file = null;
        try {
            file = ResourceUtils.getFile((String)("classpath:excel/" + tmpl));
        }
        catch (FileNotFoundException e) {
            log.error("\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u3010" + tmpl + "\u3011\u5931\u8d25\uff1a", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        HttpHeaders headers = new HttpHeaders();
        String fileName = URLEncoder.encode(tmpl, StandardCharsets.UTF_8).replace(" ", "%20");
        headers.add("Content-Disposition", "attachment;filename*=utf-8''" + fileName);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/vnd.ms-excel")).body((Object)new FileSystemResource(file));
    }

    protected List<?> importExcel(MultipartFile file, Class<?> cls, Integer headRow, Integer dataTypeRow) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new BusinessException("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
        }
        return ExcelImportUtil.instance(file.getInputStream()).headRow(headRow).dataType(cls, dataTypeRow).readAllSync();
    }

    protected <T extends AbstractOrderQueryParam> void export(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList, Function<T, PagingVO<?>> dataProducer, T queryParam) throws Exception {
        this.getExportUtilInstance(response, fileName, columnParamList).write("\u5bfc\u51fa\u6570\u636e", (page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return ((PagingVO)dataProducer.apply(queryParam)).getRecords();
        });
    }

    protected <T extends AbstractOrderQueryParam> void export(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList, BiFunction<T, Object[], PagingVO<?>> dataProducer, T queryParam, Object[] otherParam) throws Exception {
        this.getExportUtilInstance(response, fileName, columnParamList).write("\u5bfc\u51fa\u6570\u636e", (page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return ((PagingVO)dataProducer.apply(queryParam, otherParam)).getRecords();
        });
    }

    private ExcelExportUtil getExportUtilInstance(HttpServletResponse response, String fileName, List<ExportColumnParam> columnParamList) throws Exception {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replace(" ", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        return ExcelExportUtil.instance((OutputStream)response.getOutputStream()).batchSize(200).fields(columnParamList);
    }
}

