/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingStoreConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingStoreDO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingStoreDomainService;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepoProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMinOrderSettingStoreDomainServiceImpl
implements ScpMinOrderSettingStoreDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingStoreDomainServiceImpl.class);
    private final EntityManager entityManager;
    private final ScpMinOrderSettingStoreRepo scpMinOrderSettingStoreRepo;
    private final ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpMinOrderSettingStoreRespVO> page(ScpMinOrderSettingStorePageParamVO paramVO) {
        long count = this.scpMinOrderSettingStoreRepoProc.countMinOrderSettingStore(paramVO);
        if (count > 0L) {
            List<ScpMinOrderSettingStoreRespVO> storeRespVOList = this.scpMinOrderSettingStoreRepoProc.queryMinOrderSettingStore(paramVO);
            return new PagingVO(count, storeRespVOList);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveMinOrderSettingStore(List<ScpMinOrderSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpMinOrderSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpMinOrderSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMinOrderSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(String storeCode) {
        return this.scpMinOrderSettingStoreRepoProc.findMasIdByStoreCode(storeCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMinOrderNumByParam(List<Long> masIds, String storeCode) {
        this.scpMinOrderSettingStoreRepo.updateActiveNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpMinOrderSettingStoreRespVO> findByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        return this.scpMinOrderSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updateMinOrderSettingStore(ScpMinOrderSettingStoreSaveVO saveVO) {
        Optional<ScpMinOrderSettingStoreDO> option = this.scpMinOrderSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u95e8\u5e97ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpMinOrderSettingStoreDO scpMinOrderSettingDO = option.get();
        ScpMinOrderSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpMinOrderSettingDO);
        return ((ScpMinOrderSettingStoreDO)this.scpMinOrderSettingStoreRepo.save(scpMinOrderSettingDO)).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpMinOrderSettingStoreRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingStoreDO> settingStoreDOS = this.scpMinOrderSettingStoreRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            return ScpMinOrderSettingStoreConvert.INSTANCE.dosToRespVOS(settingStoreDOS);
        }
        return new ArrayList<ScpMinOrderSettingStoreRespVO>();
    }

    @Override
    public List<ScpMinOrderSettingStoreRespVO> findEnabledByParam(ScpMinOrderSettingStoreParamVO paramVO) {
        return this.scpMinOrderSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpMinOrderSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpMinOrderSettingStoreDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpMinOrderSettingStoreDomainServiceImpl(EntityManager entityManager, ScpMinOrderSettingStoreRepo scpMinOrderSettingStoreRepo, ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc) {
        this.entityManager = entityManager;
        this.scpMinOrderSettingStoreRepo = scpMinOrderSettingStoreRepo;
        this.scpMinOrderSettingStoreRepoProc = scpMinOrderSettingStoreRepoProc;
    }
}

