package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:11
 * @Description:
 */
@Data
@ApiModel(description = "采购车添加商品")
public class CartAddItemParamVO implements Serializable {

    @ApiModelProperty("门店编码")
    private String demandWhStCode;

    @ApiModelProperty("采购车类型")
    private String cartType;

    private List<ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品SPU_ID")
        private Long spuId;

        @ApiModelProperty("商品SPU编码")
        private String spuCode;

        @ApiModelProperty("商品SPU名称")
        private String spuName;

        @ApiModelProperty("数量")
        BigDecimal qty;

        @ApiModelProperty("含税单价(含服务费)")
        private BigDecimal itemPrice;

        @ApiModelProperty("含税单价(不含服务费)")
        private BigDecimal salePrice;


        @ApiModelProperty("spu规格型号")
        private String spec;

        @ApiModelProperty("图片url")
        private String url;

        @ApiModelProperty(value = "商品品类编码")
        private String itemCateCode;

        @ApiModelProperty(value = "商品品类名称")
        private String itemCateName;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("门店编码")
        private String storeCode;

        @ApiModelProperty("仓配结算价")
        private BigDecimal costPrice;

        @ApiModelProperty("采购价")
        private BigDecimal purPrice;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

    }

}
