/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreChangeParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreRefreshParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreInfoExportVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingRegionSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingStoreSaveVO;
import com.elitesland.scp.application.service.alloc.ScpAllocSettingService;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingStoreDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingBrandDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingRegionDomainService;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.excel.AliasRowWriteHandle;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.dto.SpuImageDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBasePageRpcParam;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ScpAllocSettingServiceImpl
implements ScpAllocSettingService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpAllocSettingDomainService scpAllocSettingDomainService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ScpAllocSettingRegionDomainService scpAllocSettingRegionDomainService;
    private final ScpAllocSettingBrandDomainService scpAllocSettingBrandDomainService;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RedisTemplate<String, Object> redisClient;
    private final ScpAllocSettingRepo scpAllocSettingRepo;
    private final RmiItemService rmiItemService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;
    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;
    private final ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;

    @Override
    public PagingVO<ScpAllocSettingPageRespVO> page(final ScpAllocSettingPageParamVO paramVO) {
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegion()) || StrUtil.isNotBlank((CharSequence)paramVO.getBrand()) || paramVO.getStoreCode() != null || paramVO.getItemId() != null) {
            HashSet<Long> masIds = new HashSet<Long>();
            if (StrUtil.isNotBlank((CharSequence)paramVO.getRegion())) {
                List<Long> regionMasIds = this.scpAllocSettingRegionDomainService.findMasIdByRegionCode(paramVO.getRegion());
                if (CollUtil.isEmpty(regionMasIds)) {
                    return new PagingVO();
                }
                masIds.addAll(regionMasIds);
            }
            if (StrUtil.isNotBlank((CharSequence)paramVO.getBrand())) {
                List<Long> brandMasIds = this.scpAllocSettingBrandDomainService.findMasIdByBrand(paramVO.getBrand(), masIds);
                if (CollUtil.isEmpty(brandMasIds)) {
                    return new PagingVO();
                }
                this.intersectSets(masIds, brandMasIds);
            }
            if (paramVO.getStoreCode() != null) {
                List<Long> storeMasIds = this.scpAllocSettingStoreDomainService.findMasIdByStoreCode((List<String>)new ArrayList<String>(){
                    {
                        this.add(paramVO.getStoreCode());
                    }
                }, masIds);
                if (CollUtil.isEmpty(storeMasIds)) {
                    return new PagingVO();
                }
                this.intersectSets(masIds, storeMasIds);
            }
            if (paramVO.getItemId() != null) {
                List<Long> itemMasIds = this.scpAllocSettingItemDomainService.findMasIdByItemId(paramVO.getItemId(), masIds);
                if (CollUtil.isEmpty(itemMasIds)) {
                    return new PagingVO();
                }
                this.intersectSets(masIds, itemMasIds);
            }
            if (CollectionUtils.isEmpty(masIds)) {
                return new PagingVO();
            }
            paramVO.setIds(new ArrayList<Long>(masIds));
        }
        return this.scpAllocSettingDomainService.queryAllocSettingList(paramVO);
    }

    @Override
    @SysCodeProc
    public ScpAllocSettingRespVO findAllocSettingById(Long id) {
        Optional<ScpAllocSettingRespVO> scpAllocSettingRespVO = this.scpAllocSettingDomainService.findAllocSettingById(id).map(ScpAllocSettingConvert.INSTANCE::dtoToRespVO);
        if (scpAllocSettingRespVO.isPresent()) {
            ScpAllocSettingRespVO allocSettingRespVO = scpAllocSettingRespVO.get();
            allocSettingRespVO.setAllStoreFlag(Boolean.FALSE);
            allocSettingRespVO.setItemRespVOList(this.scpAllocSettingItemDomainService.findByMasId(id));
            allocSettingRespVO.setBrandRespVOList(this.scpAllocSettingBrandDomainService.findByMasId(id));
            allocSettingRespVO.setRegionRespVOList(this.scpAllocSettingRegionDomainService.findByMasId(id));
            allocSettingRespVO.setStoreRespVOList(this.scpAllocSettingStoreDomainService.findByMasId(id));
            if (StrUtil.isNotBlank((CharSequence)allocSettingRespVO.getDocType())) {
                allocSettingRespVO.setDocTypes(StrUtil.split((CharSequence)allocSettingRespVO.getDocType(), (char)','));
            }
            return allocSettingRespVO;
        }
        return new ScpAllocSettingRespVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAllocSetting(ScpAllocSettingSaveVO saveVO) {
        this.checkParam(saveVO);
        if (saveVO.getId() == null) {
            if (CollUtil.isEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
                throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("FA", new ArrayList<String>());
            saveVO.setActivityCode(orderNo);
        } else {
            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setMasIds(List.of(saveVO.getId()));
            scpAllocSettingStoreParamVO.setUsed(Boolean.TRUE);
            List<ScpAllocSettingStoreRespVO> byParam = this.scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            if (CollUtil.isNotEmpty(byParam)) {
                throw new BusinessException("\u6d3b\u52a8\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
        }
        Long masId = this.scpAllocSettingDomainService.saveAllocSetting(saveVO);
        this.scpAllocSettingItemDomainService.deleteByMasId(masId);
        this.scpAllocSettingBrandDomainService.deleteByMasId(masId);
        this.scpAllocSettingRegionDomainService.deleteByMasId(masId);
        saveVO.getRegionList().forEach(row -> row.setMasId(masId));
        this.scpAllocSettingRegionDomainService.batchSaveAllocSettingRegion(saveVO.getRegionList());
        List itemCodes = saveVO.getItemList().stream().map(ScpAllocSettingItemSaveVO::getItemCode).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        saveVO.getItemList().forEach(row -> {
            row.setMasId(masId);
            if (itemRpcDTOMap.containsKey(row.getItemCode())) {
                row.setItemId(((ItmItemRpcDTO)itemRpcDTOMap.get(row.getItemCode())).getId());
            }
        });
        this.scpAllocSettingItemDomainService.batchSaveAllocSettingItem(saveVO.getItemList());
        this.scpAllocSettingStoreDomainService.deleteByMasId(masId);
        if (CollUtil.isNotEmpty(saveVO.getStoreList()) && !saveVO.getAllStoreFlag().booleanValue()) {
            List<ScpAllocSettingStoreSaveVO> storeSaveList = saveVO.getStoreList().stream().collect(Collectors.toMap(ScpAllocSettingStoreSaveVO::getStoreCode, Function.identity(), (existing, replacement) -> replacement)).values().stream().toList();
            storeSaveList.forEach(row -> {
                row.setMasId(masId);
                row.setId(null);
            });
            this.scpAllocSettingStoreDomainService.batchSaveAllocSettingStore(storeSaveList);
            this.refreshRedisValue(saveVO, masId, storeSaveList, itemRpcDTOMap);
        }
        if (CollUtil.isEmpty(saveVO.getStoreList()) && saveVO.getAllStoreFlag().booleanValue()) {
            this.saveDefaultStore(saveVO, masId, itemRpcDTOMap);
        }
        String key = "SCP:ALLOC:SETTING:" + masId;
        if (!LocalDateTime.now().isAfter(saveVO.getValidTo())) {
            long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), saveVO.getValidTo());
            LocalDateTime validFrom = saveVO.getValidFrom();
            String jsonString = JSON.toJSONString((Object)validFrom);
            this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
        }
        this.scpAllocSettingDomainService.enableAllocSetting(List.of(masId), Boolean.TRUE);
        return masId;
    }

    private void refreshRedisValue(ScpAllocSettingSaveVO saveVO, Long masId, List<ScpAllocSettingStoreSaveVO> storeList, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
        ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO>();
        for (ScpAllocSettingItemSaveVO item : saveVO.getItemList()) {
            ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpAllocSettingRedisDO.ActivityDO.InnerItemDO();
            innerItemDO.setItemCode(item.getItemCode());
            innerItemDO.setMasId(masId);
            innerItemDO.setMinNum(item.getMinNum());
            innerItemDO.setItemType2(item.getItemType2());
            if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemRpcDTOMap.get(item.getItemCode());
                List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                    innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
                innerItemDO.setItemId(itmItemRpcDTO.getId());
                innerItemDO.setItemName(itmItemRpcDTO.getItemName());
            }
            innerItemDOS.add(innerItemDO);
        }
        for (ScpAllocSettingStoreSaveVO store : storeList) {
            ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
            Object obj = this.redisClient.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + store.getStoreCode()));
            if (obj == null) {
                ScpAllocSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                scpAllocSettingRedisDO.setActivityList(List.of(activityDO1));
            } else {
                String str = (String)obj;
                ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
                List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
                Boolean flag = Boolean.FALSE;
                for (ScpAllocSettingRedisDO.ActivityDO inActivityDO : activityList) {
                    if (!inActivityDO.getActivityId().equals(masId)) continue;
                    inActivityDO.setActivityId(masId);
                    inActivityDO.setActivityCode(saveVO.getActivityCode());
                    inActivityDO.setDocTypes(saveVO.getDocTypes());
                    inActivityDO.setMaxNum(store.getMaxNum());
                    inActivityDO.setAllocNum(0);
                    inActivityDO.setValidTo(saveVO.getValidTo());
                    inActivityDO.setValidFrom(saveVO.getValidFrom());
                    inActivityDO.setInnerItemDOS(innerItemDOS);
                    flag = Boolean.TRUE;
                }
                if (!flag.booleanValue()) {
                    ScpAllocSettingRedisDO.ActivityDO activityDO1 = this.createActivityDO(masId, saveVO, store, innerItemDOS);
                    activityList.add(activityDO1);
                }
                scpAllocSettingRedisDO.setActivityList(activityList);
            }
            String key = "SCP:ALLOC:SETTING:" + store.getStoreCode();
            redisMap.put((CallSite)((Object)key), JSONUtil.toJsonStr((Object)scpAllocSettingRedisDO));
        }
        this.redisClient.opsForValue().multiSet(redisMap);
    }

    private ScpAllocSettingRedisDO.ActivityDO createActivityDO(Long masId, ScpAllocSettingSaveVO saveVO, ScpAllocSettingStoreSaveVO store, List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS) {
        ScpAllocSettingRedisDO.ActivityDO activityDO = new ScpAllocSettingRedisDO.ActivityDO();
        activityDO.setInnerItemDOS(innerItemDOS);
        activityDO.setActivityId(masId);
        activityDO.setActivityCode(saveVO.getActivityCode());
        activityDO.setDocTypes(saveVO.getDocTypes());
        activityDO.setMaxNum(store.getMaxNum());
        activityDO.setAllocNum(0);
        activityDO.setValidFrom(saveVO.getValidFrom());
        activityDO.setValidTo(saveVO.getValidTo());
        return activityDO;
    }

    private void saveDefaultStore(ScpAllocSettingSaveVO saveVO, Long masId, Map<String, ItmItemRpcDTO> itemRpcDTOMap) {
        if (saveVO.getMaxAllocNum() == null) {
            throw new BusinessException("\u6700\u5927\u5f3a\u914d\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List regionList = saveVO.getRegionList().stream().map(ScpAllocSettingRegionSaveVO::getRegion).distinct().collect(Collectors.toList());
        OrgStoreBasePageRpcParam orgStoreBasePageRpcParam = new OrgStoreBasePageRpcParam();
        orgStoreBasePageRpcParam.setRegionList(regionList);
        Long count = this.rmiOrgStoreRpcService.countBaseStoreByParam(orgStoreBasePageRpcParam);
        if (count == null || count == 0L) {
            log.info("saveDefaultStore\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u95e8\u5e97\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Integer totalPage = PageUtil.totalPage((long)count, (int)1000);
        for (int i = 1; i <= totalPage; ++i) {
            orgStoreBasePageRpcParam.setSize(Integer.valueOf(1000));
            orgStoreBasePageRpcParam.setCurrent(Integer.valueOf(i));
            PagingVO<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOPagingVO = this.rmiOrgStoreRpcService.queryBaseStore(orgStoreBasePageRpcParam);
            List<ScpAllocSettingStoreSaveVO> storeSaveVOS = orgStoreBaseRpcDTOPagingVO.getRecords().stream().map(row -> {
                ScpAllocSettingStoreSaveVO scpAllocSettingStoreSaveVO = new ScpAllocSettingStoreSaveVO();
                scpAllocSettingStoreSaveVO.setStoreId(row.getId());
                scpAllocSettingStoreSaveVO.setStoreCode(row.getStoreCode());
                scpAllocSettingStoreSaveVO.setStoreName(row.getStoreName());
                scpAllocSettingStoreSaveVO.setStoreType2(row.getStoreType2());
                scpAllocSettingStoreSaveVO.setMasId(masId);
                scpAllocSettingStoreSaveVO.setMaxNum(saveVO.getMaxAllocNum());
                return scpAllocSettingStoreSaveVO;
            }).collect(Collectors.toList());
            this.scpAllocSettingStoreDomainService.batchSaveAllocSettingStore(storeSaveVOS, 1000);
            this.refreshRedisValue(saveVO, masId, storeSaveVOS, itemRpcDTOMap);
        }
    }

    private void checkParam(ScpAllocSettingSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getRegionList())) {
            throw new BusinessException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(saveVO.getItemList())) {
            throw new BusinessException("\u5f3a\u914d\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isNotEmpty(saveVO.getStoreList())) {
            HashSet<String> storeCodes = new HashSet<String>();
            for (ScpAllocSettingStoreSaveVO store : saveVO.getStoreList()) {
                if (storeCodes.add(store.getStoreCode())) continue;
                throw new BusinessException("\u95e8\u5e97\u7f16\u7801 " + store.getStoreCode() + " \u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingDomainService.deleteByIds(ids);
        List keys = ids.stream().map(row -> "SCP:ALLOC:SETTING:" + row).collect(Collectors.toList());
        this.redisClient.delete(keys);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeAllocSettingStatus(ScpAllocSettingStatusParamVO paramVO) {
        if (Boolean.TRUE.equals(paramVO.getStatus())) {
            ScpAllocSettingStoreParamVO scpAllocSettingStoreParamVO = new ScpAllocSettingStoreParamVO();
            scpAllocSettingStoreParamVO.setMasIds(paramVO.getIds());
            List<ScpAllocSettingStoreRespVO> storeRespVOList = this.scpAllocSettingStoreDomainService.findByParam(scpAllocSettingStoreParamVO);
            if (CollUtil.isEmpty(storeRespVOList)) {
                throw new BusinessException("\u95e8\u5e97\u4fe1\u606f\u672a\u7ef4\u62a4");
            }
            List<ScpAllocSettingDO> settingDOS = this.scpAllocSettingRepo.findByIdIn(paramVO.getIds());
            for (ScpAllocSettingDO settingDO : settingDOS) {
                String key = "SCP:ALLOC:SETTING:" + settingDO.getId();
                if (LocalDateTime.now().isAfter(settingDO.getValidTo())) continue;
                long between = ChronoUnit.MINUTES.between(LocalDateTime.now(), settingDO.getValidTo());
                LocalDateTime validFrom = settingDO.getValidFrom();
                String jsonString = JSON.toJSONString((Object)validFrom);
                this.redisClient.opsForValue().set((Object)key, (Object)jsonString, between, TimeUnit.MINUTES);
                List<ScpAllocSettingItemRespVO> itemList = this.scpAllocSettingItemDomainService.findByMasId(settingDO.getId());
                List itemCodes = itemList.stream().map(ScpAllocSettingItemRespVO::getItemCode).distinct().collect(Collectors.toList());
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
                ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO>();
                for (ScpAllocSettingItemRespVO item : itemList) {
                    ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpAllocSettingRedisDO.ActivityDO.InnerItemDO();
                    innerItemDO.setItemCode(item.getItemCode());
                    innerItemDO.setMasId(settingDO.getId());
                    innerItemDO.setMinNum(item.getMinNum());
                    innerItemDO.setItemType2(item.getItemType2());
                    if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                        List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                        if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                            innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                        innerItemDO.setItemId(itmItemRpcDTO.getId());
                        innerItemDO.setItemName(itmItemRpcDTO.getItemName());
                    }
                    innerItemDOS.add(innerItemDO);
                }
                HashMap<CallSite, String> redisMap = new HashMap<CallSite, String>();
                for (ScpAllocSettingStoreRespVO store : storeRespVOList) {
                    ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
                    Object obj = this.redisClient.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + store.getStoreCode()));
                    if (obj != null) continue;
                    ScpAllocSettingRedisDO.ActivityDO activityDO1 = new ScpAllocSettingRedisDO.ActivityDO();
                    activityDO1.setActivityId(settingDO.getId());
                    activityDO1.setActivityCode(settingDO.getActivityCode());
                    activityDO1.setDocTypes(StrUtil.split((CharSequence)settingDO.getDocType(), (CharSequence)","));
                    activityDO1.setMaxNum(store.getMaxNum());
                    activityDO1.setAllocNum(0);
                    activityDO1.setInnerItemDOS(innerItemDOS);
                    activityDO1.setValidFrom(settingDO.getValidFrom());
                    activityDO1.setValidTo(settingDO.getValidTo());
                    scpAllocSettingRedisDO.setActivityList(List.of(activityDO1));
                    String storeKey = "SCP:ALLOC:SETTING:" + store.getStoreCode();
                    String jsonString2 = JSON.toJSONString((Object)scpAllocSettingRedisDO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    redisMap.put((CallSite)((Object)storeKey), jsonString2);
                }
                if (!CollUtil.isNotEmpty(redisMap)) continue;
                this.redisClient.opsForValue().multiSet(redisMap);
            }
        } else {
            List keys = paramVO.getIds().stream().map(row -> "SCP:ALLOC:SETTING:" + row).collect(Collectors.toList());
            this.redisClient.delete(keys);
        }
        this.scpAllocSettingDomainService.enableAllocSetting(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    public void storeRefresh(ScpAllocSettingStoreRefreshParamVO paramVO) {
        List<ScpAllocSettingStoreDO> allByStoreCodeIn = this.scpAllocSettingStoreRepo.findAllByStoreCodeIn(paramVO.getStoreCodes());
        if (CollUtil.isEmpty(allByStoreCodeIn)) {
            return;
        }
        Map<String, List<ScpAllocSettingStoreDO>> storeAndAllocStoreList = allByStoreCodeIn.stream().collect(Collectors.groupingBy(ScpAllocSettingStoreDO::getStoreCode));
        List<Long> allocIdList = storeAndAllocStoreList.values().stream().flatMap(v -> v.stream().map(ScpAllocSettingStoreDO::getMasId)).toList();
        List<ScpAllocSettingDO> byIdIn = this.scpAllocSettingRepo.findByIdIn(allocIdList);
        Map collect1 = byIdIn.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        HashMap redisMap = new HashMap();
        storeAndAllocStoreList.forEach((storeCode, allocIds) -> {
            ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
            String storeKey = "SCP:ALLOC:SETTING:" + storeCode;
            for (ScpAllocSettingStoreDO allocId : allocIds) {
                ScpAllocSettingDO settingDO = (ScpAllocSettingDO)collect1.get(allocId.getMasId());
                if (settingDO == null) continue;
                List<ScpAllocSettingItemRespVO> itemList = this.scpAllocSettingItemDomainService.findByMasId(settingDO.getId());
                List itemCodes = itemList.stream().map(ScpAllocSettingItemRespVO::getItemCode).distinct().collect(Collectors.toList());
                ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
                Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
                ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = new ArrayList<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO>();
                for (ScpAllocSettingItemRespVO item : itemList) {
                    ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO = new ScpAllocSettingRedisDO.ActivityDO.InnerItemDO();
                    innerItemDO.setItemCode(item.getItemCode());
                    innerItemDO.setMasId(settingDO.getId());
                    innerItemDO.setMinNum(item.getMinNum());
                    innerItemDO.setItemType2(item.getItemType2());
                    if (itemRpcDTOMap.containsKey(item.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(item.getItemCode());
                        List spuAttchmentList = itmItemRpcDTO.getSpuImageList();
                        if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<SpuImageDTO> first = spuAttchmentList.stream().filter(SpuImageDTO::getMajor).findFirst();
                            innerItemDO.setImgUrl(first.isEmpty() ? ((SpuImageDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                        innerItemDO.setItemId(itmItemRpcDTO.getId());
                        innerItemDO.setItemName(itmItemRpcDTO.getItemName());
                    }
                    innerItemDOS.add(innerItemDO);
                }
                ScpAllocSettingRedisDO.ActivityDO activityDO1 = new ScpAllocSettingRedisDO.ActivityDO();
                activityDO1.setActivityId(settingDO.getId());
                activityDO1.setActivityCode(settingDO.getActivityCode());
                activityDO1.setDocTypes(StrUtil.split((CharSequence)settingDO.getDocType(), (CharSequence)","));
                activityDO1.setMaxNum(allocId.getMaxNum());
                activityDO1.setAllocNum(0);
                activityDO1.setInnerItemDOS(innerItemDOS);
                activityDO1.setValidFrom(settingDO.getValidFrom());
                activityDO1.setValidTo(settingDO.getValidTo());
                List<ScpAllocSettingRedisDO.ActivityDO> activityList = scpAllocSettingRedisDO.getActivityList();
                if (activityList == null) {
                    activityList = new ArrayList<ScpAllocSettingRedisDO.ActivityDO>();
                }
                activityList.add(activityDO1);
                scpAllocSettingRedisDO.setActivityList(activityList);
            }
            if (CollUtil.isNotEmpty(scpAllocSettingRedisDO.getActivityList())) {
                String jsonString = JSON.toJSONString((Object)scpAllocSettingRedisDO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                redisMap.put(storeKey, jsonString);
            }
        });
        if (CollUtil.isNotEmpty(redisMap)) {
            this.redisClient.opsForValue().multiSet(redisMap);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void storeChangeMaxNum(List<ScpAllocSettingStoreChangeParamVO> paramVOS) {
        final ArrayList<String> storeCodes = new ArrayList<String>();
        for (ScpAllocSettingStoreChangeParamVO paramVO : paramVOS) {
            if (paramVO.getMaxAllocNum() == null || paramVO.getStoreCode() == null || paramVO.getMasId() == null) continue;
            if (paramVO.getMaxAllocNum().compareTo(BigDecimal.ZERO) < 0) {
                paramVO.setMaxAllocNum(BigDecimal.ZERO);
            }
            this.scpAllocSettingStoreRepo.updateMaxNumByParam(paramVO.getMasId(), paramVO.getStoreCode(), paramVO.getMaxAllocNum());
            storeCodes.add(paramVO.getStoreCode());
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                if (CollUtil.isNotEmpty((Collection)storeCodes)) {
                    ScpAllocSettingStoreRefreshParamVO paramVO = new ScpAllocSettingStoreRefreshParamVO();
                    paramVO.setStoreCodes(storeCodes);
                    ScpAllocSettingServiceImpl.this.storeRefresh(paramVO);
                }
            }
        });
    }

    @Override
    public List<ScpAllocSettingStoreRespVO> importStoreData(List<ScpAllocSettingImportStoreParamVO> list) {
        List<String> storeCodes = this.checkApplyDetail(list);
        List<OrgStoreBaseRpcDTO> orgStoreBaseByParam = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(storeCodes);
        Map<Object, Object> storeBaseMap = CollUtil.isNotEmpty(orgStoreBaseByParam) ? orgStoreBaseByParam.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (key, value) -> value)) : new HashMap();
        Map<String, String> storeType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        ArrayList<ScpAllocSettingStoreRespVO> res = new ArrayList<ScpAllocSettingStoreRespVO>();
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpAllocSettingImportStoreParamVO l = list.get(i);
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)storeBaseMap.get(l.getStoreCode());
            if (orgStoreBaseRpcDTO == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            ScpAllocSettingStoreRespVO applyDResp = new ScpAllocSettingStoreRespVO();
            applyDResp.setStoreId(orgStoreBaseRpcDTO.getId());
            applyDResp.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            applyDResp.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            applyDResp.setStoreType2(orgStoreBaseRpcDTO.getStoreType2());
            String storeTypeName = storeType2.get(orgStoreBaseRpcDTO.getStoreType2());
            if (storeTypeName != null) {
                applyDResp.setStoreType2Name(storeTypeName);
            }
            applyDResp.setMaxNum(Strings.isBlank((String)l.getMaxNum()) ? 0 : Integer.parseInt(l.getMaxNum()));
            applyDResp.setAllocNum(0);
            res.add(applyDResp);
        }
        return res;
    }

    @Override
    public void exportByItemCode(String itemCode, HttpServletResponse response) {
        List<ScpAllocSettingStoreInfoRespVO> activeAllocSetting = this.scpAllocSettingItemRepoProc.getAllocSettingItemByStoreCode2(itemCode, null, null);
        HashMap<String, Map> result = new HashMap<String, Map>();
        if (CollectionUtil.isNotEmpty(activeAllocSetting)) {
            LocalDate earliestStartDate = ((LocalDateTime)activeAllocSetting.stream().map(ScpAllocSettingStoreInfoRespVO::getValidFrom).filter(Objects::nonNull).min(LocalDateTime::compareTo).orElse(null)).toLocalDate();
            LocalDate latestEndDate = ((LocalDateTime)activeAllocSetting.stream().map(ScpAllocSettingStoreInfoRespVO::getValidTo).filter(Objects::nonNull).max(LocalDateTime::compareTo).orElse(null)).toLocalDate();
            ScpStoreDemandCalendarParamVO paramVO = new ScpStoreDemandCalendarParamVO();
            paramVO.setDeliveryType("110");
            paramVO.setWorkStatus("W");
            List<ScpStoreDemandCalendarDTO> storeCalendarByDateRange = this.storeDemandCalendarRepoProc.findStoreCalendarByDateRange(paramVO, earliestStartDate, latestEndDate);
            ArrayList<String> canDeliveryStoreCodes = new ArrayList();
            if (CollectionUtil.isNotEmpty(storeCalendarByDateRange)) {
                canDeliveryStoreCodes = storeCalendarByDateRange.stream().map(ScpStoreDemandCalendarDTO::getStoreCode).distinct().toList();
            }
            for (ScpAllocSettingStoreInfoRespVO activityDO : activeAllocSetting) {
                Map<String, Long> stringLongMap2 = this.scpDemandOrderRepoProc.countAllocatedOrderByItemCodesIn(canDeliveryStoreCodes, activityDO.getActivityCode(), activityDO.getValidFrom(), activityDO.getValidTo());
                result.put(activityDO.getActivityCode(), stringLongMap2);
            }
        }
        if (CollectionUtil.isEmpty(result)) {
            throw new BusinessException("\u65e0\u5f3a\u914d\u4fe1\u606f");
        }
        ArrayList list = new ArrayList();
        result.forEach((activityCode, stringLongMap) -> stringLongMap.forEach((storeCode, allocNum) -> {
            ScpAllocSettingStoreInfoExportVO exportVO = new ScpAllocSettingStoreInfoExportVO();
            exportVO.setActivityCode((String)activityCode);
            exportVO.setStoreCode((String)storeCode);
            exportVO.setAllocNum(allocNum == null ? "0" : allocNum.toString());
            list.add(exportVO);
        }));
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String fileName = URLEncoder.encode(itemCode + "\u5f3a\u914d\u4fe1\u606f", StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        AliasRowWriteHandle aliasRowWriteHandler = new AliasRowWriteHandle();
        ExcelWriterBuilder write = null;
        try {
            write = EasyExcel.write((OutputStream)response.getOutputStream(), ScpAllocSettingStoreInfoExportVO.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((ExcelWriterBuilder)((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)aliasRowWriteHandler)).sheet(fileName).doWrite(list);
    }

    public List<String> checkApplyDetail(List<ScpAllocSettingImportStoreParamVO> list) {
        if (CollectionUtil.isEmpty(list)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, String> storeCodes = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            int row = i + 3;
            ScpAllocSettingImportStoreParamVO importData = list.get(i);
            if (StrUtil.isBlank((CharSequence)importData.getStoreCode())) {
                throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            }
            String s = (String)storeCodes.get(importData.getStoreCode());
            if (s != null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\u95e8\u5e97\u7f16\u7801" + importData.getStoreCode() + "\u91cd\u590d");
            }
            storeCodes.put(importData.getStoreCode(), importData.getStoreCode());
        }
        return storeCodes.keySet().stream().toList();
    }

    private void intersectSets(Set<Long> set1, List<Long> list2) {
        if (set1.isEmpty()) {
            set1.addAll(list2);
        }
        set1.retainAll(list2);
    }

    public ScpAllocSettingServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpAllocSettingDomainService scpAllocSettingDomainService, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService, ScpAllocSettingRegionDomainService scpAllocSettingRegionDomainService, ScpAllocSettingBrandDomainService scpAllocSettingBrandDomainService, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RedisTemplate<String, Object> redisClient, ScpAllocSettingRepo scpAllocSettingRepo, RmiItemService rmiItemService, RmiSysUDCService rmiSysUDCService, ScpAllocSettingStoreRepo scpAllocSettingStoreRepo, ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc, ScpStoreDemandCalendarRepoProc storeDemandCalendarRepoProc, ScpDemandOrderRepoProc scpDemandOrderRepoProc) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpAllocSettingDomainService = scpAllocSettingDomainService;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
        this.scpAllocSettingRegionDomainService = scpAllocSettingRegionDomainService;
        this.scpAllocSettingBrandDomainService = scpAllocSettingBrandDomainService;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.redisClient = redisClient;
        this.scpAllocSettingRepo = scpAllocSettingRepo;
        this.rmiItemService = rmiItemService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpAllocSettingStoreRepo = scpAllocSettingStoreRepo;
        this.scpAllocSettingItemRepoProc = scpAllocSettingItemRepoProc;
        this.storeDemandCalendarRepoProc = storeDemandCalendarRepoProc;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
    }
}

