/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.article;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.dto.article.ArticleCategoryDTO;
import com.elitesland.scp.domain.entity.article.ArticleCategoryDO;
import com.elitesland.scp.domain.entity.article.QArticleCategoryDO;
import com.elitesland.scp.domain.vo.article.ArticleCategoryPagingParam;
import com.elitesland.scp.domain.vo.article.UpCategoryRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleCategoryRepoProc
extends BaseRepoProc<ArticleCategoryDO> {
    private static final QArticleCategoryDO Q_DO = QArticleCategoryDO.articleCategoryDO;
    private static final QArticleCategoryDO P_Q_DO = QArticleCategoryDO.articleCategoryDO;

    protected ArticleCategoryRepoProc() {
        super((EntityPathBase)Q_DO);
    }

    public PagingVO<ArticleCategoryDTO> findParentCategoryPagingResults(Set<Long> pidSet, ArticleCategoryPagingParam param) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.select(ArticleCategoryDTO.class).where(this.whereByPid(pidSet))).orderBy(ArticleCategoryRepoProc.Q_DO.showFlag.asc())).orderBy(ArticleCategoryRepoProc.Q_DO.sortNo.desc())).orderBy(ArticleCategoryRepoProc.Q_DO.createTime.desc());
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private Predicate whereByPid(Set<Long> pidSet) {
        return BaseRepoProc.PredicateBuilder.builder().andIsNull(CollectionUtil.isEmpty(pidSet), ArticleCategoryRepoProc.Q_DO.pid).andIn(CollectionUtil.isNotEmpty(pidSet), ArticleCategoryRepoProc.Q_DO.id, pidSet).build();
    }

    public List<ArticleCategoryDTO> queryUpCategory() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.select(ArticleCategoryDTO.class).where((Predicate)ArticleCategoryRepoProc.Q_DO.pid.isNull())).orderBy(ArticleCategoryRepoProc.Q_DO.sortNo.asc())).orderBy(ArticleCategoryRepoProc.Q_DO.createTime.asc())).fetch();
    }

    public List<ArticleCategoryDTO> findByPidInAndShowFlag(List<Long> parentIdList, ArticleCategoryPagingParam param) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.select(ArticleCategoryDTO.class).where(this.whereByPidInAndShowFlag(parentIdList, param))).orderBy(ArticleCategoryRepoProc.Q_DO.showFlag.asc())).orderBy(ArticleCategoryRepoProc.Q_DO.sortNo.desc())).orderBy(ArticleCategoryRepoProc.Q_DO.createTime.desc())).fetch();
    }

    private Predicate whereByPidInAndShowFlag(List<Long> parentIdList, ArticleCategoryPagingParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andIn(CollectionUtil.isNotEmpty(parentIdList), ArticleCategoryRepoProc.Q_DO.pid, parentIdList).andEq(StrUtil.isNotBlank((CharSequence)param.getShowFlag()), (SimpleExpression)ArticleCategoryRepoProc.Q_DO.showFlag, (Object)param.getShowFlag()).andLike(StrUtil.isNotBlank((CharSequence)param.getCategoryName()), (StringExpression)ArticleCategoryRepoProc.Q_DO.categoryName, param.getCategoryName()).build();
    }

    public List<ArticleCategoryDTO> findByCategoryNameAndShowFlag(ArticleCategoryPagingParam param) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.select(ArticleCategoryDTO.class).where(this.whereByCategoryNameAndShowFlag(param))).orderBy(ArticleCategoryRepoProc.Q_DO.showFlag.asc())).orderBy(ArticleCategoryRepoProc.Q_DO.sortNo.desc())).orderBy(ArticleCategoryRepoProc.Q_DO.createTime.desc())).fetch();
    }

    private Predicate whereByCategoryNameAndShowFlag(ArticleCategoryPagingParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andLike(StrUtil.isNotBlank((CharSequence)param.getCategoryName()), (StringExpression)ArticleCategoryRepoProc.Q_DO.categoryName, param.getCategoryName()).andEq(StrUtil.isNotBlank((CharSequence)param.getShowFlag()), (SimpleExpression)ArticleCategoryRepoProc.Q_DO.showFlag, (Object)param.getShowFlag()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{ArticleCategoryRepoProc.Q_DO.id, ArticleCategoryRepoProc.Q_DO.categoryName, ArticleCategoryRepoProc.Q_DO.showFlag, ArticleCategoryRepoProc.Q_DO.pid, ArticleCategoryRepoProc.Q_DO.sortNo, ArticleCategoryRepoProc.Q_DO.rootId})).from((EntityPath)Q_DO);
    }

    public List<ArticleCategoryDTO> findAll() {
        return ((JPAQuery)this.select(ArticleCategoryDTO.class).orderBy(ArticleCategoryRepoProc.Q_DO.id.asc())).fetch();
    }

    public List<UpCategoryRespVO> queryUpCategory(Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(UpCategoryRespVO.class, (Expression[])new Expression[]{ArticleCategoryRepoProc.P_Q_DO.id, ArticleCategoryRepoProc.P_Q_DO.categoryName})).from((EntityPath)Q_DO)).innerJoin((EntityPath)P_Q_DO)).on((Predicate)ArticleCategoryRepoProc.P_Q_DO.id.eq(ArticleCategoryRepoProc.Q_DO.pid))).where((Predicate)ArticleCategoryRepoProc.Q_DO.id.eq((Object)id))).fetch();
    }

    public List<ArticleCategoryDTO> findAllByShowFlag(String showFlag) {
        return ((JPAQuery)((JPAQuery)this.select(ArticleCategoryDTO.class).where((Predicate)ArticleCategoryRepoProc.Q_DO.showFlag.eq((Object)showFlag))).orderBy(ArticleCategoryRepoProc.Q_DO.id.asc())).fetch();
    }
}

