/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.support.provider.org.param.OrgAddrQueryRpcParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiOrgOutRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgOutRpcService.class);
    private final OrgAddrRpcService orgAddrRpcService;

    public OrgAddrDetailsRpcDTO findRpcDtoByAddrNo(Long addrNo) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u5730\u5740\u53f7\u83b7\u53d6\u5730\u5740\u8584\u8be6\u60c5\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)addrNo);
        try {
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            ApiResult apiResult = this.orgAddrRpcService.findRpcDtoByParam(param);
            if (apiResult.isSuccess()) {
                return (OrgAddrDetailsRpcDTO)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", (Throwable)e);
            return null;
        }
    }

    public RmiOrgOutRpcService(OrgAddrRpcService orgAddrRpcService) {
        this.orgAddrRpcService = orgAddrRpcService;
    }
}

