package com.elitesland.scp.application.facade.vo.resp.alloc;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("订货强配详情返回")
public class ScpAllocSettingStoreInfoRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -7429845441661010333L;

    @ApiModelProperty("活动ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("门店ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty("最大强配次数")
    private Integer maxNum;

    @ApiModelProperty("已配次数")
    private Integer allocNum;
}
