package com.elitesland.scp.application.facade.vo.resp.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


@Data
public class AppItmItemAttachmentVO implements Serializable {

    private static final long serialVersionUID = 5598464547725731800L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    public Long id;

    /**
     * 商品ID，前端不需传该参数，后端会自动赋值
     */
    @ApiModelProperty(value = "商品ID，前端不需传该参数，后端会自动赋值")
    private Long itemId;

    /**
     * 商品文件ID
     */
    @ApiModelProperty(value = "商品文件ID")
    private Long fileId;

    /**
     * 商品文件名称
     */
    @ApiModelProperty(value = "商品文件名称")
    private String fileName;

    /**
     * 商品文件编号
     */
    @ApiModelProperty(value = "商品文件编号")
    private String fileCode;

    /**
     * 图片尺寸
     */
    @ApiModelProperty(value = "图片尺寸")
    private String imgSize;

    /**
     * 文件大小
     */
    @ApiModelProperty(value = "文件大小")
    private String fileSize;

    /**
     * 文件类型
     */
    @ApiModelProperty(value = "文件类型")
    private String fileType;

    /**
     * 是否主图
     */
    @ApiModelProperty(value = "是否主图")
    private Boolean major;

    /**
     * 图片url
     */
    @ApiModelProperty(value = "图片url")
    private String url;
}
