package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingDO;
import com.elitesland.scp.infr.dto.alloc.ScpAllocSettingDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRepoProc;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpAllocSettingDomainServiceImpl implements ScpAllocSettingDomainService {

    private final ScpAllocSettingRepo scpAllocSettingRepo;
    private final ScpAllocSettingRepoProc scpAllocSettingRepoProc;
    private final ScpAllocSettingStoreRepoProc scpAllocSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpAllocSettingPageRespVO> queryAllocSettingList(ScpAllocSettingPageParamVO paramVO) {
        long count = scpAllocSettingRepoProc.countAllocSetting(paramVO);
        if (count > 0) {
            Map<String, String> docTypeMap = rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            var allocSettings = scpAllocSettingRepoProc.queryAllocSetting(paramVO);
            Map<Long, Long> usedIdMap = getUsedIdMap(allocSettings);
            allocSettings.forEach(item -> {
                if (StrUtil.isNotBlank(item.getDocType())) {
                    List<String> itemCateName = StrUtil.split(item.getDocType(), ',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO<>(count, allocSettings);
        }
        return new PagingVO<>();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpAllocSettingPageRespVO> allocSettings) {
        List<Long> ids = allocSettings.stream().map(ScpAllocSettingPageRespVO::getId).collect(Collectors.toList());
        List<Long> usedSettings = scpAllocSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpAllocSettingDTO> findAllocSettingById(Long id) {
        return scpAllocSettingRepo.findById(id).map(row -> {
            ScpAllocSettingDTO scpAllocSettingDTO = ScpAllocSettingConvert.INSTANCE.doToDto(row);
            return scpAllocSettingDTO;
        });
    }

    @Override
    public Long saveAllocSetting(ScpAllocSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpAllocSettingDO intentDO = ScpAllocSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpAllocSettingRepo.save(intentDO).getId();
            return masId;
        } else {
            Optional<ScpAllocSettingDO> option = scpAllocSettingRepo.findById(saveVO.getId());
            if (option.isEmpty()) {
                throw new BusinessException("订货强配活动ID：" + saveVO.getId() + "不存在");
            }
            ScpAllocSettingDO scpAllocSettingDO = option.get();
            ScpAllocSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpAllocSettingDO);
            scpAllocSettingDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpAllocSettingRepo.save(scpAllocSettingDO).getId();
            return masId;
        }
    }

    @Override
    public void enableAllocSetting(List<Long> ids, Boolean enable) {
        scpAllocSettingRepoProc.enableAllocSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpAllocSettingDO> settingDOS = scpAllocSettingRepo.findByIdIn(ids);
        scpAllocSettingRepoProc.deleteByIds(ids);
    }
}
