package com.elitesland.scp.infr;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */

@Data
public class ScpServiceConfigDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty("费用归属类型")
    private String feeType;

    @ApiModelProperty("费用归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("费用归属公司编码")
    private String ouCode;

    @ApiModelProperty("费用归属公司名称")
    private String ouName;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("区域id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long regionStoreId;

    @ApiModelProperty("区域编码/门店编码")
    private String regionStoreCode;

    @ApiModelProperty("区域名称/门店名称")
    private String regionStoreName;

    @ApiModelProperty("适用门店等级")
    private String storeLevel;

    @ApiModelProperty("费用比例")
    private BigDecimal feePercentage;
}