package com.elitesland.scp.infr.repo.stock;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.domain.entity.stock.QScpSafetyTargetStockDO;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-15
* @Version 1.0
**/
@Component
public class ScpSafetyTargetStockRepoProc extends BaseRepoProc<ScpSafetyTargetStockDO>{

    private static final  QScpSafetyTargetStockDO jpaQDo = QScpSafetyTargetStockDO.scpSafetyTargetStockDO;
    public ScpSafetyTargetStockRepoProc(){
        super(jpaQDo);
    }


    public PagingVO<ScpSafetyTargetStockPageVO> searchPage(ScpSafetyTargetStockPageParam param){
        JPAQuery<ScpSafetyTargetStockPageVO> jpaQuery = jpaQueryFactory.select( Projections.bean(
                ScpSafetyTargetStockPageVO.class,
                jpaQDo.id,
                jpaQDo.ouCode,
                jpaQDo.ouId,
                jpaQDo.ouName,
                jpaQDo.whCode,
                jpaQDo.whId,
                jpaQDo.whName,
                jpaQDo.itemId,
                jpaQDo.itemCode,
                jpaQDo.itemName,
                jpaQDo.itemCateCode,
                jpaQDo.itemType2,
                jpaQDo.brand,
                jpaQDo.planUom,
                jpaQDo.safetyQty,
                jpaQDo.targetQty,
                jpaQDo.createTime,
                jpaQDo.creator,
                jpaQDo.createUserId,
                jpaQDo.tenantId,
                jpaQDo.auditDataVersion,
                jpaQDo.deleteFlag,
                jpaQDo.modifyTime,
                jpaQDo.updater,
                jpaQDo.modifyUserId,
                jpaQDo.remark)).from(jpaQDo);
        if(param != null){
            jpaQuery.where(where(param));
        }
        assert param != null;
        return queryByPage(jpaQuery,param.getPageRequest());
    }

    private Predicate where(ScpSafetyTargetStockPageParam param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getWhIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.whId.in(param.getWhIds()));
        }
        if(CollectionUtils.isNotEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.itemId.in(param.getItemIds()));
        }
        if(CollectionUtils.isNotEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        return predicate;
    }


    public List<ScpSafetyTargetStockDTO> findByBusinessIds(List<String> businessIds){
        return jpaQueryFactory.select( Projections.bean(
                ScpSafetyTargetStockDTO.class,
                jpaQDo.id,
                jpaQDo.businessId,
                jpaQDo.planUom,
                jpaQDo.safetyQty,
                jpaQDo.targetQty))
                .from(jpaQDo).where(jpaQDo.businessId.in(businessIds)
                        .and(jpaQDo.deleteFlag.isNull().or(jpaQDo.deleteFlag.eq(0)))).fetch();
    }







}