/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.boh.StoreOrderDRpcDTO;
import com.elitesland.inv.dto.boh.StoreOrderRpcDTO;
import com.elitesland.inv.dto.boh.StoreRtnApplyResult;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreReceiveRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreRtnRpcDTO;
import com.elitesland.inv.provider.StoreOrderTrnProvider;
import com.elitesland.pur.provider.PurRnsProvider;
import com.elitesland.scp.application.facade.vo.boh.RtnApplyResult;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveCategoryInfoVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveCategoryVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveConfirmParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveItemUomDetail;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnApplyParam;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.facade.vo.param.order.StoreReceiveSubmitMqParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemLotRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmUomRpcDTO;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveServiceImpl
implements StoreReceiveService {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveServiceImpl.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final OrgOuRpcService orgOuRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final UdcProvider udcProvider;
    private final OrgAddrRpcService orgAddrRpcService;
    private final StoreOrderTrnProvider storeOrderTrnProvider;
    private final PurRnsProvider purRnsProvider;
    private final TaskExecutor taskExecutor;
    private final MessageQueueTemplate messageQueueTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final RmiSysUDCService rmiSysUDCService;
    private static final Map<String, String> receiveStatusMap = new HashMap<String, String>();
    private static final Map<String, String> rtnStatusMap = new HashMap<String, String>();

    @Override
    public PagingVO<StoreReceivePageVO> page(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page;
        if (StrUtil.isNotBlank((CharSequence)param.getItemName()) || StrUtil.isNotBlank((CharSequence)param.getItemCode()) || StrUtil.isNotBlank((CharSequence)param.getItemKeyword())) {
            List itemIdByCodeName = this.itmItemRpcService.findItemIdByCodeName(param.getItemCode(), param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty((Collection)itemIdByCodeName)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List allLeafCateId = this.itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);
            List<Long> itemIdsByCate = this.storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = this.storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new PagingVO();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(page = this.storeReceiveRepoProc.page(param)).getRecords())) {
            Map<String, String> refundType = this.rmiSysUDCService.getCodeMap("yst-suplan", "REFUND_TYPE");
            for (StoreReceivePageVO record : page.getRecords()) {
                if (record.getRtType().equals("R")) {
                    record.setStatusName(receiveStatusMap.get(record.getStatus()));
                } else {
                    record.setStatusName(rtnStatusMap.get(record.getStatus()));
                }
                if (record.getDocType().equals("TRN")) {
                    record.setDocTypeName("\u4ed3\u914d");
                } else {
                    record.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
                }
                record.setRefundTypeName(refundType.get(record.getRefundType()));
            }
        }
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            List rnsRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR")).filter(i -> i.getDocType().equals("GR")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(rnsRtnList)) {
                ArrayList approvingIds = (ArrayList)this.purRnsProvider.findApproving(rnsRtnList.stream().map(StoreReceivePageVO::getDocId).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty((Collection)approvingIds)) {
                    approvingIds = new ArrayList();
                }
                ArrayList finalApprovingIds = approvingIds;
                rnsRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            List trnRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR")).filter(i -> i.getDocType().equals("TRN")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(trnRtnList)) {
                ArrayList approvingIds = (ArrayList)this.storeOrderTrnProvider.findApproving(trnRtnList.stream().map(StoreReceivePageVO::getDocId).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty((Collection)approvingIds)) {
                    approvingIds = new ArrayList();
                }
                ArrayList finalApprovingIds = approvingIds;
                trnRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        return page;
    }

    @Override
    public PagingVO<StoreReceivePageVO> pageAndDetail(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page = this.storeReceiveRepoProc.page(param);
        List list = page.getRecords();
        List<StoreReceivePageVO> result = this.getStoreReceivePageVOS(list);
        if (!result.isEmpty()) {
            result.forEach(i -> {
                String recvKey = "RECEIVE" + i.getDocId().toString();
                i.setCanConfirm(this.redisTemplate.hasKey((Object)recvKey) == false && Objects.equals(i.getStatus(), "CE"));
            });
            page.setRecords(result);
        }
        return page;
    }

    private Map<Long, StoreCanRtnQtyRpcDTO> getCanRtnQtyRpcDTOMap(List<StoreCanRtnQtyRpcDTO> rpcDTOS, String docType) {
        Map<Long, StoreCanRtnQtyRpcDTO> canRtnQtyRpcDTOHashMap = CollectionUtil.isNotEmpty(rpcDTOS) ? rpcDTOS.stream().peek(row -> {
            if ("GR".equals(docType)) {
                row.setCanRtnQty(row.getCanRtnQty());
            } else if (row.getCanRtnQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setCanRtnQty(row.getCanRtnQty().divide(row.getUomRatio(), (int)row.getPlaces(), RoundingMode.HALF_UP));
            }
            if (row.getStkQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setStkQty(row.getStkQty().divide(row.getUomRatio(), (int)row.getPlaces(), RoundingMode.HALF_UP));
            }
        }).collect(Collectors.toMap(StoreCanRtnQtyRpcDTO::getId, i -> i)) : new HashMap<Long, StoreCanRtnQtyRpcDTO>();
        return canRtnQtyRpcDTOHashMap;
    }

    @Nullable
    private StoreReceiveDDetailVO getStoreReceiveDDetailVO(StoreReceivePageVO receivePageVO, StoreOrderDRpcDTO invTrnDRpcDTO, ItmItemLotRpcDTO itmItemSimpleRpcDTO, String orderItemSetting, Map<Long, ScpDemandOrderDDTO> demandOrderDDTOMap, Map<String, Map<String, String>> suppUdcMap, Map<Long, List<DemandOrderDtl>> itemImgUrlMap, Map<String, Map<String, String>> invUdcMap) {
        if (receivePageVO.getRtType().equals("T") && itmItemSimpleRpcDTO.getItemCode().equals(orderItemSetting)) {
            return null;
        }
        StoreReceiveDDetailVO storeReceiveDDetailVO = new StoreReceiveDDetailVO();
        ScpDemandOrderDDTO demandOrderDDTO = demandOrderDDTOMap.get(invTrnDRpcDTO.getRelateDocDid());
        if (demandOrderDDTO != null) {
            storeReceiveDDetailVO.setCombineItemCode(demandOrderDDTO.getCombineItemCode());
            storeReceiveDDetailVO.setCombineItemName(demandOrderDDTO.getCombineItemName());
            storeReceiveDDetailVO.setReturnQty(demandOrderDDTO.getReturnQty());
            storeReceiveDDetailVO.setCompensateQty(demandOrderDDTO.getCompensateQty());
        }
        storeReceiveDDetailVO.setGiftFlag(invTrnDRpcDTO.getGiftLineFlag());
        storeReceiveDDetailVO.setId(invTrnDRpcDTO.getId());
        storeReceiveDDetailVO.setManuDate(invTrnDRpcDTO.getManuDate());
        storeReceiveDDetailVO.setManuFactory(invTrnDRpcDTO.getManuFactory());
        storeReceiveDDetailVO.setManuFactoryName(invTrnDRpcDTO.getManuFactoryName());
        storeReceiveDDetailVO.setOrderDid(invTrnDRpcDTO.getRelateDocDid());
        storeReceiveDDetailVO.setItemId(invTrnDRpcDTO.getItemId());
        storeReceiveDDetailVO.setPrice(invTrnDRpcDTO.getTotalPrice() == null ? invTrnDRpcDTO.getPrice() : invTrnDRpcDTO.getTotalPrice());
        if (receivePageVO.getRtType().equals("R")) {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getInLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getInLimit1());
            if (invTrnDRpcDTO.getOutQty() == null || BigDecimal.ZERO.compareTo(invTrnDRpcDTO.getOutQty()) == 0) {
                return null;
            }
        } else if (receivePageVO.getStatus().equals("CF")) {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getOutLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
        } else {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
        }
        if (receivePageVO.getDocType().equals("GR")) {
            storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty());
            storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty());
            storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty());
            storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom());
            storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom()));
        } else {
            if (invTrnDRpcDTO.getQty2() == null) {
                return null;
            }
            storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty2());
            storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty2());
            if (receivePageVO.getRtType().equals("R")) {
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getOutQty2());
            } else {
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty2());
            }
            storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom2());
            storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom2()));
        }
        if (itmItemSimpleRpcDTO != null) {
            storeReceiveDDetailVO.setItemCode(itmItemSimpleRpcDTO.getItemCode());
            storeReceiveDDetailVO.setItemName(itmItemSimpleRpcDTO.getItemName());
            storeReceiveDDetailVO.setSpec(itmItemSimpleRpcDTO.getSpec());
            storeReceiveDDetailVO.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
            List<DemandOrderDtl> demandOrderDtls = itemImgUrlMap.get(itmItemSimpleRpcDTO.getId());
            if (CollectionUtil.isNotEmpty(demandOrderDtls)) {
                storeReceiveDDetailVO.setImageUrl(demandOrderDtls.get(0).getImgUrl());
            }
        }
        storeReceiveDDetailVO.setLimit1Name(invUdcMap.get("STK_ITM_STATUS").get(storeReceiveDDetailVO.getLimit1()));
        return storeReceiveDDetailVO;
    }

    @NotNull
    private List<StoreReceivePageVO> getStoreReceivePageVOS(List<StoreReceivePageVO> list) {
        ArrayList<StoreReceivePageVO> result = new ArrayList<StoreReceivePageVO>();
        if (CollectionUtil.isNotEmpty(list)) {
            for (StoreReceivePageVO receivePageVO : list) {
                if (receivePageVO.getRtType().equals("R")) {
                    receivePageVO.setStatusName(receiveStatusMap.get(receivePageVO.getStatus()));
                } else {
                    receivePageVO.setStatusName(rtnStatusMap.get(receivePageVO.getStatus()));
                }
                if (receivePageVO.getDocType().equals("TRN")) {
                    receivePageVO.setDocTypeName("\u4ed3\u914d");
                } else {
                    receivePageVO.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
                }
                ApiResult detail = this.storeOrderTrnProvider.detail(receivePageVO.getDocId(), receivePageVO.getDocType(), receivePageVO.getRtType());
                Map<Long, ScpDemandOrderDDTO> demandOrderDDTOMap = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(receivePageVO.getOrderId()).stream().collect(Collectors.toMap(BaseViewModel::getId, c -> c));
                if (detail != null && detail.isSuccess() && detail.getData() != null) {
                    List rpcDTOS = (List)this.storeOrderTrnProvider.canRtn(receivePageVO.getDocId(), receivePageVO.getDocType()).computeData();
                    Map<Long, StoreCanRtnQtyRpcDTO> canRtnQtyRpcDTOHashMap = this.getCanRtnQtyRpcDTOMap(rpcDTOS, receivePageVO.getDocType());
                    StoreOrderRpcDTO storeOrderRpcDTO = (StoreOrderRpcDTO)detail.getData();
                    List<StoreOrderDRpcDTO> standard = storeOrderRpcDTO.getInvTrnDRpcDTOS().stream().filter(i -> Objects.equals(i.getLineType(), "standard")).toList();
                    List itemIds = standard.stream().map(StoreOrderDRpcDTO::getItemId).distinct().collect(Collectors.toList());
                    Map<Object, Object> itmItemMap = new HashMap();
                    if (CollectionUtil.isNotEmpty(itemIds)) {
                        List simpleItem = this.itmItemRpcService.findLotRpcDTOS(itemIds);
                        itmItemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemLotRpcDTO::getId, i -> i));
                    }
                    Map<Long, List<DemandOrderDtl>> itemImgUrlMap = this.getItemImgUrlMap(receivePageVO.getOrderId());
                    Map suppUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", Set.of("UOM"));
                    Map invUdcMap = this.udcProvider.getValueMapByUdcCode("yst-inv", Set.of("STK_ITM_STATUS"));
                    String orderItemSetting = SysUtils.getOrderItemSetting();
                    ArrayList<StoreReceiveDDetailVO> items = new ArrayList<StoreReceiveDDetailVO>();
                    BigDecimal totalItemQty = BigDecimal.ZERO;
                    for (StoreOrderDRpcDTO invTrnDRpcDTO : standard) {
                        StoreCanRtnQtyRpcDTO storeCanRtnQtyRpcDTO;
                        ItmItemLotRpcDTO itmItemSimpleRpcDTO;
                        StoreReceiveDDetailVO storeReceiveDDetailVO = this.getStoreReceiveDDetailVO(receivePageVO, invTrnDRpcDTO, itmItemSimpleRpcDTO = (ItmItemLotRpcDTO)itmItemMap.get(invTrnDRpcDTO.getItemId()), orderItemSetting, demandOrderDDTOMap, suppUdcMap, itemImgUrlMap, invUdcMap);
                        if (storeReceiveDDetailVO == null) continue;
                        totalItemQty = totalItemQty.add(storeReceiveDDetailVO.getDeliveryQty());
                        if (CollectionUtil.isNotEmpty(canRtnQtyRpcDTOHashMap) && (storeCanRtnQtyRpcDTO = canRtnQtyRpcDTOHashMap.get(storeReceiveDDetailVO.getId())) != null) {
                            storeReceiveDDetailVO.setCanRtnQty(storeCanRtnQtyRpcDTO.getCanRtnQty());
                            storeReceiveDDetailVO.setStkQty(storeCanRtnQtyRpcDTO.getStkQty());
                        }
                        try {
                            ApiResult itmUomRpcByItemId = this.itmItemRpcService.findItmUomRpcByItemId(storeReceiveDDetailVO.getItemId());
                            if (itmUomRpcByItemId != null && itmUomRpcByItemId.isSuccess()) {
                                ItmUomRpcDTO data = (ItmUomRpcDTO)itmUomRpcByItemId.getData();
                                Optional.ofNullable(data).ifPresent(itmUomRpcDTO -> {
                                    ArrayList<StoreReceiveItemUomDetail> itemUomList = new ArrayList<StoreReceiveItemUomDetail>();
                                    for (ItmUomRpcDTO.ItemUomDetail itemUomDetail : itmUomRpcDTO.getItemUomList()) {
                                        StoreReceiveItemUomDetail storeReceiveItemUomDetail = new StoreReceiveItemUomDetail();
                                        storeReceiveItemUomDetail.setUomCode(itemUomDetail.getUomCode());
                                        storeReceiveItemUomDetail.setUomName(itemUomDetail.getUomName());
                                        storeReceiveItemUomDetail.setRatio(itemUomDetail.getRatio());
                                        storeReceiveItemUomDetail.setRatioRevert(itemUomDetail.getRatioRevert());
                                        storeReceiveItemUomDetail.setDefaultFlag(itemUomDetail.getDefaultFlag());
                                        storeReceiveItemUomDetail.setDecimalPlaces(data.getDecimalPlaces());
                                        itemUomList.add(storeReceiveItemUomDetail);
                                    }
                                    storeReceiveDDetailVO.setItemUomList(itemUomList);
                                });
                            }
                        }
                        catch (Exception e) {
                            log.error("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u6570\u636e\u5931\u8d25", (Throwable)e);
                        }
                        items.add(storeReceiveDDetailVO);
                    }
                    receivePageVO.setTotalItemQty(totalItemQty);
                    List<StoreReceiveDDetailVO> resultItems = items.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
                    Map<String, List<StoreReceiveDDetailVO>> subItemMap = items.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(StoreReceiveDDetailVO::getCombineItemCode));
                    if (!subItemMap.isEmpty()) {
                        subItemMap.forEach((k, v) -> {
                            StoreReceiveDDetailVO combineOrderDRespVO = new StoreReceiveDDetailVO();
                            BeanUtils.copyProperties(v.get(0), (Object)combineOrderDRespVO, (String[])new String[0]);
                            combineOrderDRespVO.setCombineItemCode((String)k);
                            combineOrderDRespVO.setCombineItemName(((StoreReceiveDDetailVO)v.get(0)).getCombineItemName());
                            combineOrderDRespVO.setSubItemList((List<StoreReceiveDDetailVO>)v);
                            resultItems.add(combineOrderDRespVO);
                        });
                    }
                    receivePageVO.setItems(resultItems);
                }
                result.add(receivePageVO);
            }
        }
        return result;
    }

    private List<StoreReceivePageVO> getStoreReceivePageVOS2(List<StoreReceivePageVO> list) {
        ArrayList<StoreReceivePageVO> result = new ArrayList<StoreReceivePageVO>();
        if (CollectionUtil.isNotEmpty(list)) {
            for (StoreReceivePageVO receivePageVO : list) {
                if (receivePageVO.getRtType().equals("R")) {
                    receivePageVO.setStatusName(receiveStatusMap.get(receivePageVO.getStatus()));
                } else {
                    receivePageVO.setStatusName(rtnStatusMap.get(receivePageVO.getStatus()));
                }
                if (receivePageVO.getDocType().equals("TRN")) {
                    receivePageVO.setDocTypeName("\u4ed3\u914d");
                } else {
                    receivePageVO.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
                }
                ApiResult detail = this.storeOrderTrnProvider.detail(receivePageVO.getDocId(), receivePageVO.getDocType(), receivePageVO.getRtType());
                Map<Long, ScpDemandOrderDDTO> orderDDTOMap = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(receivePageVO.getOrderId()).stream().collect(Collectors.toMap(BaseViewModel::getId, c -> c));
                if (detail != null && detail.isSuccess() && detail.getData() != null) {
                    StoreOrderRpcDTO storeOrderRpcDTO = (StoreOrderRpcDTO)detail.getData();
                    List<StoreOrderDRpcDTO> standard = storeOrderRpcDTO.getInvTrnDRpcDTOS().stream().filter(i -> Objects.equals(i.getLineType(), "standard")).toList();
                    List itemIds = standard.stream().map(StoreOrderDRpcDTO::getItemId).distinct().collect(Collectors.toList());
                    Map<Object, Object> itmItemMap = new HashMap();
                    if (CollectionUtil.isNotEmpty(itemIds)) {
                        List simpleItem = this.itmItemRpcService.findLotRpcDTOS(itemIds);
                        itmItemMap = simpleItem.stream().collect(Collectors.toMap(ItmItemLotRpcDTO::getId, i -> i));
                    }
                    Map<Long, List<DemandOrderDtl>> itemImgUrlMap = this.getItemImgUrlMap(receivePageVO.getOrderId());
                    Map suppUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", Set.of("UOM"));
                    Map invUdcMap = this.udcProvider.getValueMapByUdcCode("yst-inv", Set.of("STK_ITM_STATUS"));
                    String orderItemSetting = SysUtils.getOrderItemSetting();
                    ArrayList<StoreReceiveDDetailVO> items = new ArrayList<StoreReceiveDDetailVO>();
                    BigDecimal totalItemQty = BigDecimal.ZERO;
                    for (StoreOrderDRpcDTO invTrnDRpcDTO : standard) {
                        ItmItemLotRpcDTO itmItemSimpleRpcDTO;
                        StoreReceiveDDetailVO storeReceiveDDetailVO = this.getStoreReceiveDDetailVO(receivePageVO, invTrnDRpcDTO, itmItemSimpleRpcDTO = (ItmItemLotRpcDTO)itmItemMap.get(invTrnDRpcDTO.getItemId()), orderItemSetting, orderDDTOMap, suppUdcMap, itemImgUrlMap, invUdcMap);
                        if (storeReceiveDDetailVO == null) continue;
                        totalItemQty = totalItemQty.add(storeReceiveDDetailVO.getDeliveryQty());
                        items.add(storeReceiveDDetailVO);
                    }
                    receivePageVO.setTotalItemQty(totalItemQty);
                    LocalDateTime etaDate = storeOrderRpcDTO.getEtaDate();
                    receivePageVO.setEtaDate(etaDate);
                    receivePageVO.setCarrier(storeOrderRpcDTO.getCarrier());
                    receivePageVO.setCarrierCode(storeOrderRpcDTO.getCarrierCode());
                    receivePageVO.setLogisDocNo(storeOrderRpcDTO.getLogisDocNo());
                    List<StoreReceiveDDetailVO> resultItems = items.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
                    Map<String, List<StoreReceiveDDetailVO>> subItemMap = items.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(StoreReceiveDDetailVO::getCombineItemCode));
                    if (!subItemMap.isEmpty()) {
                        for (Map.Entry entry : subItemMap.entrySet()) {
                            String k = (String)entry.getKey();
                            List v = (List)entry.getValue();
                            StoreReceiveDDetailVO combineOrderDRespVO = new StoreReceiveDDetailVO();
                            combineOrderDRespVO.setCombineItemCode(k);
                            combineOrderDRespVO.setCombineItemName(((StoreReceiveDDetailVO)v.get(0)).getCombineItemName());
                            combineOrderDRespVO.setSubItemList(v);
                            resultItems.add(combineOrderDRespVO);
                        }
                    }
                    LinkedHashMap<String, StoreReceiveDDetailVO> itemMap = new LinkedHashMap<String, StoreReceiveDDetailVO>();
                    for (StoreReceiveDDetailVO item : resultItems) {
                        String key = item.getItemCode();
                        if (itemMap.containsKey(key)) {
                            StoreReceiveDDetailVO existingItem = (StoreReceiveDDetailVO)itemMap.get(key);
                            existingItem.setDeliveryQty(this.getDecimal(existingItem.getDeliveryQty()).add(this.getDecimal(item.getDeliveryQty())));
                            existingItem.setOrderQty(this.getDecimal(existingItem.getOrderQty()).add(this.getDecimal(item.getOrderQty())));
                            existingItem.setReceiveQty(this.getDecimal(existingItem.getReceiveQty()).add(this.getDecimal(item.getReceiveQty())));
                            existingItem.setAmt(this.getDecimal(existingItem.getAmt()).add(this.getDecimal(item.getAmt())));
                            existingItem.setCanRtnQty(this.getDecimal(existingItem.getCanRtnQty()).add(this.getDecimal(item.getCanRtnQty())));
                            existingItem.setStkQty(this.getDecimal(existingItem.getStkQty()).add(this.getDecimal(item.getStkQty())));
                            if (item.getSubItemList() != null && !item.getSubItemList().isEmpty()) {
                                if (existingItem.getSubItemList() == null) {
                                    existingItem.setSubItemList(new ArrayList<StoreReceiveDDetailVO>());
                                }
                                existingItem.getSubItemList().addAll(item.getSubItemList());
                            }
                            itemMap.put(key, existingItem);
                            continue;
                        }
                        itemMap.put(key, item);
                    }
                    resultItems = new ArrayList(itemMap.values());
                    receivePageVO.setItems(resultItems);
                }
                result.add(receivePageVO);
            }
        }
        return result;
    }

    @Override
    public StoreReceiveCategoryVO classifyByWhOrDirect(StoreReceivePageParam param) {
        StoreReceiveCategoryVO storeReceiveCategoryVO = new StoreReceiveCategoryVO();
        ScpDemandOrderDTO demandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(param.getOrderId()).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties((Object)demandOrderDTO, (Object)storeReceiveCategoryVO, (String[])new String[0]);
        List<StoreReceivePageVO> list = this.storeReceiveRepoProc.list(param);
        List<StoreReceivePageVO> result = this.getStoreReceivePageVOS(list);
        ArrayList<StoreReceivePageVO> trnRtnList = new ArrayList<StoreReceivePageVO>();
        ArrayList<StoreReceivePageVO> rnsRtnList = new ArrayList<StoreReceivePageVO>();
        result.forEach(i -> {
            String recvKey = "RECEIVE" + i.getDocId().toString();
            if (this.redisTemplate.hasKey((Object)recvKey).booleanValue() || !Objects.equals(i.getStatus(), "CE")) {
                i.setCanConfirm(false);
            }
            if (i.getDocType().equals("TRN")) {
                trnRtnList.add((StoreReceivePageVO)i);
            }
            if (i.getDocType().equals("GR")) {
                rnsRtnList.add((StoreReceivePageVO)i);
            }
        });
        storeReceiveCategoryVO.setWhDeliveryStatus(trnRtnList);
        storeReceiveCategoryVO.setDirectDeliveryStatus(rnsRtnList);
        return storeReceiveCategoryVO;
    }

    @Override
    public StoreReceiveCategoryInfoVO classifyItemByWhOrDirect(StoreReceivePageParam param) {
        StoreReceiveCategoryInfoVO storeReceiveCategoryVO = new StoreReceiveCategoryInfoVO();
        ScpDemandOrderDTO demandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(param.getOrderId()).orElseThrow(() -> new BusinessException("\u8ba2\u8d27\u5355\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties((Object)demandOrderDTO, (Object)storeReceiveCategoryVO, (String[])new String[0]);
        List<StoreReceivePageVO> list = this.storeReceiveRepoProc.list(param);
        List<StoreReceivePageVO> result = this.getStoreReceivePageVOS2(list);
        boolean canConfirm = false;
        ArrayList<StoreReceivePageVO> trnRtnList = new ArrayList<StoreReceivePageVO>();
        ArrayList<StoreReceivePageVO> rnsRtnList = new ArrayList<StoreReceivePageVO>();
        for (StoreReceivePageVO i : result) {
            if (i.getDocType().equals("TRN")) {
                trnRtnList.add(i);
                if (Objects.equals(i.getStatus(), "CE")) {
                    canConfirm = true;
                }
            }
            if (!i.getDocType().equals("GR")) continue;
            rnsRtnList.add(i);
            if (!Objects.equals(i.getStatus(), "CE")) continue;
            canConfirm = true;
        }
        storeReceiveCategoryVO.setWhDeliveryStatus(trnRtnList);
        storeReceiveCategoryVO.setDirectDeliveryStatus(rnsRtnList);
        storeReceiveCategoryVO.setCanConfirm(canConfirm);
        return storeReceiveCategoryVO;
    }

    private BigDecimal getDecimal(BigDecimal existingItem) {
        return existingItem == null ? BigDecimal.ZERO : existingItem;
    }

    @Override
    public StoreReceiveDetailVO find(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        StoreOrderRpcDTO storeOrderRpcDTO = (StoreOrderRpcDTO)this.storeOrderTrnProvider.detail(docId, thisDO.getDocType(), thisDO.getRtType()).computeData();
        StoreReceiveDetailVO storeReceiveDetailVO = new StoreReceiveDetailVO();
        Map<Long, ScpDemandOrderDDTO> orderDDTOMap = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(thisDO.getOrderId()).stream().collect(Collectors.toMap(BaseViewModel::getId, c -> c));
        storeReceiveDetailVO.setCreditAccAmt(storeOrderRpcDTO.getCreditAccAmt());
        storeReceiveDetailVO.setFlzhAccAmt(storeOrderRpcDTO.getFlzhAccAmt());
        storeReceiveDetailVO.setStoreAccAmt(storeOrderRpcDTO.getStoreAccAmt());
        BigDecimal paymentAmt = this.getDecimal(storeOrderRpcDTO.getCreditAccAmt()).add(this.getDecimal(storeOrderRpcDTO.getFlzhAccAmt())).add(this.getDecimal(storeOrderRpcDTO.getStoreAccAmt()));
        storeReceiveDetailVO.setStoreName(this.storeReceiveRepoProc.findStoreName(thisDO.getOrderId()));
        this.assignAddress(storeReceiveDetailVO, storeOrderRpcDTO.getAddrNo());
        storeReceiveDetailVO.setDocId(docId);
        storeReceiveDetailVO.setDocNo(storeOrderRpcDTO.getDocNo());
        storeReceiveDetailVO.setRelatedDocId(thisDO.getRelatedDocId());
        storeReceiveDetailVO.setRelatedDocNo(thisDO.getRelatedDocNo());
        storeReceiveDetailVO.setOrderId(thisDO.getOrderId());
        storeReceiveDetailVO.setOrderNo(thisDO.getOrderNo());
        storeReceiveDetailVO.setRefundType(thisDO.getRefundType());
        storeReceiveDetailVO.setRefundTypeName(thisDO.getRefundTypeName());
        storeReceiveDetailVO.setRealAmt(thisDO.getRealAmt());
        if (thisDO.getDocType().equals("TRN") && thisDO.getRtType().equals("R")) {
            simpleOuDto = this.orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getFromOuId()));
            if (CollectionUtil.isNotEmpty((Collection)simpleOuDto)) {
                storeReceiveDetailVO.setDeliveyOuName(((OrgOuRpcSimpleDTO)simpleOuDto.get(0)).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
            storeReceiveDetailVO.setRecvWhId(storeOrderRpcDTO.getToWhId());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
        } else {
            simpleOuDto = this.orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getToOuId()));
            if (CollectionUtil.isNotEmpty((Collection)simpleOuDto)) {
                storeReceiveDetailVO.setReceiveOuName(((OrgOuRpcSimpleDTO)simpleOuDto.get(0)).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        }
        storeReceiveDetailVO.setCreator(thisDO.getCreator());
        storeReceiveDetailVO.setCreateDate(storeOrderRpcDTO.getCreateTime());
        storeReceiveDetailVO.setReceiveDate(thisDO.getReceiveDate());
        storeReceiveDetailVO.setDocStatus(storeOrderRpcDTO.getDocStatus());
        storeReceiveDetailVO.setNote(storeOrderRpcDTO.getRemark());
        storeReceiveDetailVO.setPics(storeOrderRpcDTO.getPics());
        if (StringUtils.isNotEmpty((CharSequence)storeOrderRpcDTO.getPics())) {
            storeReceiveDetailVO.setPicList(Arrays.asList(storeOrderRpcDTO.getPics().split(";")));
        } else {
            storeReceiveDetailVO.setPicList(Collections.emptyList());
        }
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setRelateDocClsName("\u95e8\u5e97\u8ba2\u8d27\u5355");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getOrderNo());
        } else {
            storeReceiveDetailVO.setRelateDocClsName("\u95e8\u5e97\u6536\u8d27\u5355");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getReceiveDocNo());
        }
        storeReceiveDetailVO.setDocType(thisDO.getDocType());
        if (thisDO.getDocType().equals("TRN")) {
            storeReceiveDetailVO.setDocTypeName("\u4ed3\u914d");
        } else {
            storeReceiveDetailVO.setDocTypeName("\u4f9b\u5e94\u5546\u76f4\u53d1");
        }
        ArrayList<StoreOrderDRpcDTO> storeOrderDRpcDTOS = new ArrayList<StoreOrderDRpcDTO>();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (StoreOrderDRpcDTO invTrnDRpcDTO : storeOrderRpcDTO.getInvTrnDRpcDTOS()) {
            if ("SF".equals(invTrnDRpcDTO.getLineType())) continue;
            storeOrderDRpcDTOS.add(invTrnDRpcDTO);
            itemIds.add(invTrnDRpcDTO.getItemId());
        }
        Map<Object, Object> itmItemLotMap = new HashMap();
        Map<Object, Object> itmItemSimplemap = new HashMap();
        if (CollectionUtil.isNotEmpty(itemIds)) {
            List lotRpcDTOS = this.itmItemRpcService.findLotRpcDTOS(itemIds);
            itmItemLotMap = lotRpcDTOS.stream().collect(Collectors.toMap(ItmItemLotRpcDTO::getId, Function.identity(), (v1, v2) -> v1));
            List simpleItem = this.itmItemRpcService.findSimpleItem(itemIds);
            itmItemSimplemap = simpleItem.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, Function.identity(), (v1, v2) -> v1));
        }
        Map<Long, List<DemandOrderDtl>> itemImgUrlMap = this.getItemImgUrlMap(thisDO.getOrderId());
        Map suppUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", Set.of("UOM"));
        Map invUdcMap = this.udcProvider.getValueMapByUdcCode("yst-inv", Set.of("STK_ITM_STATUS"));
        String orderItemSetting = SysUtils.getOrderItemSetting();
        ArrayList<StoreReceiveDDetailVO> items = new ArrayList<StoreReceiveDDetailVO>();
        List<Object> rpcDTOS = new ArrayList<StoreCanRtnQtyRpcDTO>();
        if (thisDO.getRtType().equals("R")) {
            rpcDTOS = (List)this.storeOrderTrnProvider.canRtn(docId, thisDO.getDocType()).computeData();
        } else if (thisDO.getRtType().equals("T")) {
            rpcDTOS = thisDO.getDocType().equals("TRO") ? (List)this.storeOrderTrnProvider.canRtn(thisDO.getReceiveDocId(), "TRN").computeData() : (List)this.storeOrderTrnProvider.canRtn(thisDO.getReceiveDocId(), thisDO.getDocType()).computeData();
        }
        Map<Long, StoreCanRtnQtyRpcDTO> canRtnQtyRpcDTOHashMap = this.getCanRtnQtyRpcDTOMap(rpcDTOS, thisDO.getDocType());
        for (StoreOrderDRpcDTO storeOrderDRpcDTO : storeOrderDRpcDTOS) {
            ItmItemSimpleRpcDTO itmItemSimpleRpcDTO;
            StoreReceiveDDetailVO storeReceiveDDetailVO;
            ItmItemLotRpcDTO itmItemLotRpcDTO = (ItmItemLotRpcDTO)itmItemLotMap.get(storeOrderDRpcDTO.getItemId());
            if (thisDO.getRtType().equals("T") && itmItemLotRpcDTO.getItemCode().equals(orderItemSetting) || (storeReceiveDDetailVO = this.getStoreReceiveDDetailVO(storeOrderDRpcDTO, thisDO, suppUdcMap, itmItemLotRpcDTO, itemImgUrlMap, invUdcMap, canRtnQtyRpcDTOHashMap, orderDDTOMap, itmItemSimpleRpcDTO = (ItmItemSimpleRpcDTO)itmItemSimplemap.get(storeOrderDRpcDTO.getItemId()))) == null) continue;
            items.add(storeReceiveDDetailVO);
        }
        List<StoreReceiveDDetailVO> result = items.stream().filter(d -> StringUtils.isBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<StoreReceiveDDetailVO>> subItemMap = items.stream().filter(d -> StringUtils.isNotBlank((CharSequence)d.getCombineItemCode())).collect(Collectors.groupingBy(StoreReceiveDDetailVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                StoreReceiveDDetailVO combineOrderDRespVO = new StoreReceiveDDetailVO();
                combineOrderDRespVO.setCombineItemCode((String)k);
                combineOrderDRespVO.setCombineItemName(((StoreReceiveDDetailVO)v.get(0)).getCombineItemName());
                combineOrderDRespVO.setSubItemList((List<StoreReceiveDDetailVO>)v);
                result.add(combineOrderDRespVO);
            });
        }
        storeReceiveDetailVO.setItems(result);
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(thisDO.getStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(thisDO.getStatus()));
        }
        String invOidoc = SysUtils.getInvOidoc();
        storeReceiveDetailVO.setIoDO("1".equals(invOidoc));
        storeReceiveDetailVO.setCarrier(storeOrderRpcDTO.getCarrier());
        storeReceiveDetailVO.setLogisCarrierId(storeOrderRpcDTO.getLogisCarrierId());
        storeReceiveDetailVO.setLogisCarrierCode(storeOrderRpcDTO.getLogisCarrierCode());
        storeReceiveDetailVO.setLogisCarrierName(storeReceiveDetailVO.getLogisCarrierName());
        storeReceiveDetailVO.setLogisContactName(storeReceiveDetailVO.getLogisContactName());
        storeReceiveDetailVO.setLogisContactTel(storeReceiveDetailVO.getLogisContactTel());
        if (StrUtil.isNotBlank((CharSequence)storeOrderRpcDTO.getDeliverMethod())) {
            storeReceiveDetailVO.setDeliverMethod(storeOrderRpcDTO.getDeliverMethod());
            Map orderUdcMap = this.udcProvider.getValueMapByUdcCode("yst-order", Set.of("SO_DELIVER_METHOD"));
            storeReceiveDetailVO.setDeliverMethodName((String)((Map)orderUdcMap.get("SO_DELIVER_METHOD")).get(storeReceiveDetailVO.getDeliverMethod()));
        }
        storeReceiveDetailVO.setLogisDocNo(storeOrderRpcDTO.getLogisDocNo());
        List<StoreReceiveDDO> receiveDDOS = this.storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(StoreReceiveDDO::getDid, i -> i));
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        Integer amtPlace = SysUtils.getAmtPlace();
        for (StoreReceiveDDetailVO item : storeReceiveDetailVO.getItems()) {
            BigDecimal price;
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(item.getId());
            if (storeReceiveDDO != null) {
                price = this.getDecimal(storeReceiveDDO.getPrice());
                item.setPrice(price);
                item.setOrderQty(storeReceiveDDO.getQty());
                item.setAmt(item.getOrderQty().multiply(item.getPrice()).setScale((int)amtPlace, RoundingMode.HALF_UP));
            }
            price = this.getDecimal(item.getPrice());
            if (thisDO.getRtType().equals("T") && Objects.equals(storeReceiveDetailVO.getDocStatus(), "CF")) {
                totalAmt = totalAmt.add(this.getDecimal(item.getDeliveryQty()).multiply(price).setScale((int)amtPlace, RoundingMode.HALF_UP));
                totalQty = totalQty.add(this.getDecimal(item.getDeliveryQty()));
                continue;
            }
            if (thisDO.getRtType().equals("R") && Objects.equals(storeReceiveDetailVO.getDocStatus(), "CF")) {
                totalAmt = totalAmt.add(this.getDecimal(item.getReceiveQty()).multiply(price).setScale((int)amtPlace, RoundingMode.HALF_UP));
                totalQty = totalQty.add(this.getDecimal(item.getReceiveQty()));
                continue;
            }
            totalAmt = totalAmt.add(this.getDecimal(item.getOrderQty()).multiply(price).setScale((int)amtPlace, RoundingMode.HALF_UP));
            totalQty = totalQty.add(this.getDecimal(item.getOrderQty()));
        }
        if (paymentAmt.compareTo(BigDecimal.ZERO) > 0) {
            StoreReceiveDDetailVO maxItem;
            BigDecimal diff = totalAmt.subtract(paymentAmt);
            if (diff.compareTo(BigDecimal.ZERO) != 0 && (maxItem = (StoreReceiveDDetailVO)storeReceiveDetailVO.getItems().stream().max(Comparator.comparing(StoreReceiveDDetailVO::getAmt)).orElse(null)) != null) {
                BigDecimal adjustedAmt = maxItem.getAmt().subtract(diff);
                maxItem.setAmt(adjustedAmt);
            }
            storeReceiveDetailVO.setTotalAmt(paymentAmt);
        } else {
            storeReceiveDetailVO.setTotalAmt(totalAmt.setScale((int)amtPlace, RoundingMode.HALF_UP));
        }
        storeReceiveDetailVO.setTotalQty(totalQty);
        storeReceiveDetailVO.setDocStatus(thisDO.getStatus());
        if (thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        }
        return storeReceiveDetailVO;
    }

    private StoreReceiveDDetailVO getStoreReceiveDDetailVO(StoreOrderDRpcDTO invTrnDRpcDTO, StoreReceiveDO thisDO, Map<String, Map<String, String>> suppUdcMap, ItmItemLotRpcDTO itmItemLotRpcDTO, Map<Long, List<DemandOrderDtl>> itemImgUrlMap, Map<String, Map<String, String>> invUdcMap, Map<Long, StoreCanRtnQtyRpcDTO> canRtnQtyRpcDTOHashMap, Map<Long, ScpDemandOrderDDTO> orderDDTOMap, ItmItemSimpleRpcDTO itmItemSimpleRpcDTO) {
        StoreReceiveDDetailVO storeReceiveDDetailVO = new StoreReceiveDDetailVO();
        ScpDemandOrderDDTO demandOrderDDTO = orderDDTOMap.get(invTrnDRpcDTO.getRelateDocDid());
        if (demandOrderDDTO != null) {
            storeReceiveDDetailVO.setCombineItemCode(demandOrderDDTO.getCombineItemCode());
            storeReceiveDDetailVO.setCombineItemName(demandOrderDDTO.getCombineItemName());
        }
        storeReceiveDDetailVO.setGiftFlag(invTrnDRpcDTO.getGiftLineFlag());
        storeReceiveDDetailVO.setId(invTrnDRpcDTO.getId());
        storeReceiveDDetailVO.setManuDate(invTrnDRpcDTO.getManuDate());
        storeReceiveDDetailVO.setManuFactory(invTrnDRpcDTO.getManuFactory());
        storeReceiveDDetailVO.setManuFactoryName(invTrnDRpcDTO.getManuFactoryName());
        storeReceiveDDetailVO.setOrderDid(invTrnDRpcDTO.getRelateDocDid());
        storeReceiveDDetailVO.setItemId(invTrnDRpcDTO.getItemId());
        storeReceiveDDetailVO.setPrice(invTrnDRpcDTO.getTotalPrice() == null ? invTrnDRpcDTO.getPrice() : invTrnDRpcDTO.getTotalPrice());
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getInLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getInLimit1());
            if (invTrnDRpcDTO.getOutQty() == null || BigDecimal.ZERO.compareTo(invTrnDRpcDTO.getOutQty()) == 0) {
                return null;
            }
        } else if (thisDO.getStatus().equals("CF")) {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getOutLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
        } else {
            storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getLotNo());
            storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
        }
        if (thisDO.getDocType().equals("GR")) {
            storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty());
            storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty());
            storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty());
            storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom());
            storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom()));
        } else {
            if (invTrnDRpcDTO.getQty2() == null) {
                return null;
            }
            storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty2());
            storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty2());
            storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty2());
            storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom2());
            storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom2()));
        }
        if (itmItemLotRpcDTO != null) {
            storeReceiveDDetailVO.setItemCode(itmItemLotRpcDTO.getItemCode());
            storeReceiveDDetailVO.setItemName(itmItemLotRpcDTO.getItemName());
            storeReceiveDDetailVO.setSpec(itmItemLotRpcDTO.getSpec());
            storeReceiveDDetailVO.setLotFlag(itmItemLotRpcDTO.getLotFlag());
            List<DemandOrderDtl> demandOrderDtls = itemImgUrlMap.get(itmItemLotRpcDTO.getId());
            if (CollectionUtil.isNotEmpty(demandOrderDtls)) {
                storeReceiveDDetailVO.setImageUrl(demandOrderDtls.get(0).getImgUrl());
            }
        }
        if (itmItemSimpleRpcDTO != null) {
            storeReceiveDDetailVO.setDecimalPlaces(itmItemSimpleRpcDTO.getDecimalPlaces());
        }
        storeReceiveDDetailVO.setLimit1Name(invUdcMap.get("STK_ITM_STATUS").get(storeReceiveDDetailVO.getLimit1()));
        if (CollectionUtil.isNotEmpty(canRtnQtyRpcDTOHashMap)) {
            StoreCanRtnQtyRpcDTO storeCanRtnQtyRpcDTO = thisDO.getRtType().equals("T") ? (thisDO.getDocType().equals("TRO") ? canRtnQtyRpcDTOHashMap.get(invTrnDRpcDTO.getRelateDocDid()) : canRtnQtyRpcDTOHashMap.get(invTrnDRpcDTO.getRelate2Did())) : canRtnQtyRpcDTOHashMap.get(storeReceiveDDetailVO.getId());
            if (storeCanRtnQtyRpcDTO != null) {
                storeReceiveDDetailVO.setCanRtnQty(storeCanRtnQtyRpcDTO.getCanRtnQty());
                storeReceiveDDetailVO.setStkQty(storeCanRtnQtyRpcDTO.getStkQty());
            }
        }
        return storeReceiveDDetailVO;
    }

    private void assignAddress(StoreReceiveDetailVO storeReceiveDetailVO, Long addrNo) {
        if (addrNo == null || addrNo <= 0L) {
            return;
        }
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setAddrNos(List.of(addrNo));
        List addrAddressRpcDtoByParam = this.orgAddrRpcService.findAddrAddressRpcDtoByParam(orgAddressRpcDtoParam);
        if (CollectionUtil.isEmpty((Collection)addrAddressRpcDtoByParam)) {
            return;
        }
        OrgAddressRpcDTO orgAddressRpcDTO = addrAddressRpcDtoByParam.stream().filter(i -> i.getDefaultFlag() != null && i.getDefaultFlag() != false).findFirst().orElseGet(() -> null);
        if (orgAddressRpcDTO == null) {
            return;
        }
        storeReceiveDetailVO.setCountry(orgAddressRpcDTO.getCountry());
        storeReceiveDetailVO.setCountryName(orgAddressRpcDTO.getCountryName());
        storeReceiveDetailVO.setProvince(orgAddressRpcDTO.getProvince());
        storeReceiveDetailVO.setProvinceName(orgAddressRpcDTO.getProvinceName());
        storeReceiveDetailVO.setCity(orgAddressRpcDTO.getCity());
        storeReceiveDetailVO.setCityName(orgAddressRpcDTO.getCityName());
        storeReceiveDetailVO.setCounty(orgAddressRpcDTO.getCounty());
        storeReceiveDetailVO.setCountyName(orgAddressRpcDTO.getCountyName());
        storeReceiveDetailVO.setDetailaddr(orgAddressRpcDTO.getDetailAddr());
        storeReceiveDetailVO.setContPerson(orgAddressRpcDTO.getContPerson());
        storeReceiveDetailVO.setTel(orgAddressRpcDTO.getTel());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveConfirm(StoreReceiveConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        String recvKey = "RECEIVE" + confirmParam.getDocId().toString();
        if (this.redisTemplate.hasKey((Object)recvKey).booleanValue()) {
            throw new BusinessException("\u6b63\u5728\u6536\u8d27\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Boolean isPoSet = this.redisTemplate.opsForValue().setIfAbsent((Object)recvKey, (Object)"1", 60L, TimeUnit.SECONDS);
        if (Boolean.FALSE.equals(isPoSet)) {
            throw new BusinessException("\u6b63\u5728\u6536\u8d27\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5f85\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        StoreReceiveRpcDTO storeReceiveRpcDTO = new StoreReceiveRpcDTO();
        storeReceiveRpcDTO.setDocId(thisDO.getDocId());
        storeReceiveRpcDTO.setDocNo(thisDO.getDocNo());
        storeReceiveRpcDTO.setDocType(thisDO.getDocType());
        ArrayList<StoreReceiveRpcDTO.StoreReceiveRpcDTODetail> details = new ArrayList<StoreReceiveRpcDTO.StoreReceiveRpcDTODetail>();
        for (StoreReceiveConfirmParam.StoreReceiveConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveRpcDTO.StoreReceiveRpcDTODetail rpcDetail = new StoreReceiveRpcDTO.StoreReceiveRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            rpcDetail.setManuDate(detail.getManuDate());
            rpcDetail.setLimit1(detail.getLimit1());
            rpcDetail.setLotNo(detail.getLotNo());
            details.add(rpcDetail);
        }
        storeReceiveRpcDTO.setDetails(details);
        try {
            StoreReceiveSubmitMqParam orderSubmitMqParam = new StoreReceiveSubmitMqParam();
            orderSubmitMqParam.setReceiveRpcDTO(storeReceiveRpcDTO);
            orderSubmitMqParam.setDocId(confirmParam.getDocId());
            orderSubmitMqParam.setBusinessKey("store_receive_submit");
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "store_receive_submit", (Serializable)orderSubmitMqParam);
        }
        catch (Exception e) {
            log.info("\u95e8\u5e97\u6536\u8d27\u63d0\u4ea4\uff1a{},\u53d1\u9001mq\u6d88\u606f\u5931\u8d25\uff1a{}", (Object)confirmParam.getDocId(), (Object)e.toString());
            this.redisTemplate.delete((Object)recvKey);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rtnConfirm(StoreRtnConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "T") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5f85\u9000\u8d27\u72b6\u6001", (Object[])new Object[0]);
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDeliveryMethod(confirmParam.getDeliveryMethod());
        storeRtnRpcDTO.setDocType(thisDO.getDocType());
        storeRtnRpcDTO.setLogisDocNo(confirmParam.getLogisDocNo());
        storeRtnRpcDTO.setLogisCarrierId(confirmParam.getLogisCarrierId());
        storeRtnRpcDTO.setLogisCarrierCode(confirmParam.getLogisCarrierCode());
        storeRtnRpcDTO.setLogisCarrierName(confirmParam.getLogisCarrierName());
        storeRtnRpcDTO.setNote(confirmParam.getNote());
        storeRtnRpcDTO.setLogisContactTel(confirmParam.getLogisContactTel());
        storeRtnRpcDTO.setLogisContactName(confirmParam.getLogisContactName());
        List<StoreReceiveDDO> receiveDDOS = this.storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(StoreReceiveDDO::getDid, i -> i));
        ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
        for (StoreRtnConfirmParam.StoreRtnConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(detail.getId());
            if (storeReceiveDDO == null) {
                throw new BusinessException("\u5546\u54c1" + detail.getItemCode() + "\u4e0d\u5728\u9000\u8d27\u7533\u8bf7\u5355\u5185");
            }
            if (storeReceiveDDO.getQty().compareTo(detail.getQty()) < 0) {
                throw new BusinessException("\u5546\u54c1" + detail.getItemCode() + "\u9000\u8d27\u6570\u91cf" + detail.getQty() + "\u5927\u4e8e\u7533\u8bf7\u6570\u91cf" + storeReceiveDDO.getQty());
            }
            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        this.storeOrderTrnProvider.rtn(storeRtnRpcDTO).computeData();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rtnApply(StoreRtnApplyParam applyParam) {
        List<StoreReceiveDO> statusNotIn = this.storeReceiveRepo.findAllByOrderIdAndRtTypeAndStatusNotIn(applyParam.getOrderId(), "T", Arrays.asList("CF", "APPROVED", "CL"));
        if (CollUtil.isNotEmpty(statusNotIn)) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u9000\u5355");
        }
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(applyParam.getDocId());
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDocType(thisDO.getDocType());
        storeRtnRpcDTO.setRefundType("RETURN");
        storeRtnRpcDTO.setRefundTypeName("\u9000\u8d27\u9000\u6b3e");
        storeRtnRpcDTO.setNote(applyParam.getNote());
        storeRtnRpcDTO.setPicList(applyParam.getPicList());
        storeRtnRpcDTO.setDeliveryMethod(applyParam.getDeliveryMethod());
        ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
        for (StoreRtnApplyParam.StoreRtnApplyDetail detail : applyParam.getDetails()) {
            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemName(detail.getItemName());
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        StoreRtnApplyResult result = (StoreRtnApplyResult)this.storeOrderTrnProvider.rtnApply(storeRtnRpcDTO).computeData();
        StoreReceiveDO receiveDO = new StoreReceiveDO();
        receiveDO.setDocCreateDate(LocalDateTime.now());
        receiveDO.setStatus("DR");
        receiveDO.setDocId(result.getDocId());
        receiveDO.setDocNo(result.getDocNo());
        receiveDO.setOrderId(thisDO.getOrderId());
        receiveDO.setOrderNo(thisDO.getOrderNo());
        receiveDO.setOrderDate(thisDO.getOrderDate());
        receiveDO.setReceiveDate(thisDO.getReceiveDate());
        receiveDO.setDeliveryDate(thisDO.getDeliveryDate());
        receiveDO.setStoreId(thisDO.getStoreId());
        receiveDO.setOrderSetId(thisDO.getOrderSetId());
        String docType = "GR".equals(thisDO.getDocType()) ? "GR" : "TRO";
        receiveDO.setDocType(docType);
        receiveDO.setReceiveDocId(thisDO.getDocId());
        receiveDO.setReceiveDocNo(thisDO.getDocNo());
        receiveDO.setTotalAmt(applyParam.getDetails().stream().filter(i -> i.getQty() != null && i.getPrice() != null).map(i -> i.getQty().multiply(i.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
        receiveDO.setTotalQty(applyParam.getDetails().stream().map(StoreRtnApplyParam.StoreRtnApplyDetail::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
        receiveDO.setRtType("T");
        receiveDO.setRefundType("RETURN");
        receiveDO.setRefundTypeName("\u9000\u8d27\u9000\u6b3e");
        StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(receiveDO);
        Map<Long, BigDecimal> priceMap = applyParam.getDetails().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(StoreRtnApplyParam.StoreRtnApplyDetail::getId, i -> i.getPrice()));
        ArrayList<StoreReceiveDDO> receiveDDOS = new ArrayList<StoreReceiveDDO>();
        for (StoreRtnApplyResult.OrderItem item : result.getItems()) {
            StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
            storeReceiveDDO.setDid(item.getDid());
            storeReceiveDDO.setId(IdFactory.generateLong());
            storeReceiveDDO.setItemId(item.getItemId());
            storeReceiveDDO.setMasId(saved.getId());
            storeReceiveDDO.setQty(item.getQty());
            storeReceiveDDO.setPrice(priceMap.get(item.getRelateDocDid()));
            receiveDDOS.add(storeReceiveDDO);
        }
        this.storeReceiveDRepo.saveAll(receiveDDOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RtnApplyResult reFundApply(List<StoreRtnApplyParam> storeRtnApplyParamList) {
        RtnApplyResult rtnApplyResult = new RtnApplyResult();
        List<StoreReceiveDO> statusNotIn = this.storeReceiveRepo.findAllByOrderIdAndRtTypeAndStatusNotIn(storeRtnApplyParamList.get(0).getOrderId(), "T", Arrays.asList("CF", "APPROVED", "CL"));
        if (CollUtil.isNotEmpty(statusNotIn)) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u9000\u5355");
        }
        for (StoreRtnApplyParam applyParam : storeRtnApplyParamList) {
            try {
                StoreRtnApplyResult result;
                List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(applyParam.getDocId());
                Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
                Assert.isTrue((Objects.equals(storeReceiveDO.getStatus(), "CF") && Objects.equals(storeReceiveDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
                StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
                storeRtnRpcDTO.setDocId(storeReceiveDO.getDocId());
                storeRtnRpcDTO.setDocType(storeReceiveDO.getDocType());
                storeRtnRpcDTO.setRefundType("REFUND");
                storeRtnRpcDTO.setRefundTypeName("\u8d54\u4ed8");
                storeRtnRpcDTO.setNote(applyParam.getNote());
                storeRtnRpcDTO.setPicList(applyParam.getPicList());
                storeRtnRpcDTO.setDeliveryMethod(applyParam.getDeliveryMethod());
                ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
                for (StoreRtnApplyParam.StoreRtnApplyDetail detail : applyParam.getDetails()) {
                    StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
                    if (detail.getQty() == null || detail.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                        throw new IllegalArgumentException("\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    rpcDetail.setQty(detail.getQty());
                    rpcDetail.setId(detail.getId());
                    rpcDetail.setUom(detail.getUom());
                    rpcDetail.setUomRatio(detail.getUomRatio());
                    rpcDetail.setPlaces(detail.getPlaces());
                    rpcDetail.setItemCode(detail.getItemCode());
                    rpcDetail.setItemName(detail.getItemName());
                    details.add(rpcDetail);
                }
                storeRtnRpcDTO.setDetails(details);
                try {
                    result = (StoreRtnApplyResult)this.storeOrderTrnProvider.rtnApply(storeRtnRpcDTO).computeData();
                }
                catch (Exception e) {
                    log.error("\u8d54\u4ed8\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                    throw new BusinessException(e.getMessage());
                }
                StoreReceiveDO receiveDO = new StoreReceiveDO();
                receiveDO.setDocCreateDate(LocalDateTime.now());
                receiveDO.setStatus("DR");
                receiveDO.setDocId(result.getDocId());
                receiveDO.setDocNo(result.getDocNo());
                receiveDO.setOrderId(storeReceiveDO.getOrderId());
                receiveDO.setOrderNo(storeReceiveDO.getOrderNo());
                receiveDO.setOrderDate(storeReceiveDO.getOrderDate());
                receiveDO.setReceiveDate(storeReceiveDO.getReceiveDate());
                receiveDO.setDeliveryDate(storeReceiveDO.getDeliveryDate());
                receiveDO.setStoreId(storeReceiveDO.getStoreId());
                receiveDO.setOrderSetId(storeReceiveDO.getOrderSetId());
                String docType = "GR".equals(storeReceiveDO.getDocType()) ? "GR" : "TRO";
                receiveDO.setDocType(docType);
                receiveDO.setReceiveDocId(storeReceiveDO.getDocId());
                receiveDO.setReceiveDocNo(storeReceiveDO.getDocNo());
                AtomicReference<BigDecimal> reduceQty = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                BigDecimal reduceAmt = applyParam.getDetails().stream().filter(i -> i.getQty() != null && i.getPrice() != null).map(i -> {
                    BigDecimal qty = i.getQty();
                    if (i.getUom() != null && i.getUomRatio() != null && i.getPlaces() != null) {
                        qty = qty.multiply(i.getUomRatio()).setScale((int)i.getPlaces(), RoundingMode.HALF_UP);
                    }
                    reduceQty.set(((BigDecimal)reduceQty.get()).add(qty));
                    return qty.multiply(i.getPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                receiveDO.setTotalAmt(reduceAmt);
                receiveDO.setTotalQty(reduceQty.get());
                receiveDO.setRtType("T");
                receiveDO.setRefundType("REFUND");
                receiveDO.setRefundTypeName("\u8d54\u4ed8");
                StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(receiveDO);
                Map<Long, BigDecimal> priceMap = applyParam.getDetails().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(StoreRtnApplyParam.StoreRtnApplyDetail::getId, StoreRtnApplyParam.StoreRtnApplyDetail::getPrice));
                ArrayList<StoreReceiveDDO> receiveDDOS = new ArrayList<StoreReceiveDDO>();
                for (StoreRtnApplyResult.OrderItem item : result.getItems()) {
                    StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
                    storeReceiveDDO.setDid(item.getDid());
                    storeReceiveDDO.setId(IdFactory.generateLong());
                    storeReceiveDDO.setItemId(item.getItemId());
                    storeReceiveDDO.setMasId(saved.getId());
                    storeReceiveDDO.setQty(item.getQty());
                    storeReceiveDDO.setPrice(priceMap.get(item.getRelateDocDid()) == null ? BigDecimal.ZERO : priceMap.get(item.getRelateDocDid()).setScale(2, RoundingMode.HALF_UP));
                    receiveDDOS.add(storeReceiveDDO);
                }
                this.storeReceiveDRepo.saveAll(receiveDDOS);
                rtnApplyResult.getSuccessList().add(applyParam);
            }
            catch (IllegalArgumentException e) {
                log.error("\u8d54\u4ed8\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                rtnApplyResult.getFailedList().add(new RtnApplyResult.FailedRtnApply(applyParam, e.getMessage()));
            }
        }
        return rtnApplyResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RtnApplyResult rtnApplyByOrder(List<StoreRtnApplyParam> applyParamList) {
        RtnApplyResult rtnApplyResult = new RtnApplyResult();
        List<StoreReceiveDO> statusNotIn = this.storeReceiveRepo.findAllByOrderIdAndRtTypeAndStatusNotIn(applyParamList.get(0).getOrderId(), "T", Arrays.asList("CF", "APPROVED", "CL"));
        if (CollUtil.isNotEmpty(statusNotIn)) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u9000\u5355");
        }
        for (StoreRtnApplyParam applyParam : applyParamList) {
            try {
                StoreRtnApplyResult result;
                StoreReceiveDO storeReceiveDO = this.storeReceiveRepo.findByDocId(applyParam.getDocId());
                Assert.notNull((Object)storeReceiveDO, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                Assert.isTrue((Objects.equals(storeReceiveDO.getStatus(), "CF") && Objects.equals(storeReceiveDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
                StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
                storeRtnRpcDTO.setDocId(storeReceiveDO.getDocId());
                storeRtnRpcDTO.setDocType(storeReceiveDO.getDocType());
                storeRtnRpcDTO.setRefundType("RETURN");
                storeRtnRpcDTO.setRefundTypeName("\u9000\u8d27\u9000\u6b3e");
                storeRtnRpcDTO.setNote(applyParam.getNote());
                storeRtnRpcDTO.setPicList(applyParam.getPicList());
                storeRtnRpcDTO.setDeliveryMethod(applyParam.getDeliveryMethod());
                ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<StoreRtnRpcDTO.StoreRtnRpcDTODetail>();
                for (StoreRtnApplyParam.StoreRtnApplyDetail detail : applyParam.getDetails()) {
                    StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
                    if (detail.getQty() == null || detail.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                        throw new IllegalArgumentException("\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    rpcDetail.setQty(detail.getQty());
                    rpcDetail.setId(detail.getId());
                    rpcDetail.setItemCode(detail.getItemCode());
                    rpcDetail.setItemName(detail.getItemName());
                    details.add(rpcDetail);
                }
                storeRtnRpcDTO.setDetails(details);
                try {
                    result = (StoreRtnApplyResult)this.storeOrderTrnProvider.rtnApply(storeRtnRpcDTO).computeData();
                }
                catch (Exception e) {
                    log.error("\u9000\u8d27\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                    throw new BusinessException(e.getMessage());
                }
                StoreReceiveDO receiveDO = this.getStoreReceiveDO(applyParam.getDetails(), result, storeReceiveDO);
                receiveDO.setRefundType("RETURN");
                receiveDO.setRefundTypeName("\u9000\u8d27\u9000\u6b3e");
                StoreReceiveDO saved = (StoreReceiveDO)this.storeReceiveRepo.save(receiveDO);
                Map<Long, BigDecimal> priceMap = applyParam.getDetails().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(StoreRtnApplyParam.StoreRtnApplyDetail::getId, StoreRtnApplyParam.StoreRtnApplyDetail::getPrice));
                ArrayList<StoreReceiveDDO> receiveDDOS = new ArrayList<StoreReceiveDDO>();
                for (StoreRtnApplyResult.OrderItem item : result.getItems()) {
                    StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
                    storeReceiveDDO.setDid(item.getDid());
                    storeReceiveDDO.setId(IdFactory.generateLong());
                    storeReceiveDDO.setItemId(item.getItemId());
                    storeReceiveDDO.setMasId(saved.getId());
                    storeReceiveDDO.setQty(item.getQty());
                    storeReceiveDDO.setPrice(priceMap.get(item.getRelateDocDid()));
                    receiveDDOS.add(storeReceiveDDO);
                }
                this.storeReceiveDRepo.saveAll(receiveDDOS);
                rtnApplyResult.getSuccessList().add(applyParam);
            }
            catch (Exception e) {
                log.error("\u9000\u8d27\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                rtnApplyResult.getFailedList().add(new RtnApplyResult.FailedRtnApply(applyParam, e.getMessage()));
            }
        }
        return rtnApplyResult;
    }

    @NotNull
    private StoreReceiveDO getStoreReceiveDO(List<StoreRtnApplyParam.StoreRtnApplyDetail> details, StoreRtnApplyResult result, StoreReceiveDO thisDO) {
        Integer amtPlace = SysUtils.getAmtPlace();
        StoreReceiveDO receiveDO = new StoreReceiveDO();
        receiveDO.setDocCreateDate(LocalDateTime.now());
        receiveDO.setStatus("DR");
        receiveDO.setDocId(result.getDocId());
        receiveDO.setDocNo(result.getDocNo());
        receiveDO.setOrderId(thisDO.getOrderId());
        receiveDO.setOrderNo(thisDO.getOrderNo());
        receiveDO.setOrderDate(thisDO.getOrderDate());
        receiveDO.setReceiveDate(thisDO.getReceiveDate());
        receiveDO.setDeliveryDate(thisDO.getDeliveryDate());
        receiveDO.setStoreId(thisDO.getStoreId());
        receiveDO.setOrderSetId(thisDO.getOrderSetId());
        String docType = "GR".equals(thisDO.getDocType()) ? "GR" : "TRO";
        receiveDO.setDocType(docType);
        receiveDO.setReceiveDocId(thisDO.getDocId());
        receiveDO.setReceiveDocNo(thisDO.getDocNo());
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        for (StoreRtnApplyParam.StoreRtnApplyDetail storeRtnApplyDetail : details) {
            if (storeRtnApplyDetail != null && storeRtnApplyDetail.getQty() != null) {
                totalQty = totalQty.add(storeRtnApplyDetail.getQty());
            }
            if (storeRtnApplyDetail == null || storeRtnApplyDetail.getQty() == null || storeRtnApplyDetail.getPrice() == null) continue;
            BigDecimal multiply = storeRtnApplyDetail.getQty().multiply(storeRtnApplyDetail.getPrice().setScale((int)amtPlace, RoundingMode.HALF_UP));
            totalAmt = totalAmt.add(multiply);
        }
        receiveDO.setTotalAmt(totalAmt.setScale((int)amtPlace, RoundingMode.HALF_UP));
        receiveDO.setTotalQty(totalQty);
        receiveDO.setRtType("T");
        return receiveDO;
    }

    @Override
    public List<StoreCanRtnQtyRpcDTO> canRtn(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R") ? 1 : 0) != 0, (String)"\u5355\u636e\u4e0d\u662f\u5df2\u6536\u8d27\u72b6\u6001", (Object[])new Object[0]);
        List rpcDTOS = (List)this.storeOrderTrnProvider.canRtn(docId, thisDO.getDocType()).computeData();
        rpcDTOS.forEach(row -> {
            if ("GR".equals(thisDO.getDocType())) {
                row.setCanRtnQty(row.getCanRtnQty());
            } else if (row.getCanRtnQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setCanRtnQty(row.getCanRtnQty().divide(row.getUomRatio(), (int)row.getPlaces(), 4));
            }
            if (row.getStkQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setStkQty(row.getStkQty().divide(row.getUomRatio(), (int)row.getPlaces(), 4));
            }
        });
        return rpcDTOS;
    }

    @Override
    public Boolean rtnPermission(Long orderId) {
        List<StoreReceiveDO> statusNotIn = this.storeReceiveRepo.findAllByOrderIdAndRtTypeAndStatusNotIn(orderId, "T", Arrays.asList("CF", "APPROVED", "CL"));
        if (CollUtil.isNotEmpty(statusNotIn)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void abort(Long docId) {
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, (String)"\u5355\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue((boolean)thisDO.getStatus().equals("DR"), (String)"\u9000\u8d27\u7533\u8bf7\u4e0d\u53ef\u4f5c\u5e9f", (Object[])new Object[0]);
        if (thisDO.getDocType().equals("TRN")) {
            this.storeOrderTrnProvider.abort(docId).computeData();
        } else {
            this.purRnsProvider.abort(docId).computeData();
        }
        thisDO.setStatus("CL");
        this.storeReceiveRepo.save(thisDO);
    }

    @Override
    public Long countStoreReceive(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page = this.storeReceiveRepoProc.page(param);
        return page.getTotal();
    }

    private Map<Long, List<DemandOrderDtl>> getItemImgUrlMap(Long orderId) {
        List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtlWithSettlePrice(orderId);
        if (CollUtil.isNotEmpty(orderDtl)) {
            return orderDtl.stream().collect(Collectors.groupingBy(DemandOrderDtl::getItemId));
        }
        return new HashMap<Long, List<DemandOrderDtl>>();
    }

    public StoreReceiveServiceImpl(StoreReceiveRepo storeReceiveRepo, StoreReceiveDRepo storeReceiveDRepo, StoreReceiveRepoProc storeReceiveRepoProc, OrgOuRpcService orgOuRpcService, ItmItemRpcService itmItemRpcService, UdcProvider udcProvider, OrgAddrRpcService orgAddrRpcService, StoreOrderTrnProvider storeOrderTrnProvider, PurRnsProvider purRnsProvider, TaskExecutor taskExecutor, MessageQueueTemplate messageQueueTemplate, RedisTemplate<String, Object> redisTemplate, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, ScpDemandOrderDRepo scpDemandOrderDRepo, RmiSysUDCService rmiSysUDCService) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveDRepo = storeReceiveDRepo;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.orgOuRpcService = orgOuRpcService;
        this.itmItemRpcService = itmItemRpcService;
        this.udcProvider = udcProvider;
        this.orgAddrRpcService = orgAddrRpcService;
        this.storeOrderTrnProvider = storeOrderTrnProvider;
        this.purRnsProvider = purRnsProvider;
        this.taskExecutor = taskExecutor;
        this.messageQueueTemplate = messageQueueTemplate;
        this.redisTemplate = redisTemplate;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.rmiSysUDCService = rmiSysUDCService;
    }

    static {
        rtnStatusMap.put("DR", "\u9000\u8d27\u5f85\u5ba1");
        rtnStatusMap.put("CE", "\u5f85\u9000\u8d27");
        rtnStatusMap.put("CF", "\u5df2\u9000\u8d27");
        rtnStatusMap.put("CL", "\u5df2\u53d6\u6d88");
        rtnStatusMap.put("APPROVED", "\u5ba1\u6279\u901a\u8fc7");
        receiveStatusMap.put("CE", "\u5f85\u6536\u8d27");
        receiveStatusMap.put("CF", "\u5df2\u6536\u8d27");
        receiveStatusMap.put("CL", "\u5df2\u53d6\u6d88");
    }
}

