/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingDO;
import com.elitesland.scp.domain.entity.alloc.QScpAllocSettingStoreDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ScpAllocSettingStoreRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpAllocSettingStoreDO scpAllocSettingStoreDO = QScpAllocSettingStoreDO.scpAllocSettingStoreDO;
    private static final QScpAllocSettingDO scpAllocSettingDO = QScpAllocSettingDO.scpAllocSettingDO;
    private final QBean<ScpAllocSettingStoreRespVO> pageList;

    public long countAllocSettingStore(ScpAllocSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scpAllocSettingStoreDO.count()).from((EntityPath)scpAllocSettingStoreDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpAllocSettingStoreRespVO> queryAllocSettingStore(ScpAllocSettingStorePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpAllocSettingStoreDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpAllocSettingStoreDO);
        jpaQuery.where(this.whereAllocSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereAllocSettingPage(ScpAllocSettingStorePageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getMasId() != null) {
            predicates.add(ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.eq((Object)paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            predicates.add(ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreCode())) {
            predicates.add(ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<Long> findMasIdByStoreCodeIn(List<String> storeCodes, Set<Long> masIds) {
        JPAQuery where = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId).distinct()).from((EntityPath)scpAllocSettingStoreDO)).where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode.in(storeCodes));
        if (CollectionUtils.isNotEmpty(masIds)) {
            where.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.in(masIds));
        }
        return where.fetch();
    }

    public List<ScpAllocSettingStoreRespVO> findByParam(ScpAllocSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpAllocSettingStoreRespVO.class, (Expression[])new Expression[]{ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.id, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeName, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeType2, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.maxNum, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.allocNum})).from((EntityPath)scpAllocSettingStoreDO);
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.in(paramVO.getMasIds()));
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreCode())) {
            jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        if (paramVO.getUsed() != null && paramVO.getUsed().booleanValue()) {
            jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.allocNum.gt((Number)BigDecimal.ZERO));
        }
        return jpaQuery.fetch();
    }

    public List<ScpAllocSettingStoreRespVO> findEnabledByParam(ScpAllocSettingStoreParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpAllocSettingStoreRespVO.class, (Expression[])new Expression[]{ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.id, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeName})).from((EntityPath)scpAllocSettingStoreDO)).leftJoin((EntityPath)scpAllocSettingDO)).on((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.eq(ScpAllocSettingStoreRepoProc.scpAllocSettingDO.id));
        if (CollUtil.isNotEmpty(paramVO.getMasIds())) {
            jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.in(paramVO.getMasIds()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode.in(paramVO.getStoreCodes()));
        }
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingDO.status.eq(Boolean.TRUE));
        LocalDateTime startOfDay = LocalDateTime.now().toLocalDate().atStartOfDay();
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingDO.validTo.goe((Comparable)startOfDay));
        return jpaQuery.fetch();
    }

    public List<Long> findUsedSettingByMasIds(List<Long> masIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId).distinct()).from((EntityPath)scpAllocSettingStoreDO);
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.in(masIds));
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.allocNum.gt((Number)0));
        return jpaQuery.fetch();
    }

    public List<String> findActiveSettingByMasIds(Long masId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode).distinct()).from((EntityPath)scpAllocSettingStoreDO);
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId.eq((Object)masId));
        jpaQuery.where((Predicate)ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.maxNum.gt((Number)0));
        return jpaQuery.fetch();
    }

    public ScpAllocSettingStoreRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpAllocSettingStoreRespVO.class, (Expression[])new Expression[]{ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.id, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.masId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeId, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeCode, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeName, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.storeType2, ScpAllocSettingStoreRepoProc.scpAllocSettingStoreDO.maxNum});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

