package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("订货集分页返回")
public class ScpDemandSetPageRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("需求条目汇总")
    private Integer demandItemQty;

    @ApiModelProperty("状态, true: 开启, false: 禁用")
    private Boolean status;

    @ApiModelProperty("是否已推送，true: 已推送，false: 未推送")
    private Boolean isPushed;

    @ApiModelProperty("计算分配结果")
    private String computeMsg;

    @ApiModelProperty("订货截止时间点，格式：HH:mm:ss")
    private String expireTimeStr;

    @ApiModelProperty("订货截止时间点，格式：yyyy-MM-dd HH:mm:ss")
    private LocalDateTime expireTime;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;
}
