package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.threadpool.ThreadPoolAutoConfiguration;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListParamVO;
import com.elitesland.scp.application.facade.vo.template.DemandOrderListRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import com.elitesland.scp.application.service.template.DemandOrderTemplateService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpStoreDemandCalendarRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class StoreAppletServiceImpl implements StoreAppletService {

    @Autowired
    @Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
    private TaskExecutor taskExecutor;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ItmItemRpcService itmItemRpcService;
    private final DemandOrderTemplateService demandOrderTemplateService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpStoreDemandCalendarRepo scpStoreDemandCalendarRepo;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private ScpStoreDemandCalendarRepoProc scpStoreDemandCalendarRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    public StoreAppletHomeVO find(Long storeId, LocalDateTime startDate, String demandWhStCode, String type) {
        StoreAppletHomeVO storeAppletHomeVO = new StoreAppletHomeVO();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("当前登录人查询异常");
        }
        // 查询订货账号类型
        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("当前登录人订货账号:{}", JSONUtil.toJsonStr(byLoginAccount));
        if (byLoginAccount == null) {
            throw new BusinessException("当前登录人订货账号查询异常");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        String invisibleAccount = SysUtils.getInvisibleAccount();
        List<String> invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
        log.info("限制账号类型:{}", JSONUtil.toJsonStr(invisibleAccountList));

        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setReceiveCount(storeReceiveRepoProc.findReceive(storeId, startDate));
            storeAppletHomeVO.setReplyCount(scpDemandOrderRepoProc.countUnReply(storeId, startDate));
        }, taskExecutor);

        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            storeAppletHomeVO.setRtnCount(storeReceiveRepoProc.findRtn(storeId, startDate));
            storeAppletHomeVO.setOrderCount(storeReceiveRepoProc.findOrderCount(storeId, startDate));
//            storeAppletHomeVO.setOrderCalendar(storeReceiveRepoProc.storeCalendar(storeId));

            // 当前用户的订货账号类型是否包含在配置里
            if (invisibleAccountList.contains(scpManType)) {
                // 先查处所有配送类型
//                List<String> allDeliveryType = scpStoreDemandCalendarRepo.findAllDeliveryType();
                Map<String, String> itemType2 = rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
                List<String> allDeliveryType = new ArrayList<>(itemType2.keySet());

                // 获取所有配送类型 加上门店，门店查不到，再查一下查不到的配送类型对应的区域
                // 通过所有配送类型和门店，查询门店订货日历信息
                String year = String.valueOf(LocalDateTime.now().getYear());
                String month = String.format("%02d", LocalDateTime.now().getMonthValue());
                String day = String.valueOf(LocalDateTime.now().getDayOfMonth());
                List<ScpStoreDemandCalendarDO> calendarList = scpStoreDemandCalendarRepoProc.findByUniqueKeys(allDeliveryType, "STORE", demandWhStCode, year, month, day);
                List<String> regionDeliveryType = new ArrayList<>();
                List<ScpStoreDemandCalendarDO> calendarResultList = new ArrayList<>();
                if (calendarList != null && !calendarList.isEmpty()) {
                    calendarList.forEach(calendar -> {
                        if (!allDeliveryType.contains(calendar.getDeliveryType())) {
                            regionDeliveryType.add(calendar.getDeliveryType());
                        }
                        calendarResultList.add(calendar);
                    });
                }

                if (CollectionUtil.isNotEmpty(regionDeliveryType)) {
                    // 根据门店编码获取门店信息
                    OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(orgStoreRpcService.get(storeId)).orElseThrow(() -> new BusinessException("门店不存在"));
                    String region = orgStore.getRegion();
                    if (StrUtil.isNotBlank(region)) {
                        List<ScpStoreDemandCalendarDO> regionList = scpStoreDemandCalendarRepoProc.findByUniqueKeys(regionDeliveryType, "REGION", region, year, month, day);
                        calendarResultList.addAll(regionList);
                    }
                }
                storeAppletHomeVO.setOrderCalendar("W");
                if (CollectionUtil.isNotEmpty(calendarResultList)) {
                    Optional<ScpStoreDemandCalendarDO> scpStoreDemandCalendarDO = calendarResultList.stream().filter(calendar -> calendar.getWorkStatus().equals("W")).findAny();
                    if (scpStoreDemandCalendarDO.isEmpty()) {
                        storeAppletHomeVO.setOrderCalendar("E");
                    }
                }
            } else {
                storeAppletHomeVO.setOrderCalendar("W");
            }
        }, taskExecutor);
        CompletableFuture.allOf(future1, future2).join();

        return storeAppletHomeVO;
    }

    private int templateCount(String demandWhStCode, String type) {
        DemandOrderListParamVO vo = new DemandOrderListParamVO();
        vo.setDemandWhStCode(demandWhStCode);
        vo.setType(type);
        List<DemandOrderListRespVO> list = demandOrderTemplateService.list(vo);
        if (CollUtil.isEmpty(list)) {
            return 0;
        } else {
            return list.size();
        }
    }

    @Override
    public StoreTodoVO todo(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreTodoVO();
        }
        return storeReceiveRepoProc.findTodo(param);
    }

    private List<Long> findDocIds(StoreReceivePageParam param) {
        if (StrUtil.isNotBlank(param.getItemName()) || StrUtil.isNotBlank(param.getItemCode()) || StrUtil.isNotBlank(param.getItemKeyword())) {
            List<Long> itemIdByCodeName = itmItemRpcService.findItemIdByCodeName(param.getItemCode(),
                    param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty(itemIdByCodeName)) {
                return new ArrayList<>();
            }

            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List<Long> allLeafCateId = itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);

            List<Long> itemIdsByCate = storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new ArrayList<>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new ArrayList<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new ArrayList<>();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new ArrayList<>();
            }

            return param.getIds();
        }
        return null;
    }

    @Override
    public StoreReceiveTotalVO receiveTotal(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreReceiveTotalVO();
        }
        return storeReceiveRepoProc.findReceiveTotal(param);
    }

    @Override
    public StoreRtnTotalVO rtnCount(StoreReceivePageParam param) {
        List<Long> docIds = findDocIds(param);
        if (docIds != null && docIds.isEmpty()) {
            return new StoreRtnTotalVO();
        }
        return storeReceiveRepoProc.findRtnTotal(param);
    }
}
