package com.elitesland.scp.domain.entity.mrp;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;


/**
* @description: 千元用量表
* @author: wangly
* @create: 2025-03-28
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_thousand_use")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_thousand_use", comment = "千元用量表")
public class ScpThousandUseDO extends BaseModel implements Serializable {


    @Column(name = "id", columnDefinition = "bigint")
    @Comment("id")
    private Long id;

    @Column(name = "st_wh_id", columnDefinition = "bigint")
    @Comment("门店id")
    private Long stWhId;

    @Column(name = "st_wh_code", columnDefinition = "varchar(30)")
    @Comment("门店编码")
    private String stWhCode;

    @Column(name = "st_wh_name", columnDefinition = "varchar(30)")
    @Comment("门店名称")
    private String stWhName;

    @Column(name = "st_wh_type", columnDefinition = "varchar(30)")
    @Comment("门店类型")
    private String stWhType;

    @Column(name = "reference_data_start", columnDefinition = "datetime(6)")
    @Comment("参考日期开始")
    private Date referenceDataStart;

    @Column(name = "reference_data_end", columnDefinition = "datetime(6)")
    @Comment("参考日期结束")
    private Date referenceDataEnd;

    @Column(name = "valid_data_start", columnDefinition = "datetime(6)")
    @Comment("有效日期开始")
    private Date validDataStart;

    @Column(name = "valid_data_end", columnDefinition = "datetime(6)")
    @Comment("有效日期结束")
    private Date validDataEnd;



    @Column(name = "remark", columnDefinition = "varchar(255)")
    @Comment("备注")
    private String remark;

    @Column(name = "create_user_id", columnDefinition = "bigint")
    @Comment("记录创建者ID")
    private Long createUserId;

    @Column(name = "creator", columnDefinition = "varchar(255)")
    @Comment("记录创建者")
    private String creator;

    @Column(name = "create_time", columnDefinition = "datetime(6)")
    @Comment("记录创建时间")
    private LocalDateTime createTime;

    @Column(name = "modify_user_id", columnDefinition = "bigint")
    @Comment("记录最后更新者ID")
    private Long modifyUserId;

    @Column(name = "updater", columnDefinition = "varchar(255)")
    @Comment("记录最后更新者")
    private String updater;

    @Column(name = "modify_time", columnDefinition = "datetime(6)")
    @Comment("记录最后更新时间")
    private LocalDateTime modifyTime;


    @Column(name = "ext1", columnDefinition = "varchar(255)")
    @Comment("门店预测模版id")
    private String ext1;

    @Column(name = "ext2", columnDefinition = "varchar(255)")
    @Comment("拓展字段2")
    private String ext2;

    @Column(name = "ext3", columnDefinition = "varchar(255)")
    @Comment("拓展字段3")
    private String ext3;

    public void copy(ScpThousandUseDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}