/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScpDemandOrderDetailExportServiceImpl
implements DataExport<ScpDemandOrderExportRespVO, ScpDemandOrderPageParamVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDetailExportServiceImpl.class);
    private final ScpDemandOrderService scpDemandOrderService;
    private final OrgStoreRpcService orgStoreRpcService;

    public String getTmplCode() {
        return "scp_demand_order_detail_export";
    }

    @BusinessObjectOperation(permissionRef="scp_demand_order_detail_page", operationType=OperationTypeEnum.EXPORT, operationDescription="\u8ba2\u8d27\u5355\u660e\u7ec6\u5bfc\u51fa", businessObjectType="scp_demand_order:\u95e8\u5e97\u8ba2\u8d27\u5355", operationCode="scp_demand_order_detail_export", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        if (CollectionUtil.isNotEmpty(queryParamVO.getRegionCodes()) && CollectionUtil.isEmpty(queryParamVO.getDemandWhStCodesRegion())) {
            OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList<String>(queryParamVO.getRegionCodes()));
            List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                List<String> storeCodeList = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().toList();
                queryParamVO.setDemandWhStCodesRegion(storeCodeList);
                if (queryParamVO.getDemandWhStCodes() == null) {
                    queryParamVO.setDemandWhStCodes(storeCodeList);
                } else {
                    queryParamVO.getDemandWhStCodes().addAll(storeCodeList);
                }
            } else {
                return PagingVO.empty();
            }
        }
        return this.scpDemandOrderService.executeExport(queryParamVO);
    }

    public String exportFileName() {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return "\u8ba2\u8d27\u5355\u660e\u7ec6\u5bfc\u51fa_" + LocalDateTime.now().format(pattern);
    }

    public Integer pageSize() {
        return 1000;
    }

    public ScpDemandOrderDetailExportServiceImpl(ScpDemandOrderService scpDemandOrderService, OrgStoreRpcService orgStoreRpcService) {
        this.scpDemandOrderService = scpDemandOrderService;
        this.orgStoreRpcService = orgStoreRpcService;
    }
}

