/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.app;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAddItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAppCountParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.OrgStoreDboVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.AppDemandOrderCountRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.ValidatedList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79fb\u52a8\u7aef-\u8ba2\u8d27\u8ba2\u5355\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/app/order"}, produces={"application/json"})
public class AppDemandOrderController {
    private static final Logger log = LoggerFactory.getLogger(AppDemandOrderController.class);
    private final AppDemandOrderService appDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final CartRedisUtil cartRedisUtil;

    @PostMapping(value={"/submit"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u63d0\u4ea4")
    public ApiResult<Long> submit(@RequestBody @Validated ScpDemandOrderSubmitVO saveVO) {
        log.info("[APP-SCP-DEMAND-ORDER] submit  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(saveVO.getBusinessType())) {
            AddressParamVO addr = this.cartRedisUtil.getAddr();
            saveVO.setRecvCountry(addr.getCountry());
            saveVO.setRecvProvince(addr.getProvince());
            saveVO.setRecvCity(addr.getCity());
            saveVO.setRecvCounty(addr.getCounty());
            saveVO.setRecvDetailaddr(addr.getDetailAddr());
            saveVO.setRecvContactName(addr.getContPerson());
            saveVO.setRecvContactTel(addr.getTel());
            String storeCodes = addr.getOrgStoreList().stream().map(OrgStoreDboVO::getStoreCode).collect(Collectors.joining(","));
            String storeNames = addr.getOrgStoreList().stream().map(OrgStoreDboVO::getStoreName).collect(Collectors.joining(","));
            saveVO.setRenovationStore(storeCodes);
            saveVO.setRenovationStoreName(storeNames);
        }
        return ApiResult.ok((Object)this.appDemandOrderService.submit(saveVO));
    }

    @PostMapping(value={"/reOrder/{id}"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u91cd\u65b0\u4e0b\u5355")
    public ApiResult<Long> reOrder(@PathVariable Long id) {
        log.info("[APP-SCP-DEMAND-ORDER] reOrder  id ={}", (Object)id);
        return ApiResult.ok((Object)this.appDemandOrderService.reOrder(id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpDemandOrderPageRespVO>> queryDemandOrderList(@RequestBody ScpDemandOrderPageParamVO paramVO) {
        log.info("[APP-SCP-DEMAND-ORDER] queryDemandOrderList  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        if ("PEEDING".equals(paramVO.getDocStatus()) || CollectionUtil.isNotEmpty(paramVO.getDocStatusList()) && paramVO.getDocStatusList().contains("PEEDING")) {
            paramVO.setDocStatus(ScpUdcEnum.DEO_STATUS_SUBMIT.getValueCode());
        }
        return ApiResult.ok(this.scpDemandOrderService.queryDemandOrderHeader(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6 - \u67e5\u8be2\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6(\u5c0f\u7a0b\u5e8f\u7aef)")
    @PostMapping(value={"/detail/page"})
    public ApiResult<PagingVO<ScpDemandOrderDRespVO>> page(@RequestBody ScpDemandOrderDPageParamVO paramVO) {
        log.info("[APP-SCP-DEMAND-ORDER] page  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderDService.pageDemandOrderDByMasId(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6 - \u5220\u9664\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6(\u5c0f\u7a0b\u5e8f\u7aef)")
    @PostMapping(value={"/detail/remove/{id}"})
    public ApiResult<PagingVO<ScpDemandOrderDRespVO>> page(@PathVariable Long id) {
        this.scpDemandOrderDService.remove(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/detail/save"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6 - \u4fee\u6539")
    public ApiResult<Long> saveDemandOrderD(@RequestBody @Validated ValidatedList<ScpDemandOrderDSaveVO> saveVOS) {
        log.info("[APP-SCP-DEMAND-ORDER] saveDemandOrderD  saveVOS ={}", (Object)JSONUtil.toJsonStr(saveVOS));
        this.appDemandOrderService.batchSaveDemandOrderD(saveVOS);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ba2\u8d27\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpDemandOrderRespVO> findIdOne(@PathVariable Long id) {
        return ApiResult.ok((Object)this.appDemandOrderService.findDemandOrderById(id));
    }

    @PostMapping(value={"/addItem"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ffd\u52a0\u5546\u54c1")
    public ApiResult<Long> addItem(@RequestParam(value="masId") Long masId, @RequestBody @Validated ValidatedList<ScpDemandOrderAddItemParamVO> saveVOS) {
        log.info("[APP-SCP-DEMAND-ORDER] addItem  masId ={}, saveVOS ={}", (Object)masId, (Object)JSONUtil.toJsonStr(saveVOS));
        this.scpDemandOrderDService.addItem(masId, saveVOS);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u7edf\u8ba1\u6570\u636e")
    @PostMapping(value={"/countStatus"})
    public ApiResult<List<AppDemandOrderCountRespVO>> countStatus(@RequestBody ScpDemandOrderAppCountParamVO paramVO) {
        log.info("[APP-SCP-DEMAND-ORDER] countStatus  param ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderService.countStatus(paramVO));
    }

    @PostMapping(value={"/addCart"})
    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u518d\u6765\u4e00\u5355")
    public ApiResult<Long> addCart(@RequestParam(value="id") Long id) {
        this.appDemandOrderService.addCart(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u901a\u8fc7\u5173\u8054id\u652f\u4ed8\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/payInfo/{srcDocId}"})
    public ApiResult<AppPayOrderRespVO> findPayOrderBySrcDocId(@PathVariable Long srcDocId) {
        return ApiResult.ok((Object)this.appDemandOrderService.findPayOrderBySrcDocId(srcDocId));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u901a\u8fc7id\u83b7\u53d6\u652f\u4ed8\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/payInfo/id/{id}"})
    public ApiResult<AppPayOrderRespVO> findPayOrderById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.appDemandOrderService.findPayOrderById(id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u652f\u4ed8\u8ba2\u5355\u8be6\u60c5\u660e\u7ec6")
    @GetMapping(value={"/item/payInfo/{srcDocId}"})
    public ApiResult<AppPayOrderItemRespVO> findPayOrderItemBySrcDocId(@PathVariable Long srcDocId) {
        return ApiResult.ok((Object)this.appDemandOrderService.findPayOrderItemBySrcDocId(srcDocId));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u652f\u4ed8\u8ba2\u5355\u8be6\u60c5\u660e\u7ec6")
    @GetMapping(value={"/item/payInfo/id/{id}"})
    public ApiResult<AppPayOrderItemRespVO> findPayOrderItemById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.appDemandOrderService.findPayOrderItemById(id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ba2\u8d27\u5355\u8be6\u60c5\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/relate/{id}"})
    public ApiResult<List<AppRelateOrderRespVO>> findRelateOrderById(@PathVariable Long id) {
        return ApiResult.ok(this.appDemandOrderService.findRelateOrderById(id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u652f\u4ed8\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/pay/item/{docCls}/{id}"})
    public ApiResult<ScpOrderPayRespVO> payInfo(@PathVariable(value="docCls") String docCls, @PathVariable(value="id") Long id) {
        return ApiResult.ok((Object)this.appDemandOrderService.payInfo(docCls, id));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355(\u5f85\u63a8\u9001) - \u5173\u95ed")
    @PostMapping(value={"/close/{id}"})
    public ApiResult<List<ScpDemandOrderPayInfoRespVO>> close(@PathVariable Long id) {
        log.info("[APP-SCP-DEMAND-ORDER] close  param ={}", (Object)id);
        this.scpDemandOrderService.close(id, "APP");
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u8ba2\u8d27\u5355\u6839\u636e\u7f16\u7801\u67e5\u8be2id")
    @GetMapping(value={"/findIdByCode/{docCode}"})
    public ApiResult<Long> findIdByCode(@PathVariable(value="docCode") String docCode) {
        return ApiResult.ok((Object)this.appDemandOrderService.findIdByCode(docCode));
    }

    public AppDemandOrderController(AppDemandOrderService appDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpDemandOrderService scpDemandOrderService, CartRedisUtil cartRedisUtil) {
        this.appDemandOrderService = appDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpDemandOrderService = scpDemandOrderService;
        this.cartRedisUtil = cartRedisUtil;
    }
}

