package com.elitesland.scp.application.facade.vo.param.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "订货订单明细参数")
public class ScpDemandOrderItemBatchParamVO implements Serializable {
    private static final long serialVersionUID = 5231978221986074352L;


    @ApiModelProperty(value = "门店编码/仓库编码", required = true)
    @NotBlank(message = "门店编码/仓库编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求日期", required = true)
    @NotNull(message = "需求日期不能为空")
    private LocalDateTime demandDate;

    @ApiModelProperty(value = "类型", required = true)
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty(value = "单据类型", required = true)
    private String docType;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    private List<Item> itemList;

    @Data
    public static class Item {
        @ApiModelProperty(value = "商品ID", required = true)
        @NotNull(message = "商品ID不能为空")
        private Long itemId;

        @ApiModelProperty(value = "商品编码", required = true)
        @NotBlank(message = "商品编码不能为空")
        private String itemCode;

        @ApiModelProperty(value = "商品名称", required = true)
        @NotBlank(message = "商品名称不能为空")
        private String itemName;

        @ApiModelProperty(value = "商品品类编码")
        @NotBlank(message = "商品品类编码不能为空")
        private String itemCateCode;

        @ApiModelProperty(value = "商品品类名称")
        private String itemCateName;

        @ApiModelProperty(value = "SPU商品ID")
        private Long spuId;

        @ApiModelProperty("SPU商品编码")
        @NotNull(message = "SPU商品编码不能为空")
        private String spuItemCode;
        private String spuItemName;

        @ApiModelProperty(value = "商品单位", required = true)
        @NotBlank(message = "商品单位不能为空")
        private String uom;
        private String uomName;

        @ApiModelProperty(value = "需求数量")
        private BigDecimal demandQuantity;

        @ApiModelProperty("基本单位数量")
        private BigDecimal qty2;

        @ApiModelProperty("基本单位")
        private String uom2;

        @ApiModelProperty("基本单位名称")
        private String uom2Name;

        @ApiModelProperty("小数位数")
        private Integer decimalPlaces;

        @ApiModelProperty("单位转换率")
        private BigDecimal uomRatio;

        @ApiModelProperty("商品类型")
        private String itemType;

        private String url;

        @ApiModelProperty("强配活动ID")
        private Long activityId;

        @ApiModelProperty("强配活动编码")
        private String activityCode;
    }
}

