package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("订货订单支付信息")
public class ScpDemandOrderPayInfoRespVO implements Serializable {
    private static final long serialVersionUID = -7138791682639250353L;

    @ApiModelProperty("分配单据编码")
    private Long srcDocId;

    @ApiModelProperty("分配单据号")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String srcDocCls;
    private String srcDocClsName;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;
}
