package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货单评价分页返回")
public class ScpDemandOrderReplyPageRespVO implements Serializable {
    private static final long serialVersionUID = 783578236162418003L;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty(value = "订货单分数")
    private Integer orderScore;

    @ApiModelProperty(value = "物流分数")
    private Integer expressScore;

    @ApiModelProperty(value = "订货单分数文本")
    private String orderScoreStr;

    @ApiModelProperty(value = "物流分数文本")
    private String expressScoreStr;

    @ApiModelProperty(value = "订货单评论内容")
    private String comment;

    @ApiModelProperty(value = "订货单评论图片")
    private List<String> picList;

    private String pics;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

}
