package com.elitesland.scp.application.facade.vo.scpsman;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:06
 * @Description:
 */
@Data
public class SalesmanDetailInfoRespVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("计划员编号")
    private String scpsmanNo;

    @ApiModelProperty("计划员类型")
    private String scpsmanType;

    @ApiModelProperty("计划员类型名称")
    private String scpsmanTypeName;

    @ApiModelProperty("管辖区域")
    private String jurisdiction;

    @ApiModelProperty("管辖区域名称")
    private String jurisdictionName;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty("公司名称")
    private String ouName;







    private LocalDateTime joinTime;
    private String joinTimeLocalDate;


    /**
     * 用户账号
     */
    private String username;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;
    private String genderName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 办公电话、手机号
     */
    private String phone;

    /**
     * 生日
     */
    private String birthDate;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 省份名称
     */
    @ApiModelProperty(value = "省份名称", position = 1)
    private String provinceName;

    /**
     * 市名称
     */
    @ApiModelProperty(value = "市名称", position = 2)
    private String cityName;

    /**
     * 县名称
     */
    @ApiModelProperty(value = "县名称", position = 3)
    private String countyName;

    /**
     * 地址
     */
    private String address;

    /**
     * 组织ID
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;


    /**
     * 上级领导姓名
     */
    private String leaderUserFullName;

}