package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.util.*;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/18 周四
 */
@Component()
public class ScpsmanAuthorityManager {
    private static final Logger logger = LoggerFactory.getLogger(ScpsmanAuthorityManager.class);

    @Autowired
    private ScpsmanRegionRepoProc scpsmanRegionRepoProc;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    /**
     * 获取授权门店
     *
     * @param currentUser
     * @param size
     * @return
     */
    public Map<String, OrgStoreBaseRpcDTO> queryStoreList(GeneralUserDetails currentUser, @NotNull ScpsmanInfoDO scpsmanInfoDO, int size) {
        return queryStoreList(currentUser, scpsmanInfoDO, size, null);
    }

    /**
     * 获取授权门店
     *
     * @param currentUser
     * @param size
     * @return
     */
    public Map<String, OrgStoreBaseRpcDTO> queryStoreList(GeneralUserDetails currentUser, @NotNull ScpsmanInfoDO scpsmanInfoDO, int size, String keyword) {
        if (scpsmanInfoDO == null) {
            return Collections.emptyMap();
        }
        logger.info("获取授权门店：{}", scpsmanInfoDO.getScpsmanNo());

        // 是否店长
        List<String> userNames = currentUser == null ? Collections.emptyList() : getCandidateStoreCodeByUser(currentUser);
        if (!userNames.isEmpty()) {
            // 查询门店
            logger.info("查询门店：{}", JSONUtil.toJsonString(userNames));
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeList(userNames);
            if (size > 0) {
                storeParam.setLimitSize(size);
            }
            var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            logger.info("查询门店结果：{}", JSONUtil.toJsonString(storeList));
            if (CollUtil.isNotEmpty(storeList)) {
                Map<String, OrgStoreBaseRpcDTO> result = new HashMap<>(4);
                result.put(storeList.get(0).getStoreCode(), storeList.get(0));
                return result;
            }
        }

        // 所有门店
        if (Boolean.TRUE.equals(scpsmanInfoDO.getJurisdictionAll())) {
            logger.info("查询所有门店");
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeOrName(keyword);
            if (size > 0) {
                storeParam.setLimitSize(size);
            }
            var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            logger.info("查询门店结果：{}", JSONUtil.toJsonString(storeList));
            if (CollUtil.isEmpty(storeList)) {
                return Collections.emptyMap();
            }
            return storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1));
        }

        // 获取设置的管理区域
        var scpsmanRegionBoList = scpsmanRegionRepoProc.listBoByMasId(scpsmanInfoDO.getId());
        if (scpsmanRegionBoList.isEmpty()) {
            return Collections.emptyMap();
        }

        // 门店检索
        Set<String> filterStoreCodes = null;
        if (StrUtil.isNotBlank(keyword)) {
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeOrName(keyword);
            var storeList = orgStoreRpcService.findSimpleStoreByParam(storeParam).computeData();
            logger.info("查询门店结果：{}", JSONUtil.toJsonString(storeList));
            if (CollUtil.isEmpty(storeList)) {
                // 没有符合条件的门店
                return Collections.emptyMap();
            }
            filterStoreCodes = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).collect(Collectors.toSet());
        }
        if (filterStoreCodes == null) {
            filterStoreCodes = Collections.emptySet();
        }

        Set<String> storeCodes = new HashSet<>(16);
        Set<String> regionCodes = new HashSet<>(16);
        for (var scpsmanRegionBO : scpsmanRegionBoList) {
            if (size > 0 && storeCodes.size() > size) {
                break;
            }
            if (StrUtil.isBlank(scpsmanRegionBO.getRegionCode())) {
                continue;
            }
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode().equals(scpsmanRegionBO.getRegionType())) {
                // 门店
                if (!filterStoreCodes.isEmpty() && !filterStoreCodes.contains(scpsmanRegionBO.getRegionCode())) {
                    continue;
                }
                storeCodes.add(scpsmanRegionBO.getRegionCode());
                continue;
            }
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode().equals(scpsmanRegionBO.getRegionType())) {
                // 区域
                regionCodes.add(scpsmanRegionBO.getRegionCode());
                continue;
            }
            logger.error("计划员权限类型错误：{}", scpsmanRegionBO.getRegionType());
        }

        // 查询管理区域的门店
        Map<String, OrgStoreBaseRpcDTO> result = new HashMap<>(4000);
        // 查询管理的门店
        if (!storeCodes.isEmpty()) {
            logger.info("查询管理的门店：{}", JSONUtil.toJsonString(storeCodes));
            if (!storeCodes.isEmpty()) {
                OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
                param.setStoreCodeList(new ArrayList<>(storeCodes));
                param.setStoreCodeOrName(keyword);
                if (size > 0) {
                    param.setLimitSize(size);
                }
                var storeList = orgStoreRpcService.findSimpleStoreByParam(param).computeData();
                logger.info("查询门店结果：{}", JSONUtil.toJsonString(storeList));
                if (CollUtil.isNotEmpty(storeList)) {
                    result.putAll(storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1)));
                }
                if (size > 0 && result.size() >= size) {
                    return result;
                }
            }
        }
        if (!regionCodes.isEmpty()) {
            logger.info("查询管理区域的门店：{}", JSONUtil.toJsonString(regionCodes));
            OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList<>(regionCodes));
            param.setStoreCodeOrName(keyword);
            if (size > 0) {
                param.setLimitSize(size);
            }
            var storeList = orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            logger.info("查询门店结果：{}", JSONUtil.toJsonString(storeList));
            if (CollUtil.isNotEmpty(storeList)) {
                result.putAll(storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1)));
            }
            if (size > 0 && result.size() >= size) {
                return result;
            }
        }
        logger.info("查询门店结果3：{}", JSONUtil.toJsonString(result));
        return result;
    }

    private List<String> getCandidateStoreCodeByUser(GeneralUserDetails userDetails) {
        List<String> userNames = new ArrayList<>(4);

        String loginAccount = userDetails.getLoginAccount();
        if (StrUtil.isNotBlank(loginAccount)) {
            if (loginAccount.equals(userDetails.getUser().getMobile())) {
                // 手机号则直接返回
                return Collections.emptyList();
            }

            userNames.add(loginAccount);
        }
        if (StrUtil.isNotBlank(userDetails.getUser().getEmployeeCode())) {
            userNames.add(userDetails.getUser().getEmployeeCode());
        }
        return userNames;
    }
}
