package com.elitesland.scp.application.service.serviceconfig;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigExportRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigPageParamVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author chaofeng.xia
 * @since 2025/5/26
 */
@Component
@RequiredArgsConstructor
public class ScpServiceConfigServiceExportImpl implements DataExport<ScpServiceConfigExportRespVO, ScpServiceConfigPageParamVO> {

    private final ScpServiceConfigService scpServiceConfigService;

    @Override
    public String getTmplCode() {
        return "scp_service_config_export";
    }

    @Override
    public PagingVO<ScpServiceConfigExportRespVO> executeExport(ScpServiceConfigPageParamVO queryParam) {
        return scpServiceConfigService.exportSearch(queryParam);
    }


}
