package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderReplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Api(tags = "订货单评价接口")
@RestController
@RequestMapping(value = "/order/reply", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpDemandOrderReplyController {

    private final ScpDemandOrderReplyService scpDemandOrderReplyService;

    @ApiOperation("订货单评价 - 查询评价信息")
    @GetMapping("/findByOrderId/{orderId}")
    public ApiResult<ScpDemandOrderReplyRespVO> findByOrderId(@PathVariable Long orderId) {
        log.info("[SCP-ORDER-REPLY] findByOrderId, id ={}", orderId);
        return ApiResult.ok(scpDemandOrderReplyService.findReplyByOrderId(orderId));
    }

    @PostMapping("/save")
    @ApiOperation("订货单评价 - 评价")
    public ApiResult<Long> reply(@RequestBody @Validated ScpDemandOrderReplySaveVO saveVO) {
        log.info("[SCP-ORDER-REPLY] reply  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpDemandOrderReplyService.create(saveVO));
    }

    @ApiOperation(value = "订货单评价 - 分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpDemandOrderReplyPageRespVO>> page(@RequestBody ScpDemandOrderReplyPageParamVO paramVO) {
        log.info("[SCP-DEMAND-REPLY] page  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderReplyService.page(paramVO));
    }
}
