package com.elitesland.scp.domain.service.msg;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.ScpMessagePageMngQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessageEditRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.save.msg.ScpMessageSaveVO;

import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
public interface ScpMessageMngService {

    /**
     * 保存消息
     *
     * @param saveVO 消息信息
     * @return 消息ID
     */
    ApiResult<Long> save(ScpMessageSaveVO saveVO);

    /**
     * 删除消息
     *
     * @param ids  消息ID
     * @param real 是否真删除
     * @return 消息ID
     */
    ApiResult<Set<Long>> delete(Set<Long> ids, Boolean real);

    /**
     * 发布消息
     *
     * @param ids 消息ID
     * @return 消息ID
     */
    ApiResult<Set<Long>> execPublish(Set<Long> ids);

    /**
     * 撤回消息
     * <p>
     * 撤回已发布的消息
     *
     * @param ids 消息ID
     * @return 消息ID
     */
    ApiResult<Set<Long>> execRevoke(Set<Long> ids);

    /**
     * 获取编辑信息
     *
     * @param id 消息ID
     * @return 消息信息
     */
    ApiResult<ScpMessageEditRespVO> getEditVO(Long id);

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return 公共列表
     */
    ApiResult<PagingVO<ScpMessagePageRespVO>> pageMng(ScpMessagePageMngQueryVO queryVO);
}
