package com.elitesland.scp.infr.repo.order;

import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

public interface ScpDemandOrderRepo extends JpaRepository<ScpDemandOrderDO, Long>, QuerydslPredicateExecutor<ScpDemandOrderDO> {

    List<ScpDemandOrderDO> findByIdIn(List<Long> ids);

    Optional<ScpDemandOrderDO> findByDocCode(String docCode);

    List<ScpDemandOrderDO> findByDemandIdIn(List<Long> demandIds);

    List<ScpDemandOrderDO> findByDemandId(Long demandId);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from scp_demand_order where id in ?1", nativeQuery = true)
    void deleteByIdIn(List<Long> idList);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set reply_flag = true, modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateReplyById(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set doc_status = 'CLOSE', modify_time = CURRENT_TIMESTAMP, cancel_operator = ?2 where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void closeDemandOrder(Long id, String cancelOperator);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set modify_time = CURRENT_TIMESTAMP, cancel_operator = ?2 where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateDemandOrderCancelOperator(Long id, String cancelOperator);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set doc_status = ?2 ,modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateDocStatusById(Long id,String apprStatus);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set appr_status = ?2 ,appr_time = CURRENT_TIMESTAMP, modify_time = CURRENT_TIMESTAMP where id = ?1 and " +
            "delete_flag != 1", nativeQuery = true)
    void updateApprStatusById(Long id,String apprStatus);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_demand_order set eta_date = ?2 , modify_time = CURRENT_TIMESTAMP where id = ?1 and delete_flag != 1", nativeQuery = true)
    void updateEtaDateById(Long id, LocalDateTime etaDate);
}
