package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.order.ScpDemandOrderExportRespVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.common.ScpBusinessObjectConstant;
import com.elitesland.scp.common.ScpBusinessOperationConstant;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;



@Component
@Slf4j
@RequiredArgsConstructor
public class ScpDemandOrderDetailExportServiceImpl implements DataExport<ScpDemandOrderExportRespVO, ScpDemandOrderPageParamVO> {

    private final ScpDemandOrderService scpDemandOrderService;
    private final OrgStoreRpcService orgStoreRpcService;

    @Override
    public String getTmplCode() {
        return "scp_demand_order_detail_export";
    }

    @Override
    @BusinessObjectOperation(
            permissionRef = ScpBusinessOperationConstant.SCP_DEMAND_ORDER_DETAIL_PAGE,
            operationType = OperationTypeEnum.EXPORT,
            operationDescription = "订货单明细导出",
            businessObjectType = ScpBusinessObjectConstant.SCP_DEMAND_ORDER,
            operationCode = ScpBusinessOperationConstant.YST_SCP_DEMAND_ORDER_DETAIL_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<ScpDemandOrderExportRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        if (CollectionUtil.isNotEmpty(queryParamVO.getRegionCodes()) && CollectionUtil.isEmpty(queryParamVO.getDemandWhStCodesRegion())) {
            OrgStoreBaseRpcParam param = new OrgStoreBaseRpcParam();
            param.setRegionList(new ArrayList<>(queryParamVO.getRegionCodes()));
            var storeList = orgStoreRpcService.findSimpleStoreByParam(param).computeData();
            if (CollUtil.isNotEmpty(storeList)) {
                List<String> storeCodeList = storeList.stream().map(OrgStoreBaseRpcDTO::getStoreCode).distinct().toList();
                queryParamVO.setDemandWhStCodesRegion(storeCodeList);
                if (queryParamVO.getDemandWhStCodes() == null) {
                    queryParamVO.setDemandWhStCodes(storeCodeList);
                } else {
                    queryParamVO.getDemandWhStCodes().addAll(storeCodeList);
                }
            } else {
                return PagingVO.empty();
            }
        }
        return scpDemandOrderService.executeExport(queryParamVO);
    }

    @Override
    public String exportFileName() {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        return "订货单明细导出_"+ LocalDateTime.now().format(pattern);
    }
    @Override
    public Integer pageSize(){
        return 1000;
    }
}
