package com.elitesland.scp.application.web.purLimit;


import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreRefreshParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;
import com.elitesland.scp.application.service.purLimit.ScpPurLimitSettingService;
import com.elitesland.scp.utils.excel.listener.DchExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Slf4j
@Api(tags = "订货限购接口")
@RestController
@RequestMapping(value = "/purLimit/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpPurLimitSettingController {

    private final ScpPurLimitSettingService scpPurLimitSettingService;

    @ApiOperation(value = "订货限购-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpPurLimitSettingPageRespVO>> queryPurLimitSetting(@RequestBody ScpPurLimitSettingPageParamVO paramVO) {
        log.info("[SCP-PurLimit-SETTING] queryPurLimitSetting  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpPurLimitSettingService.page(paramVO));
    }

    @ApiOperation("订货限购 - 根据ID查询订货限购活动信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpPurLimitSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-PurLimit-SETTING] findIdOne, id ={}", id);
        return ApiResult.ok(scpPurLimitSettingService.findPurLimitSettingById(id));
    }

    @PostMapping("/save")
    @ApiOperation("订货限购 - 保存")
    public ApiResult<Long> savePurLimitSetting(@RequestBody @Validated ScpPurLimitSettingSaveVO saveVO) {
        log.info("[SCP-PurLimit-SETTING] savePurLimitSetting  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpPurLimitSettingService.savePurLimitSetting(saveVO));
    }

    @ApiOperation("订货限购 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpPurLimitSettingStatusParamVO paramVO) {
        log.info("[SCP-PurLimit-SETTING] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpPurLimitSettingService.changePurLimitSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货限购 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-PurLimit-SETTING] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpPurLimitSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation("订货限购门店缓存刷新")
    @PostMapping("/storeRefresh")
    public ApiResult<Object> storeRefresh(@RequestBody @Validated ScpAllocSettingStoreRefreshParamVO paramVO) {
        log.info("[SCP-PurLimit-SETTING] storeRefresh paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpPurLimitSettingService.storeRefresh(paramVO);
        return ApiResult.ok();
    }

    @PostMapping("/imports/store")
    @ApiOperation("明细门店导入")
    public ApiResult<List<ScpPurLimitSettingStoreRespVO>> importStoreData(MultipartFile file) throws InterruptedException {
        DchExcelEntityDataListener<ScpPurLimitSettingImportStoreParamVO> dataListener = new DchExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), ScpPurLimitSettingImportStoreParamVO.class, dataListener).sheet(0).headRowNumber(2).doRead();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ApiResult.fail("解析excel数据出现异常");
        }
        List<ScpPurLimitSettingImportStoreParamVO> list = dataListener.getDatas();
        return ApiResult.ok(scpPurLimitSettingService.importStoreData(list));
    }

}
