package com.elitesland.scp.domain.service.mrp;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;
import com.elitesland.scp.infr.repo.mrp.ScpMrpRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/1/15
 */
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpMrpDomainServiceImpl implements ScpMrpDomainService {

    private final ScpMrpRepo scpMrpRepo;

    private final ScpMrpRepoProc scpMrpRepoProc;


    @Override
    @SysCodeProc
    public PagingVO<ScpMrpRespVO> searchPage(ScpMrpPageParam param) {
        return scpMrpRepoProc.pageQuery(param);
    }

    @Override
    public List<ScpMrpDO> findByIds(List<Long> ids) {
        return scpMrpRepo.findAllById(ids);
    }

    @Override
    public ScpMrpDO findById(Long id) {
        return scpMrpRepo.findById(id).orElse(null);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpMrpRepo.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePushStatus(Long id, String pushStatus, String pushFailReason) {
        scpMrpRepoProc.updatePushStatus(List.of(id), pushStatus, pushFailReason);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePushStatus(List<Long> ids, String pushStatus, String pushFailReason) {
        scpMrpRepoProc.updatePushStatus(ids, pushStatus, pushFailReason);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<ScpMrpDO> saveList(List<ScpMrpDO> scpMrpDOs) {
        return scpMrpRepo.saveAll(scpMrpDOs);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ScpMrpDO save(ScpMrpDO scpMrpDO) {
        return scpMrpRepo.save(scpMrpDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCalcStatus(List<Long> ids, String calcStatus, String calcFailReason) {
        scpMrpRepoProc.updateCalcStatus(ids, calcStatus, calcFailReason);
    }

}