package com.elitesland.scp.domain.service.purLimit;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingRegionSaveVO;

import java.util.List;

public interface ScpPurLimitSettingRegionDomainService {

    /**
     * 订货强配活动区域查询
     *
     * @param masId
     * @return
     */
    List<ScpPurLimitSettingRegionRespVO> findByMasId(Long masId);

    /**
     * 订货强配活动配置保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveSettingRegion(List<ScpPurLimitSettingRegionSaveVO> saveVOS);

    /**
     * 删除订货强配活动区域
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动区域
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 区域分页查询
     * @param paramVO
     * @return
     */
    PagingVO<ScpPurLimitSettingRegionRespVO> page(ScpPurLimitSettingRegionPageParamVO paramVO);

    /**
     * 根据区域编码查询
     * @param regionCode
     * @return
     */
    List<Long> findMasIdByRegionCode(String regionCode);
}
