package com.elitesland.scp.application.facade.vo.resp.minOrder;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("订货起订详情返回")
public class ScpMinOrderSettingItemRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -7429845441661010333L;

    @ApiModelProperty("活动ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    private String itemType2;

    @ApiModelProperty("最小起订数量")
    private BigDecimal minNum;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("起订活动编码")
    private String activityCode;

    private String imgUrl;

}
