package com.elitesland.scp.application.web.app.util;

import com.elitesland.scp.application.web.app.enums.LoginAccountType;

import java.util.regex.Pattern;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 09月 16日 17:04
 * @version: 1.0
 */
public class AccountIdentifierUtil {
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^1[3-9]\\d{9}$");
    // 员工工号正则表达式 (示例: 以4位字母开头+4位数字结尾)
    private static final Pattern EMPLOYEE_ID_PATTERN = Pattern.compile("^[A-Za-z]{4}\\d{4,}$");

    public static LoginAccountType identifyAccountType(String input) {
        if (input == null || input.trim().isEmpty()) {
            return LoginAccountType.INVALID;
        }

        String trimmedInput = input.trim();
        // 优先判断是否为手机号
        if (isPhoneNumber(trimmedInput)) {
            return LoginAccountType.PHONE_NUMBER;
        }else{
            return LoginAccountType.EMPLOYEE_ID;
        }
    }

    private static boolean isPhoneNumber(String input) {
        return PHONE_NUMBER_PATTERN.matcher(input).matches();
    }


}
