package com.elitesland.scp.application.web.mrp;

import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefExportVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseVO;
import com.elitesland.scp.application.service.mrp.ScpThousandUseRefService;
import com.elitesland.scp.application.service.mrp.ScpThousandUseService;
import com.elitesland.scp.infr.repo.mrp.ScpThousandUseRefRepo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * 千元用量
 * @description:
 * @author: wangly
 * @create: 2025-03-28
 * @Version 1.0
 **/
@RequiredArgsConstructor
@RestController
@Api(tags = {""})
@RequestMapping("/mrp/scpThousandUse")
@Slf4j
public class ScpThousandUseController {

    private final ScpThousandUseService scpThousandUseService;
    /**
     * 千元用量-保存
     *
     * @folder 千元用量
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("/save")
    @ApiOperation("千元用量-新增")
    public ApiResult<Long> save(@RequestBody ScpThousandUseParam param){
        return ApiResult.ok(scpThousandUseService.save(param));
    }

    /**
     * 千元用量-更新
     *
     * @folder 千元用量
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("/update")
    @ApiOperation("千元用量-更新")
    public ApiResult<ScpThousandUseVO> update(@RequestBody ScpThousandUseParam param){
        return ApiResult.ok(scpThousandUseService.update(param));
    }

    /**
     * 千元用量-更新
     *
     * @folder 千元用量
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("updateByKeyDynamic")
    @ApiOperation("千元用量-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public ApiResult<Long> updateByKeyDynamic(@RequestBody ScpThousandUseParam param){
        return ApiResult.ok(scpThousandUseService.updateByKeyDynamic(param));
    }

    /**
     * 千元用量-主键查询
     *
     * @folder 千元用量
     * @param key 关键
     * @return {@link ApiResult}
     */
    @GetMapping("/{key}")
    @ApiOperation("千元用量-主键查询")
    public ApiResult<ScpThousandUseVO> queryOneByKey(@PathVariable Long key) {
        return ApiResult.ok(scpThousandUseService.queryByKey(key));
    }

    /**
     * 千元用量-分页
     *
     * @folder 千元用量
     * @param param 查询
     * @return {@link ApiResult}
     */
    @PostMapping("/paging")
    @ApiOperation("千元用量-分页")
    public ApiResult<PagingVO<ScpThousandUseVO>> paging(@RequestBody ScpThousandUseParam param) {
        return ApiResult.ok(scpThousandUseService.queryPaging(param));
    }

    /**
     * 千元用量-查询列表
     *
     * @folder 千元用量
     * @param param 查询
     * @return {@link ApiResult}
     */
    @PostMapping("/list")
    @ApiOperation("千元用量-查询列表")
    public ApiResult<List<ScpThousandUseVO>> queryList(@RequestBody ScpThousandUseParam param) {
        return ApiResult.ok(scpThousandUseService.queryListDynamic(param));
    }

    /**
     * 千元用量-删除
     *
     * @folder 千元用量
     * @param keys 主键id
     * @return result
     */
    @PostMapping("/delete")
    @ApiOperation("千元用量 - 删除")
    public ApiResult deleteByIds(@RequestBody List<Long> keys) {
        scpThousandUseService.deleteSoft(keys);
        return ApiResult.ok();
    }

    /**
     * 千元用量-计算
     *
     * @folder 千元用量
     * @return result
     */
    @GetMapping("/count")
    @ApiOperation("千元用量 - 计算")
    public ApiResult count() {
        scpThousandUseService.count();
        return ApiResult.ok();
    }


//    @PostMapping(value = "/export", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
//    @ApiOperation(value = "导出数据")
//    public ApiResult<Boolean> export(HttpServletResponse response, @RequestBody ScpThousandUseRefExportVO queryVO) {
//        try {
//            ScpThousandUseRefParam scpThousandUseRefParam = new ScpThousandUseRefParam();
//            List<ScpThousandUseRefVO> scpThousandUseRefVOS = scpThousandUseRefService.queryListDynamic(scpThousandUseRefParam);
//            exportExcelService.export(queryVO, response, param -> PagingVO.<ScpThousandUseRefVO>builder().records(scpThousandUseRefVOS).total(scpThousandUseRefVOS.size()).build());
//            return null;
//        } catch (Exception e) {
//            log.error("导出失败：", e);
//            return ApiResult.fail("导出失败：" + e.getMessage());
//        }
//    }

    /**
     * 千元用量-查询列表
     *
     * @folder 千元用量
     * @param param 查询
     * @return {@link ApiResult}
     */
    @PostMapping("/checkData")
    @ApiOperation("千元用量-数据校验")
    public ApiResult checkData(@RequestBody ScpThousandUseParam param) {
        scpThousandUseService.checkData(param);
        return ApiResult.ok();
    }


}